/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.apps.util;

import com.qizx.api.DataModelException;
import com.qizx.api.Item;
import com.qizx.api.Node;
import com.qizx.api.util.time.DateTime;
import java.text.SimpleDateFormat;
import java.util.Date;

public class Property {
    public static final String DATE_TIME = "dateTime";
    public static final String BOOLEAN = "boolean";
    public static final String DOUBLE = "double";
    public static final String INTEGER = "integer";
    public static final String STRING = "string";
    public static final String NODE = "node()";
    public static final String EXPRESSION = "<expression>";
    private static SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'hh:mm:ss.SSS");
    public String name;
    public String type;
    public String value;
    public Node nodeValue;
    public Item itemValue;

    public Property() {
    }

    public Property(String string, Object object) throws DataModelException {
        this.name = string;
        if (object instanceof Date) {
            this.value = new DateTime((Date)object, 0).toString();
            this.type = DATE_TIME;
        } else if (object instanceof Double) {
            this.type = DOUBLE;
        } else if (object instanceof Long || object instanceof Integer) {
            this.type = INTEGER;
        } else if (object instanceof Boolean) {
            this.type = BOOLEAN;
        } else if (object instanceof Node) {
            this.nodeValue = (Node)object;
            this.type = this.nodeValue.getNodeKind() + "()";
        } else {
            this.type = STRING;
        }
        if (this.nodeValue == null && this.value == null && object != null) {
            this.value = object.toString();
        }
    }

    public static boolean isNode(String string) {
        return string.endsWith("()");
    }

    public Object toObject() throws Exception {
        if (this.nodeValue != null) {
            return this.nodeValue;
        }
        if (this.itemValue != null) {
            return this.itemValue;
        }
        if (this.type.equals(DATE_TIME)) {
            return DateTime.parseDateTime(this.value.trim());
        }
        if (this.type.equals(INTEGER)) {
            return Long.valueOf(this.value.trim());
        }
        if (this.type.equals(DOUBLE)) {
            return Double.valueOf(this.value.trim());
        }
        if (this.type.equals(BOOLEAN)) {
            this.value = this.value.trim();
            if (this.value.equalsIgnoreCase("true")) {
                return Boolean.TRUE;
            }
            if (this.value.equalsIgnoreCase("false")) {
                return Boolean.FALSE;
            }
        } else {
            return this.value;
        }
        return null;
    }

    public String toString() {
        return "Property('" + this.name + "', type=" + this.type + ")";
    }
}

