/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.queries;

import com.qizx.api.DataModelException;
import com.qizx.api.fulltext.TextTokenizer;
import com.qizx.api.util.fulltext.DefaultTextTokenizer;
import com.qizx.queries.FullText;
import com.qizx.util.basic.Unicode;
import java.util.ArrayList;
import java.util.List;

public class SimpleFullText {
    protected String query;
    protected TextTokenizer tokenizer;
    private FullText.MatchOptions matchOptions;
    private Token[] tokens;
    private int tokenCount;
    private int from;
    private FullText.Any optTerms;
    private FullText.All reqTerms;
    private FullText.All negTerms;
    private static final int SPACE = 32;
    private static final int WORD = -1;
    private static final int STRING = -2;

    public SimpleFullText(TextTokenizer textTokenizer) {
        if (textTokenizer == null) {
            textTokenizer = new DefaultTextTokenizer();
        }
        this.tokenizer = textTokenizer;
    }

    public FullText.Selection parseQuery(String string, FullText.MatchOptions matchOptions) throws DataModelException {
        int n;
        FullText.Selection selection;
        this.tokens = SimpleFullText.tokenize(string);
        this.tokenCount = this.tokens.length;
        this.matchOptions = new FullText.MatchOptions(matchOptions);
        this.optTerms = new FullText.Any();
        this.reqTerms = new FullText.All();
        this.negTerms = new FullText.All();
        this.from = 0;
        while (this.from < this.tokenCount) {
            selection = this.parseTerm();
            if (selection == null) continue;
            this.optTerms.addChild(selection);
        }
        selection = new FullText.All();
        ((FullText.All)selection).matchOptions = matchOptions;
        this.optTerms.matchOptions = matchOptions;
        if (this.optTerms.getChildCount() == 1) {
            ((FullText.SelectionList)selection).addChild(this.optTerms.getChild(0));
        } else if (this.optTerms.getChildCount() > 0) {
            ((FullText.SelectionList)selection).addChild(this.optTerms);
        }
        for (n = 0; n < this.reqTerms.getChildCount(); ++n) {
            ((FullText.SelectionList)selection).addChild(this.reqTerms.getChild(n));
        }
        for (n = 0; n < this.negTerms.getChildCount(); ++n) {
            ((FullText.SelectionList)selection).addChild(this.negTerms.getChild(n));
        }
        if (((FullText.SelectionList)selection).getChildCount() == 0) {
            throw new DataModelException("void full-text query");
        }
        if (((FullText.SelectionList)selection).getChildCount() == 1) {
            return ((FullText.SelectionList)selection).getChild(0);
        }
        return selection;
    }

    private static Token[] tokenize(String string) {
        int n;
        int n2 = string.length();
        ArrayList<Token> arrayList = new ArrayList<Token>();
        boolean bl = true;
        int n3 = -1;
        char c = '\u0000';
        StringBuffer stringBuffer = null;
        for (n = 0; n < n2; ++n) {
            char c2 = string.charAt(n);
            boolean bl2 = false;
            switch (c2) {
                case '+': 
                case '-': {
                    if (bl) {
                        bl2 = true;
                    }
                    n3 = -1;
                    break;
                }
                case '~': {
                    bl2 = true;
                    n3 = -1;
                    break;
                }
                default: {
                    if (Character.isWhitespace(c2)) {
                        bl2 = true;
                        if (n3 >= 0) break;
                        n3 = 0;
                        break;
                    }
                    n3 = -1;
                }
            }
            bl = bl2;
            if (bl2) {
                if (c != '\u0000') {
                    stringBuffer.append(c2);
                    continue;
                }
                if (stringBuffer != null) {
                    arrayList.add(new Token(-1, stringBuffer.toString()));
                    stringBuffer = null;
                }
                if (n3 >= 0) {
                    if (n3 != 0) continue;
                    n3 = 1;
                    arrayList.add(new Token(32, " "));
                    continue;
                }
                arrayList.add(new Token(c2, Character.toString(c2)));
                continue;
            }
            if (stringBuffer == null) {
                stringBuffer = new StringBuffer();
                switch (c2) {
                    case '\"': 
                    case '\'': {
                        c = c2;
                        break;
                    }
                    default: {
                        stringBuffer.append(c2);
                        break;
                    }
                }
                continue;
            }
            if (c2 == c) {
                int n4 = stringBuffer.length() - 1;
                if (n4 > 0 && stringBuffer.charAt(n4) == '\\') {
                    stringBuffer.setCharAt(n4, c);
                    continue;
                }
                arrayList.add(new Token(-2, stringBuffer.toString()));
                stringBuffer = null;
                c = '\u0000';
                continue;
            }
            stringBuffer.append(c2);
        }
        if (stringBuffer != null) {
            arrayList.add(new Token(c != '\u0000' ? -2 : -1, stringBuffer.toString()));
        }
        if ((n = arrayList.size()) > 0) {
            Token token = (Token)arrayList.get(0);
            if (token.code == 32) {
                arrayList.remove(0);
                --n;
            }
        }
        if (n > 0) {
            Token token = (Token)arrayList.get(n - 1);
            if (token.code == 32) {
                arrayList.remove(n - 1);
                --n;
            }
        }
        Token[] tokenArray = new Token[n];
        return arrayList.toArray(tokenArray);
    }

    private FullText.Selection parseTerm() {
        this.from = SimpleFullText.skipSpace(this.tokens, this.from, this.tokenCount);
        if (this.from >= this.tokenCount) {
            return null;
        }
        int n = this.tokens[this.from].code;
        String string = this.tokens[this.from].lexeme;
        switch (n) {
            case -2: 
            case -1: {
                int n2;
                int n3 = -1;
                if (n == -2 && this.from + 2 < this.tokenCount && this.tokens[this.from + 1].code == 126 && this.tokens[this.from + 2].code == -1) {
                    try {
                        n3 = Integer.parseInt(this.tokens[this.from + 2].lexeme);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    this.from += 3;
                } else {
                    ++this.from;
                }
                this.startTokenizerForWildcards(string);
                FullText.Phrase phrase = new FullText.Phrase();
                phrase.matchOptions = this.matchOptions;
                int n4 = 0;
                while ((n2 = this.tokenizer.nextToken()) != 0) {
                    if (n2 != 1) continue;
                    char[] cArray = this.tokenizer.getTokenChars();
                    FullText.Selection selection = this.tokenizer.gotWildcard() ? new FullText.Wildcard(cArray) : new FullText.SimpleWord(cArray);
                    selection.matchOptions = this.matchOptions;
                    phrase.addChild(selection);
                    ++n4;
                }
                if (n3 > 0 && n4 > 1) {
                    FullText.PosFilters posFilters = new FullText.PosFilters(true);
                    posFilters.window = n3 + n4;
                    phrase.setPosFilters(posFilters);
                }
                SimpleFullText.skipToSpace(this.tokens, this.from, this.tokenCount);
                if (n4 == 0) {
                    return null;
                }
                return n4 == 1 ? phrase.getChild(0) : phrase;
            }
            case 43: 
            case 45: {
                if (this.from + 1 < this.tokenCount && (this.tokens[this.from + 1].code == -1 || this.tokens[this.from + 1].code == -2)) {
                    ++this.from;
                    FullText.Selection selection = this.parseTerm();
                    if (selection != null) {
                        if (n == 43) {
                            this.reqTerms.addChild(selection);
                        } else {
                            FullText.Not not = new FullText.Not();
                            not.setChild(selection);
                            not.matchOptions = this.matchOptions;
                            this.negTerms.addChild(not);
                        }
                    }
                    SimpleFullText.skipToSpace(this.tokens, this.from, this.tokenCount);
                } else {
                    ++this.from;
                }
                return null;
            }
        }
        ++this.from;
        return null;
    }

    private static int skipSpace(Token[] tokenArray, int n, int n2) {
        while (n < n2 && tokenArray[n].code == 32) {
            ++n;
        }
        return n;
    }

    private static int skipToSpace(Token[] tokenArray, int n, int n2) {
        while (n < n2 && tokenArray[n].code != 32) {
            ++n;
        }
        return n;
    }

    private void startTokenizerForWildcards(String string) {
        boolean bl;
        this.tokenizer.setAcceptingWildcards(false);
        boolean bl2 = string.indexOf(63) >= 0;
        boolean bl3 = bl = string.indexOf(42) >= 0;
        if (bl2 || bl) {
            if (string.indexOf(46) >= 0) {
                string = string.replaceAll("\\.", "\\.");
            }
            if (bl2) {
                string = string.replaceAll("\\?", ".{1,1}");
            }
            if (bl) {
                string = string.replaceAll("\\*", ".*");
            }
            this.tokenizer.setAcceptingWildcards(true);
        }
        this.tokenizer.start(string);
    }

    /*
     * Enabled aggressive block sorting
     */
    private List tokenizeWithWildcards(String string) {
        boolean bl;
        this.tokenizer.setAcceptingWildcards(false);
        boolean bl2 = string.indexOf(63) >= 0;
        boolean bl3 = bl = string.indexOf(42) >= 0;
        if (bl2 || bl) {
            if (string.indexOf(46) >= 0) {
                string = string.replaceAll("\\.", "\\.");
            }
            if (bl2) {
                string = string.replaceAll("\\?", ".{1,1}");
            }
            if (bl) {
                string = string.replaceAll("\\*", ".*");
            }
            this.tokenizer.setAcceptingWildcards(true);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        this.tokenizer.start(string);
        while (true) {
            switch (this.tokenizer.nextToken()) {
                case 1: {
                    int n = this.tokenizer.getTokenOffset();
                    int n2 = n + this.tokenizer.getTokenLength();
                    String string2 = string.substring(n, n2);
                    string2 = Unicode.collapseDiacritic(string2);
                    arrayList.add(string2);
                    break;
                }
                case 0: {
                    return arrayList;
                }
            }
        }
    }

    private static final class Token {
        public final int code;
        public final String lexeme;

        public Token(int n, String string) {
            this.code = n;
            this.lexeme = string;
        }

        public String toString() {
            switch (this.code) {
                case -1: {
                    return "WORD: " + this.lexeme;
                }
                case -2: {
                    return "STRING:\"" + this.lexeme + '\"';
                }
            }
            return "'" + (char)this.code + '\'';
        }
    }
}

