/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.queries.iterators;

import com.qizx.api.EvaluationException;
import com.qizx.api.Node;
import com.qizx.api.fulltext.Scorer;
import com.qizx.queries.iterators.PolyIterator;
import com.qizx.queries.iterators.PostingIterator;

public class OrIterator
extends PolyIterator {
    protected int iterCount;
    protected PostingIterator current;
    protected int activeCnt;
    protected PostingIterator[] active;

    public OrIterator(PostingIterator[] postingIteratorArray) {
        this(postingIteratorArray, postingIteratorArray.length);
    }

    public OrIterator(PostingIterator[] postingIteratorArray, int n) {
        super(postingIteratorArray);
        this.iterCount = n;
        this.active = new PostingIterator[n];
    }

    public PostingIterator bornAgain() {
        return this.copyConstraints(new OrIterator(OrIterator.bornAgain(this.iterators, this.iterCount)));
    }

    public int getNodeSpan() {
        return this.matchEnd - this.curNodeId;
    }

    public int getDepth() {
        return this.current == null ? 0 : this.current.getDepth();
    }

    public int getRankOfCurrent() {
        int n = this.iterators.length;
        while (--n >= 0) {
            if (this.current != this.iterators[n]) continue;
            return n;
        }
        return -1;
    }

    public boolean skipToDoc(int n) throws EvaluationException {
        this.curNodeId = -1;
        this.activeCnt = 0;
        this.curDocId = 0x7FFFFFFE;
        int n2 = this.iterCount;
        while (--n2 >= 0) {
            PostingIterator postingIterator = this.iterators[n2];
            if (!postingIterator.skipToDoc(n)) continue;
            int n3 = postingIterator.getDocId();
            if (n3 < this.curDocId) {
                this.activeCnt = 1;
                this.active[0] = postingIterator;
                this.curDocId = n3;
                this.curNodeId = -1;
                continue;
            }
            if (n3 != this.curDocId) continue;
            this.active[this.activeCnt++] = postingIterator;
        }
        return this.activeCnt > 0;
    }

    protected boolean basicSkipToNode(int n, int n2) throws EvaluationException {
        this.curNodeId = 0x7FFFFFFE;
        this.current = null;
        this.matchEnd = n;
        int n3 = this.activeCnt;
        while (--n3 >= 0) {
            PostingIterator postingIterator = this.active[n3];
            if (postingIterator == null) continue;
            if (!postingIterator.skipToNode(n, n2)) {
                if (!postingIterator.reachedEnd()) continue;
                this.active[n3] = null;
                continue;
            }
            int n4 = postingIterator.getNodeId();
            if (n4 >= this.curNodeId) continue;
            this.curNodeId = n4;
            this.current = postingIterator;
            this.matchEnd = postingIterator.getNodeEnd();
        }
        return this.current != null;
    }

    public boolean inRange(int n, int n2) throws EvaluationException {
        for (int i = 0; i < this.activeCnt; ++i) {
            PostingIterator postingIterator = this.active[i];
            if (postingIterator == null || !postingIterator.inRange(n, n2)) continue;
            this.curNodeId = postingIterator.getNodeId();
            this.matchEnd = postingIterator.getNodeEnd();
            if (this.constraints != null && !this.checkFTConstraints(n, n2) || !this.checkFilters()) continue;
            this.current = postingIterator;
            return true;
        }
        return false;
    }

    public void resetToNode(int n) {
        this.activeCnt = 0;
        int n2 = this.iterCount;
        while (--n2 >= 0) {
            PostingIterator postingIterator = this.iterators[n2];
            if (postingIterator.getDocId() != this.curDocId) continue;
            this.active[this.activeCnt++] = postingIterator;
            postingIterator.resetToNode(n);
        }
        this.currentResetPos = n;
        this.curNodeId = n - 1;
    }

    public double getFulltextScore(Node node) throws EvaluationException {
        if (this.scoringInfo != null) {
            return this.doScoring(node);
        }
        double d = -1.0;
        for (int i = 0; i < this.iterators.length; ++i) {
            double d2 = this.iterators[i].getFulltextScore(node);
            if (!(d2 > d)) continue;
            d = d2;
        }
        return d;
    }

    public float computeWeighting(Scorer scorer) {
        float[] fArray = new float[this.iterCount];
        for (int i = 0; i < this.iterCount; ++i) {
            fArray[i] = this.iterators[i].computeWeighting(scorer);
        }
        this.weightNorm = scorer.normOr(fArray);
        return this.weight / this.weightNorm;
    }

    public float computeScore(Scorer scorer) {
        if (this.subScores == null) {
            this.subScores = new float[this.iterCount];
        }
        for (int i = 0; i < this.iterCount; ++i) {
            this.subScores[i] = this.iterators[i].getDocId() == this.getDocId() ? this.iterators[i].computeScore(scorer) : 0.0f;
        }
        return this.weight * this.weightNorm * scorer.scoreOr(this.subScores, this.iterCount);
    }
}

