/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.queries.iterators;

import com.qizx.api.EvaluationException;
import com.qizx.api.fulltext.FullTextFactory;
import com.qizx.queries.iterators.ContainerIterator;
import com.qizx.queries.iterators.PostingIterator;
import com.qizx.queries.iterators.PostingIteratorBase;
import java.util.Arrays;
import java.util.Comparator;

public abstract class PolyIterator
extends PostingIteratorBase {
    protected PostingIterator[] iterators;
    protected Constraints constraints;
    protected int currentResetPos;
    protected int matchEnd;
    protected float[] subScores;
    private PostingIterator[] orderedChildren;
    public static Comparator iteratorCompar = new Comparator(){

        public int compare(Object object, Object object2) {
            PostingIterator postingIterator = (PostingIterator)object;
            PostingIterator postingIterator2 = (PostingIterator)object2;
            return postingIterator.getNodeId() - postingIterator2.getNodeId();
        }
    };

    public PolyIterator(PostingIterator[] postingIteratorArray) {
        this.iterators = postingIteratorArray;
    }

    protected PostingIterator[] copy(PostingIterator[] postingIteratorArray) {
        PostingIterator[] postingIteratorArray2 = new PostingIterator[this.iterators.length];
        for (int i = 0; i < postingIteratorArray2.length; ++i) {
            postingIteratorArray2[i] = this.iterators[i].bornAgain();
        }
        return postingIteratorArray2;
    }

    protected PostingIterator copyConstraints(PolyIterator polyIterator) {
        polyIterator.constraints = this.constraints;
        polyIterator.setOrdered(this.ordered);
        return this.copyFilters(polyIterator);
    }

    public void resetToNode(int n) {
        int n2 = this.iterators.length;
        for (int i = 0; i < n2; ++i) {
            this.iterators[i].resetToNode(n);
        }
    }

    public void resetDoc() {
        this.curDocId = -1;
        this.curNodeId = -1;
        int n = this.iterators.length;
        for (int i = 0; i < n; ++i) {
            this.iterators[i].resetDoc();
        }
    }

    public boolean skipToDoc(int n) throws EvaluationException {
        if (this.iterators.length == 0) {
            this.changeDoc(n);
            return true;
        }
        while (true) {
            int n2 = 0x7FFFFFFE;
            int n3 = 0;
            int n4 = this.iterators.length;
            while (--n4 >= 0) {
                if (!this.iterators[n4].skipToDoc(n)) {
                    return this.noMoreDocs();
                }
                int n5 = this.iterators[n4].getDocId();
                if (n5 > n3) {
                    n3 = n5;
                }
                if (n5 >= n2) continue;
                n2 = n5;
            }
            if (n3 == n2) {
                this.changeDoc(n2);
                return true;
            }
            n = n3;
        }
    }

    public int getNodeId() {
        return this.curNodeId;
    }

    public int getNodeEnd() {
        return this.matchEnd;
    }

    public void setDistanceConstraint(int n, int n2) {
        if (this.constraints == null) {
            this.constraints = new Constraints();
        }
        this.constraints.minDistance = n;
        this.constraints.maxDistance = n2;
    }

    public void setWindowConstraint(int n) {
        if (this.constraints == null) {
            this.constraints = new Constraints();
        }
        this.constraints.window = n;
    }

    public void setContentConstraint(int n) {
        this.constraints.content = n;
    }

    public int computeWordDistance(int n, int n2) throws EvaluationException {
        return this.iterators[0].computeWordDistance(n, n2);
    }

    public boolean checkWordDistance(int n, int n2, int n3, int n4, int n5) throws EvaluationException {
        return this.iterators[0].checkWordDistance(n, n2, n3, n4, n5);
    }

    public boolean checkBoundary(int n, int n2, boolean bl) throws EvaluationException {
        PostingIterator[] postingIteratorArray = this.getChildrenInOrder();
        if (bl) {
            return postingIteratorArray[0].checkBoundary(n, n2, bl);
        }
        return postingIteratorArray[postingIteratorArray.length - 1].checkBoundary(n, n2, bl);
    }

    public int closestTextNode(int n, int n2, boolean bl) {
        if (this.iterators.length == 0) {
            return 0;
        }
        return this.iterators[0].closestTextNode(n, n2, bl);
    }

    public void initContainer(ContainerIterator containerIterator, FullTextFactory fullTextFactory) {
        this.setContainer(containerIterator, fullTextFactory);
        int n = this.iterators.length;
        for (int i = 0; i < n; ++i) {
            this.iterators[i].initContainer(containerIterator, fullTextFactory);
        }
    }

    protected boolean checkFTConstraints(int n, int n2) throws EvaluationException {
        int n3;
        int n4;
        int n5;
        if (this.constraints == null) {
            return true;
        }
        PostingIterator[] postingIteratorArray = this.getChildrenInOrder();
        int n6 = postingIteratorArray.length;
        if (n6 == 0) {
            return false;
        }
        PostingIterator postingIterator = postingIteratorArray[0];
        PostingIterator postingIterator2 = postingIteratorArray[n6 - 1];
        if (this.constraints.window > 0 && !postingIterator.checkWordDistance(postingIterator.getNodeId(), postingIterator2.getNodeEnd(), 1, 0, this.constraints.window)) {
            return false;
        }
        if (this.constraints.minDistance >= 0 || this.constraints.maxDistance >= 0) {
            for (n5 = 0; n5 < n6 - 1; ++n5) {
                n4 = postingIteratorArray[n5].getNodeEnd();
                if (postingIteratorArray[n5].checkWordDistance(n4, n3 = postingIteratorArray[n5 + 1].getNodeId(), -1, this.constraints.minDistance, this.constraints.maxDistance)) continue;
                return false;
            }
        }
        if (this.constraints.content != 0) {
            switch (this.constraints.content) {
                case 1: {
                    if (postingIterator.checkBoundary(postingIterator.getNodeId(), n, true)) break;
                    return false;
                }
                case 2: {
                    if (postingIterator.checkBoundary(postingIterator2.getNodeEnd(), n2, false)) break;
                    return false;
                }
                case 3: {
                    if (!postingIterator.checkBoundary(postingIterator.getNodeId(), n, true) || !postingIterator2.checkBoundary(postingIterator2.getNodeEnd(), n2, false)) {
                        return false;
                    }
                    n5 = postingIterator.getNodeEnd();
                    for (n4 = 1; n4 < n6; ++n4) {
                        if (postingIteratorArray[n4].getNodeId() > n5 + 1) {
                            return false;
                        }
                        n3 = postingIteratorArray[n4].getNodeEnd();
                        if (n3 > n5) {
                            n5 = n3;
                        }
                        if (postingIteratorArray[n4].checkContiguity()) continue;
                        return false;
                    }
                    break;
                }
            }
        }
        return true;
    }

    public PostingIterator[] getChildrenInOrder() {
        if (this.orderedChildren == null) {
            this.orderedChildren = new PostingIterator[this.iterators.length];
            int n = this.iterators.length;
            while (--n >= 0) {
                this.orderedChildren[n] = this.iterators[n];
            }
        }
        Arrays.sort(this.orderedChildren, iteratorCompar);
        return this.orderedChildren;
    }

    protected static class Constraints {
        int minDistance = -1;
        int maxDistance = -1;
        int window = -1;
        int content;

        protected Constraints() {
        }
    }
}

