/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.queries.iterators;

import com.qizx.api.DataModelException;
import com.qizx.api.Node;
import com.qizx.api.fulltext.FullTextFactory;
import com.qizx.api.fulltext.Stemmer;
import com.qizx.api.fulltext.TextTokenizer;
import com.qizx.queries.FullText;
import com.qizx.queries.Query;
import com.qizx.queries.iterators.PostingIterator;
import com.qizx.queries.iterators.PostingIteratorBase;
import com.qizx.util.StringPattern;
import com.qizx.util.basic.Util;
import com.qizx.xdm.FONIDataModel;
import java.util.Arrays;
import java.util.HashSet;
import java.util.regex.PatternSyntaxException;

public class TokenStream
implements Query.Instantiator {
    private FullTextFactory factory;
    private TextTokenizer tokenizer;
    private int tokenCount;
    private char[][] tokens;
    private Node[] nodes;
    private int[] offsets;
    private int[] lengths;

    public TokenStream(FullTextFactory fullTextFactory, String string) {
        this.factory = fullTextFactory;
        this.tokenizer = fullTextFactory.getTokenizer(string);
        this.tokenizer.setAcceptingWildcards(false);
        this.tokenizer.setParsingSpecialChars(false);
        int n = 8;
        this.tokens = new char[n][];
        this.nodes = new Node[n];
        this.offsets = new int[n];
        this.lengths = new int[n];
    }

    public void reset() {
        this.tokenCount = 0;
    }

    public int countTokens(String string) {
        int n = 0;
        this.tokenizer.start(string);
        int n2 = this.tokenizer.nextToken();
        while (n2 != 0) {
            if (n2 == 1) {
                ++n;
            }
            n2 = this.tokenizer.nextToken();
        }
        return n;
    }

    public void parseText(char[] cArray, Node node) {
        this.tokenizer.start(cArray, cArray.length);
        this.doTokenize(node);
    }

    public void parseText(String string, Node node) {
        this.tokenizer.start(string);
        this.doTokenize(node);
    }

    private void doTokenize(Node node) {
        int n = this.tokenizer.nextToken();
        while (n != 0) {
            if (n == 1) {
                this.add(this.tokenizer.getTokenChars(), node, this.tokenizer.getTokenOffset(), this.tokenizer.getTokenLength());
            }
            n = this.tokenizer.nextToken();
        }
    }

    private void add(char[] cArray, Node node, int n, int n2) {
        if (this.tokenCount >= this.tokens.length) {
            int n3 = this.tokenCount * 2;
            Node[] nodeArray = this.nodes;
            this.nodes = new Node[n3];
            System.arraycopy(nodeArray, 0, this.nodes, 0, this.tokenCount);
            char[][] cArray2 = this.tokens;
            this.tokens = new char[n3][];
            System.arraycopy(cArray2, 0, this.tokens, 0, this.tokenCount);
            int[] nArray = this.offsets;
            this.offsets = new int[n3];
            System.arraycopy(nArray, 0, this.offsets, 0, this.tokenCount);
            nArray = this.lengths;
            this.lengths = new int[n3];
            System.arraycopy(nArray, 0, this.lengths, 0, this.tokenCount);
        }
        this.tokens[this.tokenCount] = cArray;
        this.nodes[this.tokenCount] = node;
        this.offsets[this.tokenCount] = n;
        this.lengths[this.tokenCount] = n2;
        ++this.tokenCount;
    }

    public void parseWords(Node node, HashSet hashSet) throws DataModelException {
        if (hashSet != null && hashSet.contains(node)) {
            return;
        }
        switch (node.getNodeNature()) {
            case 1: 
            case 2: {
                for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
                    this.parseWords(node2, hashSet);
                }
                break;
            }
            case 7: {
                char[] cArray = node.getCharValue();
                if (cArray == null) {
                    System.err.println("TokenStream.parseWords : " + node);
                    break;
                }
                this.parseText(cArray, node);
                break;
            }
            case 3: {
                char[] cArray = node.getCharValue();
                this.parseText(cArray, node);
            }
        }
    }

    public void complete() {
    }

    public int getTokenCount() {
        return this.tokenCount;
    }

    public int getTokenStart(int n) {
        return this.offsets[n];
    }

    public int getTokenLength(int n) {
        return this.lengths[n];
    }

    public FullTextFactory getScoringFactory() {
        return null;
    }

    public TextTokenizer getTokenizer() {
        return this.tokenizer;
    }

    public PostingIterator enumWord(char[] cArray, FullText.MatchOptions matchOptions) {
        return new TokenIterator(cArray, matchOptions);
    }

    public PostingIterator enumWildcard(char[] cArray, FullText.MatchOptions matchOptions) {
        int n = FullText.MatchOptions.caseMode(matchOptions);
        boolean bl = FullText.MatchOptions.diacMode(matchOptions);
        try {
            return new WildcardIterator(FullText.MatchOptions.compilePattern(cArray, n, bl));
        }
        catch (PatternSyntaxException patternSyntaxException) {
            return new TokenIterator(new char[]{'?'}, matchOptions);
        }
    }

    public PostingIterator enumDocElements() {
        return null;
    }

    public PostingIterator enumDocNodes() {
        return null;
    }

    public PostingIterator singleNodeIterator(FONIDataModel.FONINode fONINode) {
        return null;
    }

    protected class WildcardIterator
    extends TokenIterator {
        StringPattern pattern;

        public WildcardIterator(StringPattern stringPattern) {
            super(null, false, false);
            this.pattern = stringPattern;
        }

        public PostingIterator bornAgain() {
            return this.copyFilters(new WildcardIterator(this.pattern));
        }

        protected boolean basicSkipToNode(int n, int n2) {
            this.curNodeId = n;
            while (this.curNodeId < TokenStream.this.tokenCount) {
                char[] cArray = TokenStream.this.tokens[this.curNodeId];
                if (this.pattern.match(cArray) == 0) {
                    return true;
                }
                ++this.curNodeId;
            }
            return this.noMoreNodes();
        }
    }

    protected class TokenIterator
    extends PostingIteratorBase {
        char[] word;
        boolean caseSense;
        boolean diacriticSense;
        Stemmer stemmer;

        public TokenIterator(char[] cArray, FullText.MatchOptions matchOptions) {
            int n;
            if (matchOptions.stemming == 1) {
                this.stemmer = TokenStream.this.factory.getStemmer(matchOptions.language);
                if (this.stemmer != null) {
                    cArray = this.stemmer.stem(cArray);
                }
            }
            this.caseSense = (n = FullText.MatchOptions.caseMode(matchOptions)) != 2;
            this.diacriticSense = FullText.MatchOptions.diacMode(matchOptions);
            this.word = n == 4 || n == 3 ? FullText.MatchOptions.mapPattern(cArray, n, this.diacriticSense) : cArray;
            this.curNodeId = -1;
        }

        public TokenIterator(char[] cArray, boolean bl, boolean bl2) {
            this.word = cArray;
            this.caseSense = bl;
            this.diacriticSense = bl2;
            this.curNodeId = -1;
        }

        public PostingIterator bornAgain() {
            return this.copyFilters(new TokenIterator(this.word, this.caseSense, this.diacriticSense));
        }

        public boolean skipToDoc(int n) {
            this.changeDoc(n);
            if (n >= 1) {
                return this.noMoreDocs();
            }
            return true;
        }

        protected boolean basicSkipToNode(int n, int n2) {
            this.curNodeId = n;
            while (this.curNodeId < TokenStream.this.tokenCount) {
                if (this.equalTokens(this.curNodeId)) {
                    return true;
                }
                ++this.curNodeId;
            }
            return this.noMoreNodes();
        }

        protected boolean equalTokens(int n) {
            char[] cArray = TokenStream.this.tokens[n];
            if (this.stemmer != null) {
                cArray = this.stemmer.stem(cArray);
            }
            if (cArray.length != this.word.length) {
                return false;
            }
            if (this.caseSense && this.diacriticSense) {
                return Arrays.equals(cArray, this.word);
            }
            return Util.prefixCompare(cArray, this.word, this.word.length, this.caseSense, this.diacriticSense) == 0;
        }

        public void resetToNode(int n) {
            this.curNodeId = n < 0 ? -1 : n - 1;
        }

        public boolean checkWordDistance(int n, int n2, int n3, int n4, int n5) {
            int n6 = Math.abs(n2 - n) + n3;
            return n6 >= n4 && (n5 < 0 || n6 <= n5);
        }

        public boolean checkBoundary(int n, int n2, boolean bl) {
            if (bl) {
                return n <= 0;
            }
            return n >= TokenStream.this.tokenCount - 1;
        }

        public int computeWordDistance(int n, int n2) {
            return Math.abs(n2 - n);
        }
    }
}

