/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.util.basic;

import com.qizx.util.basic.PlatformUtil;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Properties;

public class CLOptions {
    String appName;
    Option[] options = new Option[1];
    String[] args;
    int argp;
    int anonymous;
    int HELP_TAB = 22;
    static final char ARG_SET = '.';
    static final char ARG_RESET = '-';
    static final char ARG_NEXT = '_';
    static final char ARG_STUCK = ':';
    static final char ARG_ALL = '*';
    static final char ARG_SELF = '@';
    static final char ARG_SECTION = '#';
    static final char ACT_SET = '=';
    static final char ACT_ADD = '+';
    static final char ACT_PROP = '[';
    static final char ACT_CALL = '!';
    static final char ACT_HELP = '?';

    public CLOptions(String string) {
        this.appName = string;
    }

    public static Properties getDefaultProperties(String string) {
        Properties properties = new Properties();
        String string2 = PlatformUtil.rcFileName(string);
        try {
            FileInputStream fileInputStream = new FileInputStream(string2);
            properties.load(fileInputStream);
            ((InputStream)fileInputStream).close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return properties;
    }

    public void define(String string, String string2, String string3, String string4) {
        char c = '@';
        if (string != null) {
            c = string.charAt(string.length() - 1);
            string = string.substring(0, string.length() - 1);
        }
        Option option = new Option(string, c, string2, string3.charAt(0), string3.substring(1), string4);
        if (string == null) {
            this.options[0] = option;
        } else {
            Option[] optionArray = this.options;
            this.options = new Option[optionArray.length + 1];
            System.arraycopy(optionArray, 0, this.options, 0, optionArray.length);
            this.options[optionArray.length] = option;
        }
    }

    public void defineSection(String string) {
        this.define("#", "", "#", string);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void parse(String[] stringArray, Object object) throws Exception {
        this.args = stringArray;
        this.argp = 0;
        try {
            String[] stringArray2;
            Object object2;
            block20: while (this.argp < stringArray.length) {
                if ((object2 = this.matchOption((String)(stringArray2 = stringArray[this.argp++]))) == null) {
                    throw new Error("unknown option: " + (String)stringArray2);
                }
                String[] stringArray3 = null;
                switch (((Option)object2).syntax) {
                    case '@': {
                        stringArray3 = stringArray2;
                        break;
                    }
                    case '.': {
                        stringArray3 = Boolean.TRUE;
                        break;
                    }
                    case '-': {
                        stringArray3 = Boolean.FALSE;
                        break;
                    }
                    case '_': {
                        if (this.argp >= stringArray.length) {
                            throw new Error("option " + ((Option)object2).key + " requires an argument");
                        }
                        stringArray3 = stringArray[this.argp++];
                        break;
                    }
                    case ':': {
                        stringArray3 = stringArray2.substring(((Option)object2).key.length());
                        break;
                    }
                    case '*': {
                        String[] stringArray4 = new String[stringArray.length - this.argp];
                        System.arraycopy(stringArray, this.argp, stringArray4, 0, stringArray4.length);
                        stringArray3 = stringArray4;
                        this.argp = stringArray.length;
                        break;
                    }
                    default: {
                        throw new RuntimeException("illegal option syntax: " + ((Option)object2).syntax);
                    }
                }
                switch (((Option)object2).action) {
                    case '=': {
                        this.setField(object, ((Option)object2).key, ((Option)object2).actName, stringArray3);
                        continue block20;
                    }
                    case '+': {
                        this.addToField(object, ((Option)object2).key, ((Option)object2).actName, stringArray3);
                        continue block20;
                    }
                    case '[': {
                        this.addToProperties(object, ((Option)object2).key, ((Option)object2).actName, stringArray3);
                        continue block20;
                    }
                    case '!': {
                        this.callMethod(object, ((Option)object2).key, ((Option)object2).actName, stringArray3);
                        continue block20;
                    }
                    case '?': {
                        throw new Error("help:");
                    }
                }
                throw new RuntimeException("illegal option action: " + ((Option)object2).action);
            }
            try {
                stringArray2 = object.getClass().getDeclaredMethod("finish", new Class[0]);
                stringArray2.invoke(object, (Object[])null);
                return;
            }
            catch (InvocationTargetException invocationTargetException) {
                object2 = invocationTargetException.getCause();
                if (!(object2 instanceof java.lang.Error)) throw (Exception)invocationTargetException.getCause();
                throw (java.lang.Error)object2;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                return;
            }
        }
        catch (Error error) {
            System.err.println("*** " + error.getMessage());
            this.printHelp(System.err);
            throw error;
        }
    }

    public void printHelp(PrintStream printStream) {
        printStream.print("usage: " + this.appName + " [options] ");
        if (this.options[0] != null) {
            printStream.println(this.options[0].argLabel);
        }
        if (this.options[0] != null) {
            this.printHelp(printStream, this.options[0]);
        }
        for (int i = 1; i < this.options.length; ++i) {
            this.printHelp(printStream, this.options[i]);
        }
    }

    void printHelp(PrintStream printStream, Option option) {
        String string = option.help;
        if (string == null) {
            return;
        }
        String string2 = option.key == null ? "" : option.key;
        int n = string2.length();
        if (option.syntax != '#') {
            printStream.print("  " + string2);
            if (option.syntax != ':') {
                printStream.print(' ');
                ++n;
            }
            n += option.argLabel.length();
            printStream.print(option.argLabel);
            while (n < this.HELP_TAB) {
                printStream.print(' ');
                ++n;
            }
        } else {
            printStream.println();
        }
        String[] stringArray = string.split("\n");
        printStream.println(" " + stringArray[0]);
        for (int i = 1; i < stringArray.length; ++i) {
            for (n = -2; n < this.HELP_TAB; ++n) {
                printStream.print(' ');
            }
            printStream.println(" " + stringArray[i]);
        }
    }

    private Option matchOption(String string) {
        int n = this.options.length;
        while (--n > 0) {
            if (!this.options[n].key.equals(string) && (this.options[n].syntax != ':' || !string.startsWith(this.options[n].key))) continue;
            return this.options[n];
        }
        if (string.startsWith("-")) {
            return null;
        }
        return this.options[0];
    }

    void callMethod(Object object, String string, String string2, Object object2) throws Exception {
        try {
            Method method = object.getClass().getDeclaredMethod(string2, object2.getClass());
            method.invoke(object, object2);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getCause();
            if (throwable instanceof java.lang.Error) {
                throw (java.lang.Error)throwable;
            }
            throw (Exception)throwable;
        }
        catch (Exception exception) {
            System.err.println("Error in option " + string + ":" + exception);
            throw exception;
        }
    }

    public void setField(Object object, String string, String string2, Object object2) throws Exception {
        try {
            Field field = object.getClass().getField(string2);
            Class<?> clazz = field.getType();
            if (clazz == Integer.TYPE) {
                field.setInt(object, Integer.parseInt((String)object2));
            } else if (clazz == Float.TYPE) {
                field.setFloat(object, Float.parseFloat((String)object2));
            } else if (clazz == Double.TYPE) {
                field.setDouble(object, Double.parseDouble((String)object2));
            } else if (clazz == Boolean.TYPE) {
                if (object2 instanceof String) {
                    field.setBoolean(object, object2.equals("1") || ((String)object2).equalsIgnoreCase("yes") || ((String)object2).equalsIgnoreCase("true"));
                } else {
                    field.set(object, object2);
                }
            } else {
                if (field.get(object) != null) {
                    throw new Error("duplicate value for " + (string == null ? "argument" : "option " + string));
                }
                field.set(object, object2);
            }
        }
        catch (Error error) {
            throw error;
        }
        catch (Exception exception) {
            System.err.println("Error in option " + string + ": " + exception);
            throw exception;
        }
    }

    public void addToField(Object object, String string, String string2, Object object2) throws Exception {
        try {
            Field field = object.getClass().getField(string2);
            Class<?> clazz = field.getType();
            if (clazz.isArray()) {
                String[] stringArray = (String[])field.get(object);
                String[] stringArray2 = null;
                if (object2 instanceof String) {
                    int n = stringArray == null ? 0 : stringArray.length;
                    stringArray2 = new String[n + 1];
                    if (n > 0) {
                        System.arraycopy(stringArray, 0, stringArray2, 0, n);
                    }
                    stringArray2[n] = (String)object2;
                } else {
                    String[] stringArray3 = (String[])object2;
                    stringArray2 = new String[stringArray.length + stringArray3.length];
                    System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
                    System.arraycopy(stringArray3, 0, stringArray2, stringArray.length, stringArray3.length);
                }
                field.set(object, stringArray2);
            } else {
                field.set(object, object2);
            }
        }
        catch (Exception exception) {
            System.err.println("Error in option " + string + ": " + exception);
            throw exception;
        }
    }

    void addToProperties(Object object, String string, String string2, Object object2) throws Exception {
        try {
            Field field = object.getClass().getField(string2);
            Properties properties = (Properties)field.get(object);
            String string3 = (String)object2;
            int n = string3.indexOf(61);
            if (n < 0) {
                throw new Error("illegal property: " + string3 + " for " + string);
            }
            properties.setProperty(string3.substring(0, n), string3.substring(n + 1));
        }
        catch (Exception exception) {
            System.err.println("Error in option " + string + ": " + exception);
            throw exception;
        }
    }

    public static class Error
    extends Exception {
        public Error() {
        }

        public Error(String string) {
            super(string);
        }
    }

    protected static class Option {
        String key;
        String argLabel;
        String actName;
        String help;
        char syntax;
        char action;

        Option(String string, char c, String string2, char c2, String string3, String string4) {
            this.key = string;
            this.syntax = c;
            this.argLabel = string2;
            this.action = c2;
            this.actName = string3;
            this.help = string4;
        }
    }
}

