/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.xdm;

import com.qizx.api.DataModelException;
import com.qizx.api.QName;
import com.qizx.util.NamespaceContext;
import com.qizx.xdm.IQName;
import org.xml.sax.Attributes;

public class AttributeList
implements Attributes {
    protected IQName[] attrNames;
    protected String[] attrValues;
    protected String[] attrTypes;
    protected int attrCnt;
    protected NamespaceContext nsContext = new NamespaceContext();

    public void reset() {
        this.attrCnt = 0;
    }

    public boolean addAttribute(QName qName, String string, String string2) {
        for (int i = 0; i < this.attrCnt; ++i) {
            if (!qName.equals(this.attrNames[i])) continue;
            this.attrValues[i] = string;
            return false;
        }
        this.rawAddAttribute(qName, string, string2);
        return true;
    }

    protected void rawAddAttribute(QName qName, String string, String string2) {
        if (this.attrNames == null) {
            return;
        }
        if (this.attrCnt >= this.attrNames.length) {
            IQName[] iQNameArray = this.attrNames;
            this.attrNames = new IQName[iQNameArray.length * 2];
            System.arraycopy(iQNameArray, 0, this.attrNames, 0, iQNameArray.length);
            String[] stringArray = this.attrValues;
            this.attrValues = new String[this.attrNames.length];
            System.arraycopy(stringArray, 0, this.attrValues, 0, stringArray.length);
            stringArray = this.attrTypes;
            this.attrTypes = new String[this.attrNames.length];
            System.arraycopy(stringArray, 0, this.attrTypes, 0, stringArray.length);
        }
        this.attrNames[this.attrCnt] = IQName.get(qName);
        this.attrValues[this.attrCnt] = string;
        this.attrTypes[this.attrCnt] = string2;
        ++this.attrCnt;
    }

    public int getIndex(QName qName) {
        int n = this.attrCnt;
        while (--n >= 0) {
            if (this.attrNames[n] != qName) continue;
            return n;
        }
        return -1;
    }

    public int getIndex(String string) {
        try {
            return this.getIndex(this.nsContext.expandName(string));
        }
        catch (DataModelException dataModelException) {
            return -1;
        }
    }

    public int getIndex(String string, String string2) {
        return this.getIndex(IQName.get(string, string2));
    }

    public int getLength() {
        return this.attrCnt;
    }

    public int getAttributeCount() {
        return this.attrCnt;
    }

    public String getLocalName(int n) {
        return n < 0 || n >= this.attrCnt ? null : this.attrNames[n].getLocalPart();
    }

    public String getURI(int n) {
        return n < 0 || n >= this.attrCnt ? null : this.attrNames[n].getNamespaceURI();
    }

    public String getQName(int n) {
        return n < 0 || n >= this.attrCnt ? null : this.nsContext.prefixedName(this.attrNames[n]);
    }

    public String getType(int n) {
        String string = this.attrTypes == null || n < 0 || n >= this.attrCnt ? null : this.attrTypes[n];
        return string == null ? "CDATA" : string;
    }

    public String getType(String string) {
        return "CDATA";
    }

    public String getType(String string, String string2) {
        return "CDATA";
    }

    public String getValue(int n) {
        return n < 0 || n >= this.attrCnt ? null : this.attrValues[n];
    }

    public String getValue(String string) {
        return this.getValue(this.getIndex(string));
    }

    public String getValue(String string, String string2) {
        return this.getValue(this.getIndex(string, string2));
    }

    public int getNamespaceCount() {
        return this.nsContext.getLocalSize();
    }

    public String getNamespacePrefix(int n) {
        return this.nsContext.getLocalPrefix(n);
    }

    public String getNamespaceURI(int n) {
        return this.nsContext.getLocalNamespaceURI(n);
    }

    public NamespaceContext getNamespaceContext() {
        return this.nsContext;
    }
}

