/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.xdm;

import com.qizx.api.DataModelException;
import com.qizx.api.QName;
import com.qizx.util.NamespaceContext;
import com.qizx.xdm.BasicNode;
import com.qizx.xdm.CoreDataModel;
import com.qizx.xdm.IQName;
import com.qizx.xdm.XMLPushStreamBase;

public class CorePushBuilder
extends XMLPushStreamBase {
    protected CoreDataModel dm;
    protected CoreDataModel.CoreNode root;
    protected CoreDataModel.CoreNode leafRoot;
    protected CoreDataModel.Element current;
    protected CoreDataModel.CoreNode previous;
    protected int orderStamp = 1;

    public CorePushBuilder(String string) {
        this(string, null);
    }

    public CorePushBuilder(String string, NamespaceContext namespaceContext) {
        this.dm = new CoreDataModel(string);
        this.contextualMappings = namespaceContext;
    }

    public BasicNode harvest() {
        return this.root != null ? this.root : this.leafRoot;
    }

    public String getNSURI(String string) {
        return this.current == null ? null : this.current.getNamespaceUri(string);
    }

    public void reset() {
        super.reset();
        this.current = null;
        this.leafRoot = null;
        this.root = null;
        this.previous = null;
    }

    public void flush() {
    }

    public boolean putDocumentStart() {
        this.spaceNeeded = false;
        if (this.root != null) {
            return false;
        }
        this.current = this.dm.newDocumentNode();
        this.root = this.current;
        this.previous = null;
        return true;
    }

    public void putDocumentEnd() throws DataModelException {
        this.spaceNeeded = false;
        this.closeNode();
        this.spaceNeeded = false;
    }

    public void flushElementStart(boolean bl) throws DataModelException {
        this.spaceNeeded = false;
        this.completeNameMappings();
        this.elementStarted = false;
    }

    public void putElementStart(QName qName) throws DataModelException {
        if (this.maxVolume > 0L && this.volume > this.maxVolume) {
            throw new DataModelException("volume limit reached");
        }
        if (this.elementStarted) {
            this.flushElementStart(false);
        }
        this.spaceNeeded = false;
        this.elementName = IQName.get(qName);
        this.elementStarted = true;
        this.attrCnt = 0;
        CoreDataModel.Element element = this.dm.newElement(qName);
        this.openNode(element);
        this.nsContext.newLevel();
    }

    public void putElementEnd(QName qName) throws DataModelException {
        if (this.maxVolume > 0L && this.volume > this.maxVolume) {
            throw new DataModelException("volume limit reached");
        }
        if (this.elementStarted) {
            this.flushElementStart(false);
        }
        this.nsContext.popLevel();
        this.closeNode();
    }

    public boolean putNamespace(String string, String string2) throws DataModelException {
        if (this.current == null) {
            throw new DataModelException("stray namespace");
        }
        if (string2 == null) {
            string2 = "";
        }
        if (!this.addNSMapping(string, string2)) {
            throw new DataModelException("XQST0071", "duplicate namespace declaration '" + string + "'");
        }
        return true;
    }

    protected boolean addNSMapping(String string, String string2) {
        this.nsContext.addMapping(string, string2);
        CoreDataModel.NSNode nSNode = this.dm.newNSNode(string);
        nSNode.strValue = string2;
        if (!this.current.addNamespace(nSNode)) {
            return false;
        }
        this.volume += (long)(string.length() + string2.length());
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void putAttribute(QName qName, String string, String string2) throws DataModelException {
        if (this.maxVolume > 0L && this.volume > this.maxVolume) {
            throw new DataModelException("volume limit reached");
        }
        CoreDataModel.Attribute attribute = this.dm.newAttribute(qName);
        attribute.strValue = string;
        attribute.order = this.orderStamp++;
        if (this.current == null) {
            if (this.root != null || this.leafRoot != null) throw new DataModelException("invalid placement for attribute");
            this.leafRoot = attribute;
        } else {
            if (this.current.getFirstChild() != null) {
                throw new DataModelException("XQTY0024", "attribute added after contents");
            }
            if (!this.current.addAttribute(attribute)) {
                throw new DataModelException("XQDY0025", "duplicate attribute " + qName);
            }
        }
        this.rawAddAttribute(qName, string, string2);
        this.volume += (long)(10 + string.length());
        if (qName != IQName.XML_ID) return;
        this.dm.addId(string, this.current);
    }

    public void putText(String string) throws DataModelException {
        if (string == null || string.length() == 0) {
            return;
        }
        if (this.maxVolume > 0L && this.volume > this.maxVolume) {
            throw new DataModelException("volume limit reached");
        }
        if (this.elementStarted) {
            this.flushElementStart(false);
        }
        if (this.previous != null && this.previous.getNodeNature() == 7) {
            this.previous.addText(string);
        } else {
            this.addNode(this.dm.newTextNode(string));
        }
        this.spaceNeeded = false;
        this.volume += (long)string.length();
    }

    public void putProcessingInstruction(String string, String string2) throws DataModelException {
        this.checkPIValue(string2);
        if (this.maxVolume > 0L && this.volume > this.maxVolume) {
            throw new DataModelException("volume limit reached");
        }
        if (this.elementStarted) {
            this.flushElementStart(false);
        }
        CoreDataModel.PINode pINode = this.dm.newPINode(string, string2);
        this.addNode(pINode);
        this.volume += (long)string2.length();
        this.spaceNeeded = false;
    }

    public void putComment(String string) throws DataModelException {
        this.checkCommentValue(string);
        if (this.maxVolume > 0L && this.volume > this.maxVolume) {
            throw new DataModelException("volume limit reached");
        }
        if (this.elementStarted) {
            this.flushElementStart(false);
        }
        CoreDataModel.CommentNode commentNode = this.dm.newCommentNode(string);
        this.addNode(commentNode);
        this.volume += (long)string.length();
        this.spaceNeeded = false;
    }

    private void addNode(CoreDataModel.CoreNode coreNode) throws DataModelException {
        coreNode.parent = this.current;
        if (this.previous != null) {
            this.previous.setNextSibling(coreNode);
            if (this.current == null) {
                this.current = this.dm.newDocumentNode();
                this.root = this.current;
                this.current.firstChild = this.previous;
                this.previous.parent = coreNode.parent = this.current;
            }
        } else if (this.current == null) {
            if (this.root != null) {
                throw new DataModelException("adding node after root");
            }
            if (coreNode instanceof CoreDataModel.Element) {
                this.current = (CoreDataModel.Element)coreNode;
                this.root = this.current;
            } else {
                if (this.leafRoot != null) {
                    throw new DataModelException("invalid node type for document root");
                }
                this.leafRoot = coreNode;
            }
        } else {
            this.current.firstChild = coreNode;
        }
        this.previous = coreNode;
        coreNode.order = this.orderStamp++;
    }

    private void openNode(CoreDataModel.Element element) throws DataModelException {
        this.addNode(element);
        this.current = element;
        this.previous = null;
        this.volume += 10L;
    }

    private void closeNode() throws DataModelException {
        if (this.current == null) {
            if (this.maxVolume > 0L && this.volume > this.maxVolume) {
                return;
            }
            throw new DataModelException("no open element");
        }
        this.previous = this.current;
        this.current = this.current.parent;
        this.volume += 10L;
        this.spaceNeeded = false;
    }
}

