/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.xdm;

public class FloatConversion {
    private static final double ROUNDING_BIAS = 1.0 + 0.5 * Math.pow(2.0, -24.0);

    public static String toString(float f) {
        if ((double)f == 0.0) {
            return 1.0f / f < 0.0f ? "-0" : "0";
        }
        if (f != f) {
            return "NaN";
        }
        if (f == Float.POSITIVE_INFINITY) {
            return "INF";
        }
        if (f == Float.NEGATIVE_INFINITY) {
            return "-INF";
        }
        float f2 = Math.abs(f);
        if (f2 >= 1.0E-6f && f2 < 1000000.0f) {
            return FloatConversion.format(f, -1, 7);
        }
        return FloatConversion.format(f, 0, 7);
    }

    public static String toString(double d) {
        if (d == 0.0) {
            return 1.0 / d < 0.0 ? "-0" : "0";
        }
        if (d != d) {
            return "NaN";
        }
        if (d == Double.POSITIVE_INFINITY) {
            return "INF";
        }
        if (d == Double.NEGATIVE_INFINITY) {
            return "-INF";
        }
        double d2 = Math.abs(d);
        if (d2 >= 1.0E-6 && d2 < 1000000.0) {
            return FloatConversion.format(d, -1, 15);
        }
        return FloatConversion.format(d, 0, 15);
    }

    private static int insert(char[] cArray, int n, int n2, char c) {
        int n3 = n2;
        while (--n3 >= n) {
            cArray[n3 + 1] = cArray[n3];
        }
        cArray[n] = c;
        return n2 + 1;
    }

    private static String format(double d, int n, int n2) {
        int n3;
        boolean bl;
        boolean bl2 = d < 0.0;
        double d2 = bl2 ? -d : d;
        int n4 = 0;
        if (d2 < 1.0) {
            while (d2 < 1.0E-5) {
                d2 *= 100000.0;
                n4 -= 5;
            }
            while (d2 < 1.0) {
                d2 *= 10.0;
                --n4;
            }
        } else {
            while (d2 >= 1000000.0) {
                d2 *= 1.0E-5;
                n4 += 5;
            }
            while (d2 >= 10.0) {
                d2 *= 0.1;
                ++n4;
            }
        }
        char[] cArray = new char[n2 + 7 + 6];
        int n5 = n2 + 1;
        FloatConversion.rawConvert(d2, cArray, n2 + 2);
        if (n2 < 13 && cArray[n2 + 1] > '0' && FloatConversion.rawConvert(d2 *= ROUNDING_BIAS, cArray, n2 + 2)) {
            ++n4;
        }
        boolean bl3 = bl = n >= 0;
        if (!bl) {
            while (n4 < 0) {
                n5 = FloatConversion.insert(cArray, 0, n5, '0');
                ++n4;
            }
            n = n4;
        }
        int n6 = n3 = bl ? n + 2 : n + 1;
        while (n5 > n3 && cArray[n5 - 1] == '0') {
            --n5;
        }
        if (n + 1 != n5) {
            n5 = FloatConversion.insert(cArray, n + 1, n5, '.');
        }
        if (bl2) {
            n5 = FloatConversion.insert(cArray, 0, n5, '-');
        }
        if ((n4 -= n) != 0) {
            int n7;
            cArray[n5++] = 69;
            if (n4 < 0) {
                cArray[n5++] = 45;
                n4 = -n4;
            }
            if (n4 >= 100) {
                n7 = n4 / 100;
                cArray[n5++] = (char)(48 + n7);
                n4 -= n7 * 100;
            }
            if (n4 >= 10) {
                n7 = n4 / 10;
                cArray[n5++] = (char)(48 + n7);
                n4 -= n7 * 10;
            }
            cArray[n5++] = (char)(48 + n4);
        }
        return new String(cArray, 0, n5);
    }

    private static boolean rawConvert(double d, char[] cArray, int n) {
        boolean bl = false;
        if (d >= 10.0) {
            d /= 10.0;
            bl = true;
        }
        for (int i = 0; i < n; ++i) {
            int n2 = (int)d;
            cArray[i] = (char)(n2 + 48);
            d = 10.0 * (d - (double)n2);
        }
        return bl;
    }
}

