/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.xdm;

import com.qizx.api.QName;
import com.qizx.api.XMLPullStream;
import com.qizx.xdm.IQName;

public abstract class XMLPullStreamBase
implements XMLPullStream {
    protected int curEvent;
    protected String encoding;
    protected String dtdName;
    protected String dtdPublicId;
    protected String dtdSystemId;
    protected String dtdInternalSubset;
    protected int attrCount;
    private QName[] attrNames = new QName[2];
    private String[] attrValues = new String[2];
    protected char[] charBuffer;
    protected int charCount;
    protected String piTarget;
    protected int nsCount;
    private QName[] namespaces;

    public int getCurrentEvent() {
        return this.curEvent;
    }

    protected int setEvent(int n) {
        this.curEvent = n;
        return this.curEvent;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public String getDTDName() {
        return this.dtdName;
    }

    public String getDTDPublicId() {
        return this.dtdPublicId;
    }

    public String getDTDSystemId() {
        return this.dtdSystemId;
    }

    public String getInternalSubset() {
        return this.dtdInternalSubset;
    }

    public int getAttributeCount() {
        if (this.attrCount < 0) {
            this.lazyGetAttrs();
        }
        return this.attrCount;
    }

    public QName getAttributeName(int n) {
        if (this.attrCount < 0) {
            this.lazyGetAttrs();
        }
        return this.attrNames[n];
    }

    public String getAttributeValue(int n) {
        if (this.attrCount < 0) {
            this.lazyGetAttrs();
        }
        return this.attrValues[n];
    }

    protected void lazyGetAttrs() {
    }

    protected void addAttribute(QName qName, String string) {
        if (this.attrCount >= this.attrNames.length) {
            QName[] qNameArray = this.attrNames;
            this.attrNames = new QName[qNameArray.length * 2];
            System.arraycopy(qNameArray, 0, this.attrNames, 0, qNameArray.length);
            String[] stringArray = this.attrValues;
            this.attrValues = new String[this.attrNames.length];
            System.arraycopy(stringArray, 0, this.attrValues, 0, stringArray.length);
        }
        this.attrNames[this.attrCount] = qName;
        this.attrValues[this.attrCount++] = string;
    }

    public int getNamespaceCount() {
        if (this.nsCount < 0) {
            this.lazyGetNS();
        }
        return this.nsCount;
    }

    public String getNamespacePrefix(int n) {
        if (this.nsCount < 0) {
            this.lazyGetNS();
        }
        return this.namespaces[n].getLocalPart();
    }

    public String getNamespaceURI(int n) {
        if (this.nsCount < 0) {
            this.lazyGetNS();
        }
        return this.namespaces[n].getNamespaceURI();
    }

    protected void lazyGetNS() {
    }

    protected void addNamespace(String string, String string2) {
        IQName iQName = IQName.get(string2, string);
        if (this.nsCount >= this.namespaces.length) {
            QName[] qNameArray = this.namespaces;
            this.namespaces = new QName[qNameArray.length * 2];
            System.arraycopy(qNameArray, 0, this.namespaces, 0, qNameArray.length);
        }
        this.namespaces[this.nsCount++] = iQName;
    }

    public String getText() {
        if (this.charBuffer == null) {
            return null;
        }
        return new String(this.charBuffer, 0, this.charCount);
    }

    public int getTextLength() {
        return this.charCount;
    }

    protected void clearText() {
        this.charCount = 0;
    }

    protected void storeText(String string) {
        int n = this.charBuffer == null ? 0 : this.charBuffer.length;
        int n2 = string.length() + this.charCount;
        if (n2 > n) {
            char[] cArray = this.charBuffer;
            this.charBuffer = new char[n2 + n2 / 4];
            if (n > 0) {
                System.arraycopy(cArray, 0, this.charBuffer, 0, n);
            }
        }
        string.getChars(0, string.length(), this.charBuffer, this.charCount);
        this.charCount += string.length();
    }

    protected void storeText(char[] cArray, int n) {
        int n2 = n + this.charCount;
        int n3 = this.charBuffer == null ? 0 : this.charBuffer.length;
        if (n2 > n3) {
            char[] cArray2 = this.charBuffer;
            this.charBuffer = new char[n2 + n2 / 4];
            if (n3 > 0) {
                System.arraycopy(cArray2, 0, this.charBuffer, 0, n3);
            }
        }
        System.arraycopy(cArray, 0, this.charBuffer, this.charCount, n);
        this.charCount += n;
    }

    public String getTarget() {
        return this.piTarget;
    }
}

