/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.xquery;

import com.qizx.api.DataModelException;
import com.qizx.api.EvaluationException;
import com.qizx.api.Item;
import com.qizx.api.ItemType;
import com.qizx.api.Node;
import com.qizx.api.QName;
import com.qizx.api.QizxException;
import com.qizx.api.XMLPullStream;
import com.qizx.api.XMLPushStream;
import com.qizx.api.util.time.Date;
import com.qizx.api.util.time.DateTime;
import com.qizx.api.util.time.DateTimeBase;
import com.qizx.api.util.time.DateTimeException;
import com.qizx.api.util.time.Duration;
import com.qizx.xdm.BasicNode;
import com.qizx.xdm.Conversion;
import com.qizx.xdm.NodePullStream;
import com.qizx.xquery.ComparisonContext;
import com.qizx.xquery.EvalContext;
import com.qizx.xquery.XQItem;
import com.qizx.xquery.XQItemType;
import com.qizx.xquery.XQType;
import com.qizx.xquery.XQTypeException;
import com.qizx.xquery.XQValue;
import com.qizx.xquery.dt.ArraySequence;
import com.qizx.xquery.dt.Atomizer;
import com.qizx.xquery.dt.SingleItem;
import com.qizx.xquery.dt.UntypedAtomicType;
import com.qizx.xquery.impl.EmptyException;
import com.qizx.xquery.impl.ErrorValue;
import java.math.BigDecimal;

public abstract class BaseValue
implements XQValue {
    protected XQItemType itemType;

    public boolean nextCollection() throws EvaluationException {
        return this.next();
    }

    public ItemType getType() throws EvaluationException {
        return this.itemType;
    }

    public XQItemType getItemType() throws EvaluationException {
        return this.itemType;
    }

    public XQItem asAtom() throws EvaluationException {
        return this.getItem();
    }

    private EvaluationException notConvertibleTo(String string) throws EvaluationException {
        try {
            ItemType itemType = this.getType();
            return new EvaluationException(Conversion.ERR_CAST, "required type xs:" + string + ", cannot accept actual type " + itemType);
        }
        catch (EvaluationException evaluationException) {
            return evaluationException;
        }
    }

    public boolean getBoolean() throws EvaluationException {
        throw this.notConvertibleTo("boolean");
    }

    public long getInteger() throws EvaluationException {
        throw this.notConvertibleTo("integer");
    }

    public BigDecimal getDecimal() throws EvaluationException {
        throw this.notConvertibleTo("decimal");
    }

    public float getFloat() throws EvaluationException {
        throw this.notConvertibleTo("float");
    }

    public double getDouble() throws EvaluationException {
        throw this.notConvertibleTo("double");
    }

    public String getString() throws EvaluationException {
        throw this.notConvertibleTo("string");
    }

    public QName getQName() throws EvaluationException {
        throw this.notConvertibleTo("QName");
    }

    public Duration getDuration() throws EvaluationException {
        throw this.notConvertibleTo("duration");
    }

    public DateTimeBase getMoment() throws EvaluationException {
        throw this.notConvertibleTo("date or time");
    }

    public Date getDate() throws EvaluationException, DateTimeException {
        return Date.parseDate(this.getString().trim());
    }

    public DateTime getDateTime() throws EvaluationException, DateTimeException {
        return DateTime.parseDateTime(this.getString().trim());
    }

    public Object getObject() throws QizxException {
        return this.getString();
    }

    public Node getNode() throws EvaluationException {
        throw this.notConvertibleTo("node");
    }

    public boolean isNode() {
        return false;
    }

    public BasicNode basicNode() throws EvaluationException {
        throw new XQTypeException("sequence item is not a node");
    }

    public double getFulltextScore(Item item) throws EvaluationException {
        return -1.0;
    }

    public static int compare(long l) {
        return l < 0L ? -1 : (l > 0L ? 1 : 0);
    }

    public static int compare(double d, double d2) {
        if (d != d || d2 != d2) {
            return 3;
        }
        return d < d2 ? -1 : (d > d2 ? 1 : 0);
    }

    public static int compare(double d, double d2, boolean bl) {
        if (d != d) {
            return bl ? 1 : -1;
        }
        if (d2 != d2) {
            return bl ? -1 : 1;
        }
        return d < d2 ? -1 : (d > d2 ? 1 : 0);
    }

    public int compareTo(XQItem xQItem, ComparisonContext comparisonContext, int n) throws EvaluationException {
        return UntypedAtomicType.comparison(this, xQItem, comparisonContext, n);
    }

    public boolean deepEquals(XQItem xQItem, ComparisonContext comparisonContext) {
        try {
            return this.compareTo(xQItem, comparisonContext, 0) == 0;
        }
        catch (EvaluationException evaluationException) {
            return false;
        }
    }

    public XQValue checkTypeExpand(XQType xQType, EvalContext evalContext, boolean bl, boolean bl2) throws EvaluationException {
        XQItem xQItem;
        XQItemType xQItemType;
        XQItemType xQItemType2 = xQItemType = xQType == null ? null : xQType.itemType();
        if (!this.next()) {
            if (xQType == null || xQType.isOptional()) {
                return XQValue.empty;
            }
            return XQValue.TOO_SHORT;
        }
        ArraySequence arraySequence = null;
        XQItem xQItem2 = null;
        int n = 0;
        do {
            xQItem = this.getItem();
            XQItemType xQItemType3 = xQItem.getItemType();
            if (xQItemType != null && !xQItemType.acceptsItem(xQItem)) {
                boolean bl3 = false;
                if (bl && xQItemType.promotable((xQItem = Atomizer.toSingleAtom(xQItem)).getItemType())) {
                    xQItem = xQItemType.cast(xQItem, evalContext);
                    bl3 = true;
                }
                if (!bl3) {
                    return new ErrorValue(xQItemType + " cannot accept item of type " + xQItemType3);
                }
            }
            ++n;
            if (!bl2) continue;
            if (xQItem2 == null) {
                xQItem2 = xQItem;
                continue;
            }
            if (arraySequence == null) {
                arraySequence = new ArraySequence(2, this);
                arraySequence.addItem(xQItem2);
            }
            arraySequence.addItem(xQItem);
        } while (this.next());
        if (arraySequence != null) {
            arraySequence.pack();
        }
        XQItem xQItem3 = bl2 ? (arraySequence != null ? arraySequence : new SingleItem(xQItem2)) : (xQItem = this.bornAgain());
        if (xQType == null) {
            return xQItem;
        }
        switch (xQType.getOccurrence()) {
            case 0: {
                if (n <= 1) {
                    return xQItem;
                }
                return TOO_LONG;
            }
            case 2: {
                return xQItem;
            }
            case 3: {
                if (n >= 1) {
                    return xQItem;
                }
                return TOO_SHORT;
            }
        }
        if (n == 1) {
            return xQItem;
        }
        return n == 0 ? TOO_SHORT : TOO_LONG;
    }

    public boolean worthExpanding() {
        return true;
    }

    public void setLazy(boolean bl) {
    }

    public long quickCount(EvalContext evalContext) throws EvaluationException {
        try {
            this.setLazy(true);
            int n = 0;
            while (this.next()) {
                if (evalContext != null && (n & 0xFF) == 0) {
                    evalContext.at(null);
                }
                ++n;
            }
            long l = n;
            return l;
        }
        catch (EmptyException emptyException) {
            long l = 0L;
            return l;
        }
        catch (RuntimeException runtimeException) {
            runtimeException.printStackTrace();
            throw runtimeException;
        }
        finally {
            this.setLazy(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int doSkip(int n) throws EvaluationException {
        int n2 = 0;
        try {
            this.setLazy(true);
            while (--n >= 0 && this.next()) {
                ++n2;
            }
        }
        catch (EmptyException emptyException) {
        }
        finally {
            this.setLazy(false);
        }
        return n2;
    }

    public boolean hasQuickIndex() {
        return false;
    }

    public XQItem quickIndex(long l) {
        return null;
    }

    public void export(XMLPushStream xMLPushStream) throws DataModelException, EvaluationException {
        if (this.isNode()) {
            xMLPushStream.putNodeCopy(this.getNode(), 0);
        } else {
            xMLPushStream.putText(this.getString());
        }
    }

    public XMLPullStream exportNode() throws EvaluationException {
        if (!this.isNode()) {
            throw new EvaluationException("node item required");
        }
        return new NodePullStream(this.getNode());
    }

    public void close() {
    }
}

