/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.xquery;

import com.qizx.api.CompilationException;
import com.qizx.api.DataModelException;
import com.qizx.api.EvaluationException;
import com.qizx.api.Item;
import com.qizx.api.ItemFactory;
import com.qizx.api.ItemSequence;
import com.qizx.api.ItemType;
import com.qizx.api.Node;
import com.qizx.api.QName;
import com.qizx.api.SequenceType;
import com.qizx.api.TraceObserver;
import com.qizx.api.XMLPullStream;
import com.qizx.api.XQueryContext;
import com.qizx.util.basic.Check;
import com.qizx.xquery.DynamicContext;
import com.qizx.xquery.EvalContext;
import com.qizx.xquery.ExprDisplay;
import com.qizx.xquery.Focus;
import com.qizx.xquery.ItemFactoryImpl;
import com.qizx.xquery.MainQuery;
import com.qizx.xquery.ResultSequence;
import com.qizx.xquery.UpdaterFactory;
import com.qizx.xquery.XQItem;
import com.qizx.xquery.XQValue;
import com.qizx.xquery.dt.JavaMapping;
import com.qizx.xquery.dt.SingleItem;
import com.qizx.xquery.impl.EmptyException;
import com.qizx.xquery.op.Expression;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Timer;
import java.util.TimerTask;
import org.xml.sax.InputSource;

public class ExpressionImpl
implements com.qizx.api.Expression,
Focus {
    private ItemFactory itemMaker;
    private MainQuery query;
    private DynamicContext dynCtx;
    private EvalContext evalContext;
    protected HashMap externGlobals;
    private XQItem currentItem;
    private int timeOut;

    ExpressionImpl(DynamicContext dynamicContext, MainQuery mainQuery) {
        this.query = mainQuery;
        this.itemMaker = new ItemFactoryImpl();
        this.dynCtx = dynamicContext;
        this.externGlobals = new HashMap();
    }

    public XQueryContext getContext() {
        return this.query;
    }

    public SequenceType getStaticType() {
        return this.query.getType();
    }

    public String getSource() {
        return this.query.getSource();
    }

    public void rawBindVariable(QName qName, Item item) throws CompilationException {
        Check.nonNull(qName, "varName");
        if (this.query.getStrictCompliance() && this.query.lookforGlobalVariable(qName) == null) {
            throw new CompilationException("undefined global variable " + qName);
        }
        this.externGlobals.put(qName, item);
    }

    public void bindVariable(QName qName, Item item) throws CompilationException {
        this.rawBindVariable(qName, new SingleItem((XQItem)item));
    }

    public void bindVariable(QName qName, ItemSequence itemSequence) throws CompilationException {
        try {
            Check.implementation(itemSequence, ResultSequence.class, ItemSequence.class);
            ResultSequence resultSequence = (ResultSequence)itemSequence;
            this.rawBindVariable(qName, resultSequence.getValues());
        }
        catch (ClassCastException classCastException) {
            throw new CompilationException("foreign ItemSequence implementation");
        }
    }

    public void bindVariable(QName qName, boolean bl) throws CompilationException {
        this.rawBindVariable(qName, this.createItem(bl));
    }

    public void bindVariable(QName qName, long l, ItemType itemType) throws CompilationException, EvaluationException {
        this.rawBindVariable(qName, this.itemMaker.createItem(l, itemType));
    }

    public void bindVariable(QName qName, double d) throws CompilationException {
        this.rawBindVariable(qName, this.itemMaker.createItem(d));
    }

    public void bindVariable(QName qName, float f) throws CompilationException {
        this.rawBindVariable(qName, this.itemMaker.createItem(f));
    }

    public void bindVariable(QName qName, Object object, ItemType itemType) throws CompilationException, EvaluationException {
        if (itemType == null && JavaMapping.isSequence(object)) {
            this.bindVariable(qName, this.itemMaker.createSequence(object, itemType));
        } else {
            this.bindVariable(qName, this.itemMaker.createItem(object, itemType));
        }
    }

    public void bindImplicitCollection(ItemSequence itemSequence) {
        Check.implementation(itemSequence, ResultSequence.class, ItemSequence.class);
        this.dynCtx.defaultCollection = ((ResultSequence)itemSequence).getValues();
    }

    public Item getCurrentItem() {
        return this.currentItem;
    }

    public void setCurrentItem(Item item) {
        if (item != null) {
            Check.implementation(item, XQItem.class, Item.class);
        }
        this.currentItem = (XQItem)item;
    }

    public ItemSequence evaluate() throws EvaluationException {
        XQValue xQValue = this.rawEval();
        return new ResultSequence(xQValue);
    }

    public XQValue rawEval() throws EvaluationException {
        Object object;
        this.dynCtx.setDate(this.query.getCurrentDate(), this.query.getImplicitTimeZone());
        this.evalContext = new EvalContext(this.dynCtx);
        this.dynCtx.resume(true);
        if (this.timeOut > 0) {
            object = new Timer();
            ((Timer)object).schedule(new TimerTask(){

                public void run() {
                    ExpressionImpl.this.dynCtx.setTimedOut();
                }
            }, this.timeOut);
        }
        this.query.initGlobals(this.evalContext, this.externGlobals);
        object = this.query.eval(this, this.evalContext);
        if (this.query.body.isUpdating()) {
            try {
                object = object.checkTypeExpand(null, this.evalContext, false, true);
            }
            catch (EmptyException emptyException) {
                object = XQValue.empty;
            }
            this.dynCtx.applyUpdates();
        }
        return object;
    }

    public void cancelEvaluation() {
        this.dynCtx.cancel();
    }

    public int getTimeOut() {
        return this.timeOut;
    }

    public void setTimeOut(int n) {
        this.timeOut = n;
    }

    public TraceObserver getTraceObserver() {
        return this.dynCtx.traceListener;
    }

    public void setTraceObserver(TraceObserver traceObserver) {
        this.dynCtx.traceListener = traceObserver;
    }

    public void setCompilationTrace(PrintWriter printWriter) {
        this.dynCtx.compilationTrace = printWriter;
    }

    public ItemSequence copySequence(ItemSequence itemSequence) throws EvaluationException {
        Check.nonNull(itemSequence, "sequence");
        return this.itemMaker.copySequence(itemSequence);
    }

    public Item createItem(boolean bl) {
        return this.itemMaker.createItem(bl);
    }

    public Item createItem(double d) {
        return this.itemMaker.createItem(d);
    }

    public Item createItem(float f) {
        return this.itemMaker.createItem(f);
    }

    public Item createItem(InputSource inputSource) throws EvaluationException, IOException {
        return this.itemMaker.createItem(inputSource);
    }

    public Item createItem(long l, ItemType itemType) throws EvaluationException {
        return this.itemMaker.createItem(l, itemType);
    }

    public Item createItem(Object object, ItemType itemType) throws EvaluationException {
        return this.itemMaker.createItem(object, itemType);
    }

    public Item createItem(XMLPullStream xMLPullStream) throws EvaluationException {
        return this.itemMaker.createItem(xMLPullStream);
    }

    public ItemSequence createSequence(Object object, SequenceType sequenceType) throws EvaluationException {
        return this.itemMaker.createSequence(object, sequenceType);
    }

    public QName getQName(String string, String string2, String string3) {
        return this.itemMaker.getQName(string, string2, string3);
    }

    public QName getQName(String string, String string2) {
        return this.itemMaker.getQName(string, string2);
    }

    public QName getQName(String string) {
        return this.itemMaker.getQName(string);
    }

    public ItemType getType(String string) {
        return this.itemMaker.getType(string);
    }

    public ItemType getNodeType(int n, QName qName) {
        return this.itemMaker.getNodeType(n, qName);
    }

    public DynamicContext getDynCtx() {
        return this.dynCtx;
    }

    public XQItem currentItem() throws EvaluationException {
        return this.currentItem;
    }

    public Node currentItemAsNode() throws EvaluationException {
        return this.currentItem == null ? null : this.currentItem.getNode();
    }

    public double currentItemAsDouble() throws EvaluationException {
        return this.currentItem == null ? 0.0 : this.currentItem.getDouble();
    }

    public long currentItemAsInteger() throws EvaluationException {
        return this.currentItem == null ? 0L : this.currentItem.getInteger();
    }

    public String currentItemAsString() throws EvaluationException {
        return this.currentItem == null ? null : this.currentItem.getString();
    }

    public long getLast() throws EvaluationException {
        return 1L;
    }

    public long getPosition() {
        return 1L;
    }

    public Expression getExpr() {
        return this.query.body;
    }

    public void dump(ExprDisplay exprDisplay) {
        this.query.dump(exprDisplay);
        try {
            exprDisplay.flush();
        }
        catch (DataModelException dataModelException) {
            dataModelException.printStackTrace();
        }
    }

    public void setUpdaterFactory(UpdaterFactory updaterFactory) {
        this.dynCtx.setUpdaterFactory(updaterFactory);
    }

    public Object getProperty(String string) {
        return this.dynCtx.getProperty(string);
    }

    public void setProperty(String string, Object object) {
        this.dynCtx.setProperty(string, object);
    }
}

