/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.xquery.dt;

import com.qizx.util.basic.Util;
import com.qizx.xquery.EvalContext;
import com.qizx.xquery.XQItem;
import com.qizx.xquery.XQItemType;
import com.qizx.xquery.XQType;
import com.qizx.xquery.XQTypeException;
import com.qizx.xquery.XQValue;
import com.qizx.xquery.dt.AtomicType;
import com.qizx.xquery.dt.SingleString;
import java.net.URI;
import java.net.URISyntaxException;

public class AnyURIType
extends AtomicType {
    public String getShortName() {
        return "anyURI";
    }

    public int quickCode() {
        return 14;
    }

    public XQValue cast(XQItem xQItem, EvalContext evalContext) throws XQTypeException {
        String string = null;
        try {
            XQItemType xQItemType = xQItem.getItemType();
            int n = xQItemType.quickCode();
            if (xQItemType != XQType.ANYURI && n != 5 && n != 6) {
                throw new Exception("improper type " + xQItemType);
            }
            string = AnyURIType.convertToURI(xQItem.getString().trim());
        }
        catch (Exception exception) {
            throw new XQTypeException("cannot cast to xs:anyURI: " + exception.getMessage());
        }
        return new SingleString(string, XQType.ANYURI);
    }

    public static String convertToURI(String string) throws URISyntaxException {
        if (AnyURIType.validURI(string)) {
            return string;
        }
        String string2 = Util.encodeForURI(string);
        if (AnyURIType.validURI(string2)) {
            return string;
        }
        throw new URISyntaxException(string, "invalid URI");
    }

    public static boolean validURI(String string) {
        try {
            new URI(string);
            return true;
        }
        catch (URISyntaxException uRISyntaxException) {
            return false;
        }
    }
}

