/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.xquery.dt;

import com.qizx.api.DataModelException;
import com.qizx.api.EvaluationException;
import com.qizx.api.Node;
import com.qizx.xdm.BasicNode;
import com.qizx.xquery.XQItem;
import com.qizx.xquery.XQType;
import com.qizx.xquery.XQValue;
import com.qizx.xquery.dt.AtomicType;
import com.qizx.xquery.dt.GenericValue;
import com.qizx.xquery.dt.SingleString;

public class Atomizer
extends GenericValue {
    XQValue input;

    public Atomizer(XQValue xQValue) {
        this.input = xQValue;
    }

    public boolean next() throws EvaluationException {
        if (!this.input.next()) {
            return false;
        }
        this.item = Atomizer.toSingleAtom(this.input.getItem());
        return true;
    }

    public static XQItem toSingleAtom(XQItem xQItem) throws EvaluationException {
        if (!xQItem.isNode()) {
            return xQItem;
        }
        Node node = xQItem.getNode();
        try {
            int n = node.getNodeNature();
            AtomicType atomicType = XQType.UNTYPED_ATOMIC;
            if (n == 6 || n == 5) {
                atomicType = XQType.STRING;
            }
            return new SingleString(node.getStringValue(), atomicType);
        }
        catch (DataModelException dataModelException) {
            throw BasicNode.wrapDMException(dataModelException);
        }
    }

    public XQValue bornAgain() {
        return new Atomizer(this.input.bornAgain());
    }
}

