/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.xquery.dt;

import com.qizx.api.EvaluationException;
import com.qizx.xdm.Conversion;
import com.qizx.xquery.EvalContext;
import com.qizx.xquery.Focus;
import com.qizx.xquery.XQItem;
import com.qizx.xquery.XQItemType;
import com.qizx.xquery.XQTypeException;
import com.qizx.xquery.XQValue;
import com.qizx.xquery.dt.ArraySequence;
import com.qizx.xquery.dt.AtomicType;
import com.qizx.xquery.dt.SingleBoolean;
import com.qizx.xquery.op.Expression;

public class BooleanType
extends AtomicType {
    public String getShortName() {
        return "boolean";
    }

    public int quickCode() {
        return 13;
    }

    public XQValue cast(XQItem xQItem, EvalContext evalContext) throws EvaluationException {
        XQItemType xQItemType = xQItem.getItemType();
        switch (xQItemType.quickCode()) {
            case 5: 
            case 6: {
                return new SingleBoolean(Conversion.toBoolean(xQItem.getString().trim()));
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 13: {
                return new SingleBoolean(xQItem.getBoolean());
            }
        }
        this.invalidCast(xQItemType);
        return null;
    }

    public XQValue convertFromObject(Object object) throws XQTypeException {
        boolean bl = false;
        if (object instanceof String) {
            bl = Conversion.toBoolean((String)object);
        } else if (object instanceof Boolean) {
            bl = (Boolean)object;
        } else {
            this.invalidCast(object);
        }
        return new SingleBoolean(bl);
    }

    public XQValue convertFromArray(Object object) {
        boolean[] blArray = (boolean[])object;
        ArraySequence arraySequence = new ArraySequence(blArray.length, null);
        int n = blArray.length;
        for (int i = 0; i < n; ++i) {
            arraySequence.addItem(new SingleBoolean(blArray[i]));
        }
        return arraySequence;
    }

    public Object convertToObject(Expression expression, Focus focus, EvalContext evalContext) throws EvaluationException {
        return expression.evalAsBoolean(focus, evalContext);
    }
}

