/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.xquery.dt;

import com.qizx.api.EvaluationException;
import com.qizx.api.util.time.DateTime;
import com.qizx.api.util.time.DateTimeBase;
import com.qizx.api.util.time.DateTimeException;
import com.qizx.xquery.EvalContext;
import com.qizx.xquery.XQItem;
import com.qizx.xquery.XQItemType;
import com.qizx.xquery.XQType;
import com.qizx.xquery.XQValue;
import com.qizx.xquery.dt.MomentType;
import com.qizx.xquery.dt.SingleMoment;

public class DateTimeType
extends MomentType {
    public String getShortName() {
        return "dateTime";
    }

    public int quickCode() {
        return 8;
    }

    public XQValue cast(XQItem xQItem, EvalContext evalContext) throws EvaluationException {
        XQItemType xQItemType = xQItem.getItemType();
        DateTimeBase dateTimeBase = null;
        try {
            switch (xQItemType.quickCode()) {
                case 5: 
                case 6: {
                    return SingleMoment.dateTime(xQItem.getDateTime());
                }
                case 8: 
                case 9: {
                    return SingleMoment.dateTime(new DateTime(xQItem.getMoment()));
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    if (evalContext.sObs()) break;
                    double d = xQItem.getDouble();
                    return SingleMoment.dateTime(new DateTime((long)(d * 1000.0)));
                }
            }
            this.invalidCast(xQItemType);
        }
        catch (DateTimeException dateTimeException) {
            this.castException(dateTimeException);
        }
        return new SingleMoment(dateTimeBase, XQType.DATE_TIME);
    }
}

