/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.xquery.dt;

import com.qizx.api.EvaluationException;
import com.qizx.xquery.XQItem;
import com.qizx.xquery.XQValue;
import com.qizx.xquery.dt.GenericValue;
import com.qizx.xquery.dt.SingleDouble;

public class DoubleArraySequence
extends GenericValue {
    protected double[] items;
    protected int size;
    protected int index = -1;

    public DoubleArraySequence(double[] dArray, int n) {
        this.items = dArray;
        this.size = n;
    }

    public boolean next() throws EvaluationException {
        if (++this.index >= this.size) {
            return false;
        }
        this.item = new SingleDouble(this.items[this.index]);
        return true;
    }

    public XQItem quickIndex(long l) {
        return l <= 0L || l > (long)this.size ? null : new SingleDouble(this.items[(int)l - 1]);
    }

    public XQValue bornAgain() {
        return new DoubleArraySequence(this.items, this.size);
    }

    static double[] unroll(XQValue xQValue) throws EvaluationException {
        double[] dArray = new double[8];
        int n = 1;
        while (xQValue.next()) {
            if (n >= dArray.length) {
                double[] dArray2 = dArray;
                dArray = new double[dArray2.length * 2];
                System.arraycopy(dArray2, 0, dArray, 0, dArray2.length);
            }
            dArray[n++] = xQValue.getDouble();
        }
        dArray[0] = n - 1;
        return dArray;
    }

    public static double[] expandDoubles(XQValue xQValue) throws EvaluationException {
        double[] dArray = DoubleArraySequence.unroll(xQValue);
        int n = (int)dArray[0];
        double[] dArray2 = new double[n];
        System.arraycopy(dArray, 1, dArray2, 0, n);
        return dArray2;
    }
}

