/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.xquery.dt;

import com.qizx.api.EvaluationException;
import com.qizx.xdm.Conversion;
import com.qizx.xquery.EvalContext;
import com.qizx.xquery.Focus;
import com.qizx.xquery.XQItem;
import com.qizx.xquery.XQItemType;
import com.qizx.xquery.XQType;
import com.qizx.xquery.XQTypeException;
import com.qizx.xquery.XQValue;
import com.qizx.xquery.dt.FloatArraySequence;
import com.qizx.xquery.dt.NumericType;
import com.qizx.xquery.dt.SingleFloat;
import com.qizx.xquery.op.Expression;

public class FloatType
extends NumericType {
    public String getShortName() {
        return "float";
    }

    public int quickCode() {
        return 3;
    }

    public boolean encompasses(XQItemType xQItemType) {
        return xQItemType != XQType.DOUBLE && XQType.NUMERIC.encompasses(xQItemType);
    }

    public boolean promotable(XQItemType xQItemType) {
        return xQItemType == UNTYPED_ATOMIC || xQItemType.isSubTypeOf(DECIMAL);
    }

    public XQValue cast(XQItem xQItem, EvalContext evalContext) throws EvaluationException {
        XQItemType xQItemType = xQItem.getItemType();
        switch (xQItemType.quickCode()) {
            case 10: 
            case 11: {
                if (evalContext.sObs()) {
                    this.invalidCast(xQItemType);
                }
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 13: {
                return new SingleFloat(xQItem.getFloat());
            }
        }
        return this.invalidCast(xQItemType);
    }

    public XQValue convertFromObject(Object object) throws XQTypeException {
        float f = 0.0f;
        if (object instanceof Float) {
            f = ((Float)object).floatValue();
        } else if (object instanceof Long) {
            f = ((Long)object).floatValue();
        } else if (object instanceof Integer) {
            f = ((Integer)object).floatValue();
        } else if (object instanceof Short) {
            f = ((Short)object).floatValue();
        } else if (object instanceof Byte) {
            f = ((Byte)object).floatValue();
        } else if (object instanceof String) {
            f = Conversion.toFloat((String)object);
        } else {
            this.invalidCast(this);
        }
        return new SingleFloat(f);
    }

    public Object convertToObject(Expression expression, Focus focus, EvalContext evalContext) throws EvaluationException {
        return new Float(expression.evalAsFloat(focus, evalContext));
    }

    public XQValue convertFromArray(Object object) {
        float[] fArray = (float[])object;
        return new FloatArraySequence(fArray, fArray.length);
    }

    public Object convertToArray(XQValue xQValue) throws EvaluationException {
        return FloatArraySequence.expandFloats(xQValue);
    }
}

