/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.xquery.dt;

import com.qizx.api.EvaluationException;
import com.qizx.xdm.Conversion;
import com.qizx.xquery.EvalContext;
import com.qizx.xquery.Focus;
import com.qizx.xquery.XQItem;
import com.qizx.xquery.XQItemType;
import com.qizx.xquery.XQTypeException;
import com.qizx.xquery.XQValue;
import com.qizx.xquery.dt.DecimalType;
import com.qizx.xquery.dt.IntegerArraySequence;
import com.qizx.xquery.dt.SingleInteger;
import com.qizx.xquery.op.Expression;

public class IntegerType
extends DecimalType {
    public String getShortName() {
        return "integer";
    }

    public int quickCode() {
        return 1;
    }

    public long upperBound() {
        return Long.MAX_VALUE;
    }

    public long lowerBound() {
        return Long.MIN_VALUE;
    }

    public XQValue cast(XQItem xQItem, EvalContext evalContext) throws XQTypeException {
        long l = 0L;
        try {
            XQItemType xQItemType = xQItem.getItemType();
            switch (xQItemType.quickCode()) {
                case 5: 
                case 6: {
                    l = Conversion.toInteger(xQItem.getString());
                    break;
                }
                case 1: {
                    l = xQItem.getInteger();
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    double d = xQItem.getDouble();
                    if (d != d) {
                        throw new XQTypeException(Conversion.ERR_CAST, "invalid value " + d);
                    }
                    if (Double.isInfinite(d) || d < -9.223372036854776E18 || d > 9.223372036854776E18) {
                        throw new XQTypeException("FOCA0002", "invalid value " + d);
                    }
                    l = (long)d;
                    break;
                }
                case 13: {
                    l = xQItem.getBoolean() ? 1L : 0L;
                    break;
                }
                case 10: 
                case 11: {
                    if (!evalContext.sObs()) {
                        l = xQItem.getInteger();
                        break;
                    }
                }
                default: {
                    throw new XQTypeException("invalid type " + xQItemType);
                }
            }
        }
        catch (EvaluationException evaluationException) {
            throw new XQTypeException(evaluationException.getErrorCode(), "cannot cast to xs:" + this.getShortName() + " : " + evaluationException.getMessage());
        }
        if (l < this.lowerBound() || l > this.upperBound()) {
            throw new XQTypeException(Conversion.ERR_CAST, "invalid value " + l);
        }
        return new SingleInteger(l, this);
    }

    public XQValue convertFromObject(Object object) throws XQTypeException {
        long l = 0L;
        if (object instanceof String) {
            l = Conversion.toInteger((String)object);
        } else if (object instanceof Long) {
            l = (Long)object;
        } else if (object instanceof Integer) {
            l = ((Integer)object).longValue();
        } else if (object instanceof Short) {
            l = ((Short)object).longValue();
        } else if (object instanceof Byte) {
            l = ((Byte)object).longValue();
        } else {
            this.invalidCast(this);
        }
        if (l < this.lowerBound() || l > this.upperBound()) {
            this.invalidObject(object);
        }
        return new SingleInteger(l, this);
    }

    protected Object convertToObject(long l) {
        return new Long(l);
    }

    public Object convertToObject(Expression expression, Focus focus, EvalContext evalContext) throws EvaluationException {
        return this.convertToObject(expression.evalAsInteger(focus, evalContext));
    }

    public XQValue convertFromArray(Object object) {
        long[] lArray = (long[])object;
        return new IntegerArraySequence(lArray, lArray.length);
    }

    public Object convertToArray(XQValue xQValue) throws EvaluationException {
        return IntegerArraySequence.expandIntegers(xQValue);
    }
}

