/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.xquery.dt;

import com.qizx.api.EvaluationException;
import com.qizx.xquery.EvalContext;
import com.qizx.xquery.Focus;
import com.qizx.xquery.XQItem;
import com.qizx.xquery.XQItemType;
import com.qizx.xquery.XQType;
import com.qizx.xquery.XQTypeException;
import com.qizx.xquery.XQValue;
import com.qizx.xquery.dt.AtomicType;
import com.qizx.xquery.dt.SingleString;
import com.qizx.xquery.dt.StringArraySequence;
import com.qizx.xquery.dt.WrappedObjectType;
import com.qizx.xquery.op.Expression;

public class StringType
extends AtomicType {
    public String getShortName() {
        return "string";
    }

    public int quickCode() {
        return 6;
    }

    protected boolean checkValue(String string) {
        return true;
    }

    public boolean accepts(XQType xQType) {
        XQItemType xQItemType = xQType.itemType();
        if (super.accepts(xQItemType)) {
            return true;
        }
        return xQItemType instanceof WrappedObjectType;
    }

    public boolean promotable(XQItemType xQItemType) {
        return xQItemType == UNTYPED_ATOMIC || xQItemType == ANYURI;
    }

    public XQValue cast(XQItem xQItem, EvalContext evalContext) throws XQTypeException {
        String string = null;
        try {
            string = xQItem.getString();
        }
        catch (EvaluationException evaluationException) {
            throw new XQTypeException("cannot cast to xs:string: " + evaluationException.getMessage());
        }
        if (!this.checkValue(string)) {
            throw new XQTypeException("cannot cast to xs:" + this.getShortName() + ": value does not conform to facets");
        }
        return new SingleString(string, this);
    }

    public XQValue convertFromObject(Object object) throws XQTypeException {
        return object == null ? XQValue.empty : new SingleString(object.toString(), this);
    }

    public Object convertToObject(Expression expression, Focus focus, EvalContext evalContext) throws EvaluationException {
        return expression.evalAsString(focus, evalContext);
    }

    public XQValue convertFromArray(Object object) {
        String[] stringArray = (String[])object;
        return new StringArraySequence(stringArray, stringArray.length);
    }

    public Object convertToArray(XQValue xQValue) throws EvaluationException {
        return StringArraySequence.expand(xQValue, false);
    }
}

