/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.xquery.dt;

import com.qizx.api.EvaluationException;
import com.qizx.util.Collations;
import com.qizx.xdm.Conversion;
import com.qizx.xquery.BaseValue;
import com.qizx.xquery.ComparisonContext;
import com.qizx.xquery.XQItem;
import com.qizx.xquery.XQItemType;
import com.qizx.xquery.XQType;
import com.qizx.xquery.dt.SingleString;
import java.text.Collator;

public abstract class StringValue
extends BaseValue {
    public StringValue() {
        this.itemType = XQType.STRING;
    }

    public XQItem getItem() {
        return new SingleString(this.getValue(), this.itemType);
    }

    protected abstract String getValue();

    public boolean getBoolean() throws EvaluationException {
        return Conversion.toBoolean(this.getString());
    }

    public long getInteger() throws EvaluationException {
        return Conversion.toInteger(this.getString());
    }

    public double getDouble() throws EvaluationException {
        return Conversion.toDouble(this.getString());
    }

    public float getFloat() throws EvaluationException {
        return Conversion.toFloat(this.getString());
    }

    public boolean equals(Object object) {
        if (!(object instanceof XQItem)) {
            return false;
        }
        try {
            return this.getString().equals(((XQItem)object).getString());
        }
        catch (EvaluationException evaluationException) {
            return false;
        }
    }

    public int hashCode() {
        try {
            return this.getString().hashCode();
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public static int compare(String string, String string2, Collator collator) {
        int n;
        int n2 = n = collator == null || collator == Collations.CODEPOINT_COLLATOR ? string.compareTo(string2) : collator.compare(string, string2);
        return n < 0 ? -1 : (n > 0 ? 1 : 0);
    }

    public int compareTo(XQItem xQItem, ComparisonContext comparisonContext, int n) throws EvaluationException {
        XQItemType xQItemType = (XQItemType)xQItem.getType();
        switch (xQItemType.quickCode()) {
            case 5: 
            case 6: 
            case 14: {
                return StringValue.compare(this.getString(), xQItem.getString(), comparisonContext != null ? comparisonContext.getCollator() : null);
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 13: {
                if ((n & 2) != 0) {
                    return 2;
                }
                return -xQItem.compareTo(this, comparisonContext, n);
            }
        }
        return 2;
    }
}

