/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.xquery.ext;

import com.qizx.api.DataModelException;
import com.qizx.api.EvaluationException;
import com.qizx.api.Node;
import com.qizx.api.QName;
import com.qizx.api.util.XMLSerializer;
import com.qizx.xdm.BasicNode;
import com.qizx.xdm.IQName;
import com.qizx.xquery.EvalContext;
import com.qizx.xquery.Focus;
import com.qizx.xquery.XQType;
import com.qizx.xquery.ext.ExtensionFunction;
import com.qizx.xquery.fn.Function;
import com.qizx.xquery.fn.Prototype;
import com.qizx.xquery.op.Expression;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.StringWriter;

public class XfnSerialize
extends ExtensionFunction {
    static QName qfname = IQName.get(EXTENSION_NS, "serialize");
    static Prototype[] protos = new Prototype[]{new Prototype(qfname, XQType.STRING.opt, Exec.class).arg("node", (XQType)XQType.NODE), new Prototype(qfname, XQType.STRING.opt, Exec.class).arg("node", (XQType)XQType.NODE).arg("options", (XQType)XQType.ELEMENT)};

    public Prototype[] getProtos() {
        return protos;
    }

    private static String getOption(Node node, String string) throws DataModelException {
        if (node == null) {
            return null;
        }
        Node node2 = node.getAttribute(IQName.get(string));
        return node2 == null ? null : node2.getStringValue();
    }

    public static class Exec
    extends Function.OptStringCall {
        private static final String OPTION_FILE = "file";
        private static final String OPTION_OUTPUT = "output";

        public String evalAsOptString(Focus focus, EvalContext evalContext) throws EvaluationException {
            BasicNode basicNode = this.args.length < 2 ? null : this.args[1].evalAsNode(focus, evalContext);
            evalContext.at(this);
            String string = null;
            try {
                string = XfnSerialize.getOption(basicNode, OPTION_FILE);
                if (string == null) {
                    string = XfnSerialize.getOption(basicNode, OPTION_OUTPUT);
                }
            }
            catch (DataModelException dataModelException) {
                this.dmError(evalContext, dataModelException);
            }
            XMLSerializer xMLSerializer = new XMLSerializer();
            try {
                Object object;
                if (basicNode != null && (object = basicNode.getAttributes()) != null) {
                    for (int i = 0; i < ((Node[])object).length; ++i) {
                        Node node = object[i];
                        String string2 = node.getNodeName().getLocalPart();
                        if (string2.equals(OPTION_OUTPUT) || string2.equals(OPTION_FILE)) continue;
                        xMLSerializer.setOption(string2, node.getStringValue());
                    }
                }
                xMLSerializer.reset();
                object = null;
                StringWriter stringWriter = null;
                if (string != null) {
                    object = new FileOutputStream(string);
                    xMLSerializer.setOutput((OutputStream)object, xMLSerializer.getEncoding());
                } else {
                    stringWriter = new StringWriter();
                    xMLSerializer.setOutput(stringWriter);
                }
                this.args[0].evalAsEvents(xMLSerializer, focus, evalContext);
                xMLSerializer.flush();
                if (object != null) {
                    ((FileOutputStream)object).close();
                }
                if (stringWriter != null) {
                    return stringWriter.toString();
                }
            }
            catch (EvaluationException evaluationException) {
                throw evaluationException;
            }
            catch (Exception exception) {
                evalContext.error("XQSE0001", (Expression)this, new EvaluationException("serialization error: " + exception.toString(), exception));
                return null;
            }
            return string;
        }
    }
}

