/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.xquery.fn;

import com.qizx.api.EvaluationException;
import com.qizx.util.basic.FileUtil;
import com.qizx.xquery.EvalContext;
import com.qizx.xquery.Focus;
import com.qizx.xquery.XQType;
import com.qizx.xquery.XQValue;
import com.qizx.xquery.dt.SingleString;
import com.qizx.xquery.dt.StringValue;
import com.qizx.xquery.fn.Function;
import com.qizx.xquery.fn.Prototype;
import com.qizx.xquery.op.Expression;
import java.net.URI;
import java.net.URISyntaxException;

public class ResolveUri
extends Function {
    static Prototype[] protos = new Prototype[]{Prototype.fn("resolve-uri", XQType.ANYURI.opt, Exec.class).arg("relative", (XQType)XQType.STRING), Prototype.fn("resolve-uri", XQType.ANYURI.opt, Exec.class).arg("relative", (XQType)XQType.STRING).arg("base", (XQType)XQType.ANYURI)};

    public Prototype[] getProtos() {
        return protos;
    }

    public static class Exec
    extends Function.Call {
        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public XQValue eval(Focus focus, EvalContext evalContext) throws EvaluationException {
            Object object;
            evalContext.at(this);
            String string = this.args[0].evalAsOptString(focus, evalContext);
            if (string == null) {
                return XQValue.empty;
            }
            URI uRI = FileUtil.uriConvert(string);
            if (uRI == null) {
                evalContext.error("FORG0002", (Expression)this, "invalid URI: " + string);
            }
            String string2 = null;
            if (this.args.length > 1) {
                object = this.args[1].evalAsOptItem(focus, evalContext);
                if (object != null) {
                    if (!(object instanceof StringValue)) {
                        evalContext.invalidArgType(this.args[1], 1, object.getType(), "anyURI");
                    } else {
                        string2 = object.getString();
                    }
                }
                if (string2 != null && string2.length() == 0) {
                    string2 = evalContext.getStaticContext().getBaseURI();
                }
            } else {
                string2 = evalContext.getStaticContext().getBaseURI();
            }
            if (string2 == null) {
                if (uRI.isAbsolute()) return new SingleString(string, XQType.ANYURI);
                evalContext.error("FONS0005", (Expression)this, "undefined base URI");
            } else if (FileUtil.uriConvert(string2) == null) {
                evalContext.error("FORG0002", (Expression)this, "invalid base URI: " + string2);
            }
            try {
                object = new URI(string2).resolve(string);
                return new SingleString(((URI)object).toString(), XQType.ANYURI);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                evalContext.error("FORG0002", (Expression)this, illegalArgumentException.getMessage());
                return null;
            }
            catch (URISyntaxException uRISyntaxException) {
                evalContext.error("FORG0002", (Expression)this, uRISyntaxException.getMessage());
            }
            return null;
        }
    }
}

