/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.xquery.fn;

import com.qizx.api.EvaluationException;
import com.qizx.util.basic.XMLUtil;
import com.qizx.xquery.EvalContext;
import com.qizx.xquery.Focus;
import com.qizx.xquery.XQType;
import com.qizx.xquery.XQValue;
import com.qizx.xquery.dt.IntegerValue;
import com.qizx.xquery.fn.Function;
import com.qizx.xquery.fn.Prototype;

public class StringToCodepoints
extends Function {
    static Prototype[] protos = new Prototype[]{Prototype.fn("string-to-codepoints", XQType.INTEGER.star, Exec.class).arg("srcval", (XQType)XQType.STRING)};

    public Prototype[] getProtos() {
        return protos;
    }

    static class Sequence
    extends IntegerValue {
        String source;
        int position = 0;
        int currentCode;

        Sequence(String string) {
            this.source = string;
        }

        public boolean next() throws EvaluationException {
            ++this.position;
            if (this.position - 1 >= this.source.length()) {
                return false;
            }
            char c = this.source.charAt(this.position - 1);
            if (!XMLUtil.isSurrogateChar(c)) {
                this.currentCode = c;
            } else {
                if (this.position - 1 >= this.source.length()) {
                    return false;
                }
                char c2 = this.source.charAt(this.position - 1);
                ++this.position;
                this.currentCode = XMLUtil.supplementalChar(c, c2);
            }
            return true;
        }

        public long getInteger() {
            return this.currentCode;
        }

        public long getValue() {
            return this.currentCode;
        }

        public XQValue bornAgain() {
            return new Sequence(this.source);
        }
    }

    public static class Exec
    extends Function.Call {
        public XQValue eval(Focus focus, EvalContext evalContext) throws EvaluationException {
            evalContext.at(this);
            String string = this.args[0].evalAsOptString(focus, evalContext);
            if (string == null) {
                return XQValue.empty;
            }
            return new Sequence(string);
        }
    }
}

