/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.xquery.fn;

import com.qizx.api.EvaluationException;
import com.qizx.api.util.time.DateTime;
import com.qizx.api.util.time.DateTimeBase;
import com.qizx.api.util.time.DateTimeException;
import com.qizx.api.util.time.Duration;
import com.qizx.xdm.Conversion;
import com.qizx.xquery.EvalContext;
import com.qizx.xquery.Focus;
import com.qizx.xquery.XQItem;
import com.qizx.xquery.XQType;
import com.qizx.xquery.XQValue;
import com.qizx.xquery.dt.MomentValue;
import com.qizx.xquery.dt.SingleDuration;
import com.qizx.xquery.fn.Function;
import com.qizx.xquery.fn.Prototype;
import com.qizx.xquery.impl.EmptyException;
import com.qizx.xquery.op.Expression;

public class TimezoneFromDateTime
extends Function {
    static Prototype[] protos = new Prototype[]{Prototype.fn("timezone-from-dateTime", XQType.DURATION.opt, Exec.class).arg("op", (XQType)XQType.DATE_TIME.opt)};

    public Prototype[] getProtos() {
        return protos;
    }

    public static class Exec
    extends Function.Call {
        public XQValue eval(Focus focus, EvalContext evalContext) throws EvaluationException {
            evalContext.at(this);
            XQItem xQItem = this.args[0].evalAsOptItem(focus, evalContext);
            if (xQItem == null) {
                throw EmptyException.instance();
            }
            DateTimeBase dateTimeBase = null;
            if (xQItem instanceof MomentValue) {
                dateTimeBase = xQItem.getMoment();
            } else {
                try {
                    dateTimeBase = DateTime.parseDateTime(xQItem.getString());
                }
                catch (DateTimeException dateTimeException) {
                    return evalContext.error(Conversion.ERR_CAST, (Expression)this, "cannot cast to xs:dateTime : " + dateTimeException.getMessage());
                }
            }
            try {
                if (!dateTimeBase.hasTimeZone()) {
                    return XQValue.empty;
                }
                int n = dateTimeBase.getTimeZone();
                return SingleDuration.newDT(Duration.newDayTime(n * 60));
            }
            catch (DateTimeException dateTimeException) {
                return evalContext.error(Conversion.ERR_CAST, (Expression)this, "invalid timezone: " + dateTimeException.getMessage());
            }
        }
    }
}

