/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.xquery.impl;

import com.qizx.api.CompilationException;
import com.qizx.util.CharTable;
import com.qizx.util.basic.XMLUtil;
import com.qizx.xquery.ModuleContext;
import java.util.ArrayList;

public class Lexer {
    public static final String ERR_SYNTAX = "XPST0003";
    private static final char REQ_SKIP = '\u00a0';
    private static final char METACHAR = '\u00ac';
    private static final char META = '\u0080';
    static final int NUMBER = -2;
    static final int SKIP = -1;
    public static final int T_END = 0;
    static final int T_And = 1;
    static final int T_As = 2;
    static final int T_Ascending = 3;
    static final int T_AssignEquals = 4;
    static final int T_At = 5;
    static final int T_AtStringLiteral = 6;
    static final int T_AttributeQNameLbrace = 7;
    static final int T_AttributeLbrace = 8;
    static final int T_AxisAncestor = 9;
    static final int T_AxisAncestorOrSelf = 10;
    static final int T_AxisAttribute = 11;
    static final int T_AxisChild = 12;
    static final int T_AxisDescendant = 13;
    static final int T_AxisDescendantOrSelf = 14;
    static final int T_AxisFollowing = 15;
    static final int T_AxisFollowingSibling = 16;
    static final int T_AxisNamespace = 17;
    static final int T_AxisParent = 18;
    static final int T_AxisPreceding = 19;
    static final int T_AxisPrecedingSibling = 20;
    static final int T_AxisSelf = 21;
    static final int T_Case = 22;
    static final int T_CastAs = 23;
    static final int T_CastableAs = 24;
    static final int T_Char = 25;
    static final int T_CharRef = 26;
    static final int T_CloseApos = 27;
    static final int T_CloseQuot = 28;
    static final int T_Collation = 29;
    static final int T_ColonEquals = 30;
    static final int T_Comma = 31;
    static final int T_Comment = 32;
    static final int T_CommentLpar = 33;
    static final int T_DecimalLiteral = 34;
    static final int T_DeclareNamespace = 35;
    static final int T_Default = 36;
    static final int T_DefaultCollation = 37;
    static final int T_DefaultElement = 38;
    static final int T_DefaultFunction = 39;
    static final int T_DeclareFunction = 40;
    static final int T_Descending = 41;
    static final int T_Div = 42;
    static final int T_DocumentLbrace = 43;
    static final int T_Dot = 44;
    static final int T_DotDot = 45;
    static final int T_DoubleLiteral = 46;
    static final int T_ElementLbrace = 47;
    static final int T_ElementQNameLbrace = 48;
    static final int T_ElementType = 49;
    static final int T_Else = 50;
    static final int T_Empty = 51;
    static final int T_EmptyGreatest = 52;
    static final int T_EmptyLeast = 53;
    static final int T_EmptyTagClose = 54;
    static final int T_EndTag = 55;
    static final int T_Equals = 56;
    static final int T_Every = 57;
    static final int T_Except = 58;
    static final int T_ForVariable = 59;
    static final int T_FortranEq = 60;
    static final int T_FortranGe = 61;
    static final int T_FortranGt = 62;
    static final int T_FortranLe = 63;
    static final int T_FortranLt = 64;
    static final int T_FortranNe = 65;
    static final int T_Gt = 66;
    static final int T_GtEquals = 67;
    static final int T_GtGt = 68;
    static final int T_Global = 69;
    static final int T_Idiv = 70;
    static final int T_IfLpar = 71;
    static final int T_ImportSchema = 72;
    static final int T_In = 73;
    static final int T_InContext = 74;
    static final int T_Instanceof = 75;
    static final int T_IntegerLiteral = 76;
    static final int T_Intersect = 77;
    static final int T_Is = 78;
    static final int T_IsNot = 79;
    static final int T_Item = 80;
    static final int T_Lbrace = 81;
    static final int T_LbraceExprEnclosure = 82;
    static final int T_Lbrack = 83;
    static final int T_LetVariable = 84;
    static final int T_Lpar = 85;
    static final int T_Lt = 86;
    static final int T_LtEquals = 87;
    static final int T_LtLt = 88;
    static final int T_Minus = 89;
    static final int T_Mod = 90;
    static final int T_Multiply = 91;
    static final int T_NCName = 92;
    static final int T_NCNameColonStar = 93;
    static final int T_Namespace = 94;
    static final int T_Node = 95;
    static final int T_NodeLpar = 96;
    static final int T_NotEquals = 97;
    static final int T_OfType = 98;
    static final int T_OpenApos = 99;
    static final int T_OpenQuot = 100;
    static final int T_Or = 101;
    static final int T_OrderBy = 102;
    static final int T_OrderByStable = 103;
    static final int T_Plus = 104;
    static final int T_Prefix = 105;
    static final int T_ProcessingInstruction = 106;
    static final int T_ProcessingInstructionLpar = 107;
    static final int T_Pragma = 108;
    static final int T_Extension = 109;
    static final int T_QMark = 110;
    static final int T_QName = 111;
    static final int T_QNameLpar = 112;
    static final int T_Rbrace = 113;
    static final int T_Rbrack = 114;
    static final int T_Return = 115;
    static final int T_Root = 116;
    static final int T_RootDescendants = 117;
    static final int T_Rpar = 118;
    static final int T_RparAs = 119;
    static final int T_S = 120;
    static final int T_Satisfies = 121;
    static final int T_SemiColon = 122;
    static final int T_Slash = 123;
    static final int T_SlashSlash = 124;
    static final int T_Some = 125;
    static final int T_Star = 126;
    static final int T_StarColonNCName = 127;
    static final int T_TagClose = 128;
    static final int T_StartTagOpen = 129;
    static final int T_StartTagOpenRoot = 130;
    static final int T_StringLiteral = 131;
    static final int T_TagQName = 132;
    static final int T_Text = 133;
    static final int T_TextLbrace = 134;
    static final int T_TextLpar = 135;
    static final int T_Then = 136;
    static final int T_To = 137;
    static final int T_TreatAs = 138;
    static final int T_TypeQName = 139;
    static final int T_TypeswitchLpar = 140;
    static final int T_URLLiteral = 141;
    static final int T_Union = 142;
    static final int T_Untyped = 143;
    static final int T_ValidateContext = 144;
    static final int T_Validate = 145;
    static final int T_ValueIndicator = 146;
    static final int T_VarName = 147;
    static final int T_Vbar = 148;
    static final int T_Where = 149;
    static final int T_WhitespaceChar = 150;
    static final int T_XmlComment = 151;
    static final int T_Cdata = 152;
    static final int T_Module = 153;
    static final int T_DocumentNodeLpar = 154;
    static final int T_ElementLpar = 155;
    static final int T_AttributeLpar = 156;
    static final int T_ItemLparRpar = 157;
    static final int T_XQueryVersion = 158;
    static final int T_ImportModule = 159;
    static final int T_DeclareVariable = 160;
    static final int T_External = 161;
    static final int T_ValidationStrict = 162;
    static final int T_ValidationSkip = 163;
    static final int T_ValidationLax = 164;
    static final int T_CommentLbrace = 166;
    static final int T_NamespaceLbrace = 167;
    static final int T_PILbrace = 168;
    static final int T_PINameLbrace = 169;
    static final int T_DeclareBaseURI = 171;
    static final int T_DeclareConstruction = 172;
    static final int T_DeclareOrdering = 173;
    static final int T_Ordered = 174;
    static final int T_Unordered = 175;
    static final int T_Template = 179;
    static final int T_CallTemplate = 180;
    static final int T_DeclareOption = 182;
    static final int T_DeclareBoundarySpace = 183;
    static final int T_DeclareDefaultOrder = 184;
    static final int T_DeclareCopyNamespaces = 185;
    static final int T_FTContains = 187;
    static final int T_FTOr = 188;
    static final int T_FTAnd = 189;
    static final int T_FTNotIn = 190;
    static final int T_FTNot = 191;
    static final int T_All = 192;
    static final int T_AllWords = 193;
    static final int T_Any = 194;
    static final int T_AnyWord = 195;
    static final int T_Phrase = 196;
    static final int T_AtEnd = 197;
    static final int T_AtLeast = 198;
    static final int T_AtMost = 199;
    static final int T_AtStart = 200;
    static final int T_CaseInsensitive = 201;
    static final int T_CaseSensitive = 202;
    static final int T_DiacriticsInsensitive = 203;
    static final int T_DiacriticsSensitive = 204;
    static final int T_Times = 205;
    static final int T_Distance = 206;
    static final int T_EntireContent = 207;
    static final int T_Exactly = 208;
    static final int T_From = 209;
    static final int T_Language = 210;
    static final int T_Levels = 211;
    static final int T_Lowercase = 212;
    static final int T_Occurs = 213;
    static final int T_Relationship = 214;
    static final int T_SameParagraph = 215;
    static final int T_SameSentence = 216;
    static final int T_DifferentParagraph = 217;
    static final int T_DifferentSentence = 218;
    static final int T_Paragraphs = 219;
    static final int T_Sentences = 220;
    static final int T_Uppercase = 221;
    static final int T_Window = 222;
    static final int T_WithDefaultStopWords = 223;
    static final int T_WithStopWords = 224;
    static final int T_WithThesaurus = 225;
    static final int T_WithWildcards = 226;
    static final int T_WithStemming = 227;
    static final int T_WithoutContent = 228;
    static final int T_WithoutStemming = 229;
    static final int T_WithoutStopWords = 230;
    static final int T_WithoutThesaurus = 231;
    static final int T_WithoutWildcards = 232;
    static final int T_Words = 233;
    static final int T_Weight = 234;
    static final int T_Scope = 235;
    static final int T_DeclareFTOption = 236;
    static final int T_Score = 237;
    static final int T_LetScoreVariable = 238;
    static final int T_FTExtension = 239;
    static final int T_InsertNodes = 240;
    static final int T_DeleteNodes = 241;
    static final int T_ReplaceNode = 242;
    static final int T_ReplaceValueOfNode = 243;
    static final int T_RenameNode = 244;
    static final int T_Copy = 245;
    static final int T_Modify = 246;
    static final int T_AsFirstInto = 247;
    static final int T_AsLastInto = 248;
    static final int T_Into = 249;
    static final int T_After = 250;
    static final int T_Before = 251;
    static final int T_With = 252;
    static final int T_DeclareUpdatingFunction = 253;
    static final int T_Dummy = 254;
    static final int T_ForTumbling = 255;
    static final int T_ForSliding = 256;
    static final int T_Start = 257;
    static final int T_End = 258;
    static final int T_OnlyEnd = 259;
    static final int T_When = 260;
    static final int T_Previous = 261;
    static final int T_Next = 262;
    static final int T_GroupBy = 263;
    static final int T_Try = 264;
    static final int T_Catch = 265;
    static final int T_Switch = 266;
    static final int T_Function = 267;
    static final int T_AllowingEmpty = 268;
    static final int T_Count = 269;
    static final int T_ContextItem = 270;
    static final int T_Declare = 280;
    static final int T_VarAssign = 281;
    static final int T_While = 282;
    static final int T_Exit = 283;
    static final int T_Block = 284;
    static final int T_AssignableFlag = 285;
    static final int T_DeterministicFlag = 286;
    static final int T_UndeterministicFlag = 287;
    static final int T_PrivateFlag = 288;
    static final int T_PublicFlag = 289;
    static final int T_SimpleFlag = 290;
    static final int T_UnassignableFlag = 291;
    static final int T_UpdatingFlag = 292;
    static final int T_SequentialFlag = 293;
    static CharTable tokenNames = new CharTable();
    static State defState;
    static State declareState;
    static State opState;
    static State vardeclState;
    static State itemTypeState;
    static State nsDeclState;
    static State occIndState;
    static State kindTestState;
    static State tagState;
    static State contentState;
    static State attrApostState;
    static State attrQuoteState;
    static State thesaurusState;
    static State POP_STATE;
    static State ERROR_STATE;
    public static final int LC_TAG = 1;
    public static final int LC_SPACE = 2;
    public static final int LC_NUMBER = 3;
    public static final int LC_STRING = 4;
    public static final int LC_MISC = 5;
    public static final int LC_NAME = 6;
    public static final int LC_KEYWORD = 7;
    public static final int LC_COMMENT = 8;
    public static final int LC_PRAGMA = 9;
    public static final int LC_FUNCTION = 10;
    public static boolean debug;
    protected static boolean trace;
    protected boolean showComments = false;
    ModuleContext currentModule;
    protected String source;
    protected int inputLength;
    protected char curChar;
    protected int curPtr;
    protected int curToken = -1;
    protected int tokenStart;
    protected int tokenEnd;
    protected int prevTokenLoc;
    protected State lexState;
    protected int stateSP;
    protected State[] states = new State[8];
    protected StringBuffer saveBuffer = new StringBuffer();
    protected String prefixValue;
    protected String localName;
    protected int numberToken;

    public void startLexer(String string) {
        this.source = string;
        this.inputLength = string.length();
        this.lexState = defState;
        this.stateSP = 0;
        this.tokenEnd = 0;
        this.next();
        if (debug) {
            System.err.println("===== Start lexer");
        }
    }

    protected void wantToken(int n) throws CompilationException {
        this.checkToken(n);
        this.nextToken();
    }

    protected void checkToken(int n) throws CompilationException {
        if (this.curToken != n) {
            this.syntax("expecting " + this.tokenName(n));
        }
    }

    protected boolean pickToken(int n) throws CompilationException {
        if (this.curToken != n) {
            return false;
        }
        this.nextToken();
        return true;
    }

    protected int nextToken() throws CompilationException {
        this.prevTokenLoc = this.tokenStart;
        this.curToken = this.getToken();
        return this.curToken;
    }

    protected String tokenName(int n) {
        String string = (String)tokenNames.get(n);
        if (string == null) {
            return "";
        }
        return string.replaceAll("\u00acQ", "[qname]").replaceAll("\u00acN", "[name]").replaceAll("\u00ac\\?", "").replaceAll("\u00acS", "[string]");
    }

    protected int getToken() throws CompilationException {
        do {
            if (debug) {
                System.err.print("In " + this.lexState.name + "\tat " + this.curPtr + " ");
                if (this.curChar <= ' ') {
                    System.err.print("#" + this.curChar + " ");
                } else {
                    System.err.print(this.curChar + "   ");
                }
            }
            this.saveBuffer.setLength(0);
            this.tokenStart = this.tokenEnd;
            if (this.curChar == '\u0000') {
                this.tokenEnd = this.inputLength;
                return 0;
            }
            if (!this.lexState.scan(this)) {
                this.lexicalError();
            }
            if (this.curToken != -2) continue;
            return this.storeToken(this.numberToken);
        } while (this.curToken == -1);
        return this.storeToken(this.curToken);
    }

    private int storeToken(int n) {
        if (debug) {
            System.err.println("\t=> Token " + n + " `" + this.tokenName(n) + "' [" + this.tokenStart + "-" + this.curPtr + "]" + (this.saveBuffer.length() > 0 ? " '" + this.saveBuffer + "'" : "") + " new state " + (this.lexState == null ? null : this.lexState.name));
        }
        this.curToken = n;
        return this.curToken;
    }

    public boolean match(Rule rule, State state) throws CompilationException {
        String string = rule.form;
        if (trace) {
            System.err.println("try rule " + rule.form);
        }
        this.curPtr = this.tokenStart;
        int n = -1;
        this.next();
        int n2 = string.length();
        block17: for (int i = 0; i < n2; ++i) {
            char c = string.charAt(i);
            if (c == ' ') {
                if (this.optSkip(state.allowsComments)) continue;
                return false;
            }
            if (c == '\u00a0') {
                if (this.reqSkip(state.allowsComments)) continue;
                return false;
            }
            if (c != '\u00ac') {
                if (c != this.curChar) {
                    if (trace) {
                        System.err.println(" fail at " + i + " on " + this.curChar);
                    }
                    return false;
                }
                this.next();
                continue;
            }
            c = string.charAt(++i);
            switch (c) {
                case 'C': {
                    if (!this.showComments) {
                        return false;
                    }
                    this.parseComment();
                    continue block17;
                }
                case 'c': {
                    this.parseCDATASection();
                    continue block17;
                }
                case 'u': {
                    if (this.pickNumber()) continue block17;
                    return false;
                }
                case 'N': {
                    if (this.pickName()) continue block17;
                    return false;
                }
                case 'P': {
                    this.parsePragma();
                    continue block17;
                }
                case 'p': {
                    this.parseProcessingInstruction();
                    continue block17;
                }
                case 'Q': {
                    if (this.pickQName()) continue block17;
                    return false;
                }
                case 'S': {
                    if (this.pickStringLiteral()) continue block17;
                    return false;
                }
                case 'E': {
                    this.parseCharRef();
                    continue block17;
                }
                case 't': {
                    if (this.pickContent('\u0000')) continue block17;
                    return false;
                }
                case 'A': 
                case 'a': {
                    if (this.pickContent(c == 'A' ? (char)'\"' : '\'')) continue block17;
                    return false;
                }
                case 'X': {
                    this.parseXMLComment();
                    continue block17;
                }
                case '?': {
                    n = this.curPtr - 1;
                    continue block17;
                }
                case 'k': {
                    if (this.curChar == '\u0000' || !this.isNameChar(this.curChar)) continue block17;
                    return false;
                }
                case '+': {
                    if (this.curPtr < 2) continue block17;
                    this.saveBuffer.append(this.source.charAt(this.curPtr - 2));
                    continue block17;
                }
                default: {
                    this.lexicalError("no such instr " + c);
                }
            }
        }
        this.curToken = rule.token;
        if (rule.nextState == ERROR_STATE) {
            this.backChar();
            this.lexicalError(rule.argument);
        }
        if (rule.nextState == POP_STATE) {
            this.popState();
        } else {
            this.lexState = rule.nextState;
        }
        if (rule.pushedState != null) {
            this.pushState(rule.pushedState);
        }
        this.tokenEnd = this.curPtr - 1;
        if (n >= 0) {
            this.curPtr = n;
            this.next();
        }
        if (trace) {
            System.err.println("matched rule " + rule.form);
        }
        return true;
    }

    private int parseProcessingInstruction() throws CompilationException {
        this.saveBuffer.setLength(0);
        while (true) {
            if (this.curChar != '?' && this.curChar != '\u0000') {
                this.save(this.curChar);
                this.next();
                continue;
            }
            if (this.curChar == '\u0000') {
                this.lexicalError("unterminated processing instruction");
            }
            if (this.pick("?>")) break;
            this.save(this.curChar);
            this.next();
        }
        return 106;
    }

    private int parseXMLComment() throws CompilationException {
        this.saveBuffer.setLength(0);
        while (true) {
            if (this.curChar != '-' && this.curChar != '\u0000') {
                this.save(this.curChar);
                this.next();
                continue;
            }
            if (this.curChar == '\u0000') {
                this.lexicalError("unterminated XML comment");
            }
            if (this.pick("-->")) break;
            this.save(this.curChar);
            this.next();
        }
        return 151;
    }

    private void parseCDATASection() throws CompilationException {
        this.saveBuffer.setLength(0);
        while (true) {
            if (this.curChar != ']' && this.curChar != '\u0000') {
                this.save(this.curChar);
                this.next();
                continue;
            }
            if (this.curChar == '\u0000') {
                this.lexicalError("unterminated CDATA section");
            }
            if (this.pick("]]>")) break;
            this.save(this.curChar);
            this.next();
        }
    }

    private boolean pickNumber() throws CompilationException {
        this.saveBuffer.setLength(0);
        this.numberToken = 76;
        while (Character.isDigit(this.curChar)) {
            this.save(this.curChar);
            this.next();
        }
        if (this.curChar == '.') {
            this.save(this.curChar);
            this.next();
            while (Character.isDigit(this.curChar)) {
                this.save(this.curChar);
                this.next();
            }
            if (this.saveBuffer.length() == 1) {
                this.numberToken = 44;
                return true;
            }
            this.numberToken = 34;
        }
        if (this.saveBuffer.length() == 0) {
            return false;
        }
        if (this.curChar == 'e' || this.curChar == 'E') {
            this.save(this.curChar);
            this.next();
            if (this.curChar == '+' || this.curChar == '-') {
                this.save(this.curChar);
                this.next();
            }
            if (!Character.isDigit(this.curChar)) {
                this.lexicalError("expecting digits in exponent");
            }
            while (Character.isDigit(this.curChar)) {
                this.save(this.curChar);
                this.next();
            }
            this.numberToken = 46;
        }
        if (Character.isLetter(this.curChar)) {
            this.lexicalError("numeric literal must not be followed by name");
        }
        return this.saveBuffer.length() != 1 || this.saveBuffer.charAt(0) != '.';
    }

    private boolean pickStringLiteral() throws CompilationException {
        if (this.curChar != '\"' && this.curChar != '\'') {
            return false;
        }
        this.saveBuffer.setLength(0);
        char c = this.curChar;
        this.next();
        while (true) {
            if (this.curChar == '\u0000') {
                this.lexicalError("unclosed string literal");
                return true;
            }
            if (this.curChar == c) {
                this.next();
                if (this.curChar != c) break;
                this.save(c);
            } else {
                if (this.curChar == '&') {
                    this.next();
                    this.parseCharRef();
                    continue;
                }
                this.save(this.curChar);
            }
            this.next();
        }
        return true;
    }

    private boolean pickContent(char c) throws CompilationException {
        this.saveBuffer.setLength(0);
        while (this.curChar != '\u0000' && this.curChar != '<' && this.curChar != '{' && this.curChar != '}' && this.curChar != '&' && this.curChar != c) {
            this.save(this.curChar);
            this.next();
        }
        return this.saveBuffer.length() > 0;
    }

    private void parseCharRef() throws CompilationException {
        if (this.pick('#')) {
            int n = 0;
            if (this.pick('x')) {
                int n2;
                while ((n2 = Character.digit(this.curChar, 16)) >= 0) {
                    n = 16 * n + n2;
                    this.next();
                }
            } else {
                int n3;
                while ((n3 = Character.digit(this.curChar, 10)) >= 0) {
                    n = 10 * n + Character.digit(this.curChar, 10);
                    this.next();
                }
            }
            if (n > 0 && n < 65534) {
                this.save((char)n);
            } else if (XMLUtil.isSupplementalChar(n)) {
                this.save(XMLUtil.highSurrogate(n));
                this.save(XMLUtil.lowSurrogate(n));
            } else {
                this.lexicalError("illegal character reference #" + n);
            }
        } else if (this.pickName("lt")) {
            this.save('<');
        } else if (this.pickName("gt")) {
            this.save('>');
        } else if (this.pickName("amp")) {
            this.save('&');
        } else if (this.pickName("quot")) {
            this.save('\"');
        } else if (this.pickName("apos")) {
            this.save('\'');
        } else {
            this.lexicalError("illegal character reference");
        }
        if (!this.pick(';')) {
            this.lexicalError("character reference not terminated by semicolon");
        }
    }

    private void parseComment() throws CompilationException {
        while (true) {
            if (this.curChar == '\u0000') {
                this.lexicalError("unclosed comment");
                continue;
            }
            if (this.pick(":)")) break;
            if (this.pick("(:")) {
                this.parseComment();
                continue;
            }
            this.next();
        }
    }

    private int parsePragma() throws CompilationException {
        while (Character.isWhitespace(this.curChar)) {
            this.next();
        }
        if (!this.pickQName()) {
            this.lexicalError("pragma should begin with a QName");
        }
        this.saveBuffer.setLength(0);
        while (true) {
            if (this.curChar == '\u0000') {
                this.lexicalError("unclosed pragma");
            } else if (this.pick("#)")) break;
            this.save(this.curChar);
            this.next();
        }
        if (this.saveBuffer.length() > 0 && !Character.isWhitespace(this.saveBuffer.charAt(0))) {
            this.lexicalError("whitespace required before pragma content");
        }
        return 108;
    }

    private boolean pickQName() {
        if (!this.pickName()) {
            return false;
        }
        this.prefixValue = "";
        if (this.pick(':')) {
            this.prefixValue = this.saveBuffer.toString();
            if (!this.pickName()) {
                this.backChar();
                this.prefixValue = "";
                return true;
            }
        }
        this.localName = this.saveBuffer.toString();
        return true;
    }

    private boolean pickName() {
        if (!this.isNameStart(this.curChar)) {
            return false;
        }
        this.saveBuffer.setLength(0);
        do {
            this.save(this.curChar);
            this.next();
        } while (this.curChar > ' ' && this.isNameChar(this.curChar));
        return true;
    }

    private boolean pickName(String string) {
        int n = this.curPtr;
        if (!this.pick(string)) {
            return false;
        }
        if (this.isNameChar(this.curChar)) {
            this.curPtr = n - 1;
            this.next();
            return false;
        }
        return true;
    }

    private boolean pick(char c) {
        if (this.curChar != c) {
            return false;
        }
        this.next();
        return true;
    }

    private boolean pick(String string) {
        if (this.curChar != string.charAt(0) || this.curPtr + string.length() - 1 > this.inputLength) {
            return false;
        }
        int n = this.curPtr;
        int n2 = string.length();
        while (--n2 >= 1) {
            if (this.source.charAt(this.curPtr + n2 - 1) == string.charAt(n2)) continue;
            this.curPtr = n - 1;
            this.next();
            return false;
        }
        this.curPtr += string.length() - 1;
        this.next();
        return true;
    }

    private boolean isNameStart(char c) {
        return c == '_' || Character.isLetter(c);
    }

    private boolean isNameChar(char c) {
        return Character.isUnicodeIdentifierPart(c) || c == '.' || c == '-';
    }

    private int next() {
        if (this.curPtr < this.inputLength) {
            this.curChar = this.source.charAt(this.curPtr++);
        } else {
            this.curChar = '\u0000';
            this.curPtr = this.inputLength + 1;
        }
        return this.curChar;
    }

    void backChar() {
        --this.curPtr;
        this.curChar = (char)(this.curPtr == 0 ? 10 : (int)this.source.charAt(this.curPtr - 1));
    }

    private boolean optSkip(boolean bl) throws CompilationException {
        while (true) {
            if (Character.isWhitespace(this.curChar)) {
                this.next();
                continue;
            }
            if (this.pick("{--")) {
                this.lexicalError("old-style comment");
            }
            if (this.showComments || !this.pick("(:") || !bl) break;
            this.parseComment();
        }
        return true;
    }

    private boolean reqSkip(boolean bl) throws CompilationException {
        if (!Character.isWhitespace(this.curChar)) {
            if (this.pick("{--")) {
                this.lexicalError("old-style comment");
            }
            if (!this.showComments && this.pick("(:") && bl) {
                this.parseComment();
            } else {
                return false;
            }
        }
        return this.optSkip(bl);
    }

    private void save(char c) {
        this.saveBuffer.append(c);
    }

    private void pushState(State state) {
        if (this.stateSP >= this.states.length) {
            State[] stateArray = this.states;
            this.states = new State[2 * stateArray.length];
            System.arraycopy(stateArray, 0, this.states, 0, stateArray.length);
        }
        this.states[this.stateSP++] = state;
        if (debug) {
            System.err.print("push " + state.name + " -> ");
            this.dumpStates();
        }
    }

    private void popState() {
        if (debug) {
            System.err.print("pop ");
            this.dumpStates();
        }
        if (this.stateSP > 0) {
            this.lexState = this.states[--this.stateSP];
        } else if (debug) {
            System.err.println("*** sp=0");
        }
    }

    private void dumpStates() {
        System.err.print("in state " + this.lexState.name);
        System.err.print("  stack ");
        for (int i = 0; i < this.stateSP; ++i) {
            System.err.print(" " + this.states[i].name);
        }
        System.err.println();
    }

    private void lexicalWarning(String string) {
        if (this.currentModule != null) {
            this.currentModule.warning(this.curPtr - 1, "lexical warning: " + string);
        }
    }

    private void lexicalError() throws CompilationException {
        this.lexicalError("illegal character");
    }

    private boolean lexicalError(String string) throws CompilationException {
        String string2;
        String string3 = this.curChar == '\u0000' ? "<end-of-text>" : (string2 = this.curChar <= ' ' ? "#" + this.curChar : "'" + this.curChar + "'");
        if (this.currentModule != null) {
            this.currentModule.error(ERR_SYNTAX, this.curPtr - 1, "lexical error on character " + string2 + ": " + string);
        }
        throw new CompilationException(string + " " + string2);
    }

    protected void syntax(String string) throws CompilationException {
        this.currentModule.error(ERR_SYNTAX, this.tokenStart, "syntax error, near " + this.tokenName(this.curToken) + " : " + string);
        throw new CompilationException("syntax error, " + string);
    }

    protected int getTokenCategory(int n) {
        switch (n) {
            case 120: {
                return 2;
            }
            case 34: 
            case 46: 
            case 76: {
                return 3;
            }
            case 131: 
            case 141: {
                return 4;
            }
            case 25: 
            case 27: 
            case 28: 
            case 54: 
            case 55: 
            case 99: 
            case 100: 
            case 106: 
            case 128: 
            case 129: 
            case 130: 
            case 132: 
            case 146: 
            case 151: {
                return 1;
            }
            case 56: 
            case 66: 
            case 67: 
            case 68: 
            case 81: 
            case 82: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 91: 
            case 104: 
            case 110: 
            case 118: 
            case 123: 
            case 126: 
            case 148: {
                return 5;
            }
            case 112: 
            case 113: {
                return 10;
            }
            case 92: 
            case 93: 
            case 111: 
            case 127: 
            case 139: 
            case 147: {
                return 6;
            }
            case 32: {
                return 8;
            }
            case 108: 
            case 109: {
                return 9;
            }
        }
        return 7;
    }

    static {
        POP_STATE = new State("pop!");
        ERROR_STATE = new State("error!");
        debug = false;
        trace = false;
        defState = new State("DEFAULT");
        declareState = new State("DECLARE");
        opState = new State("OPERATOR");
        itemTypeState = new State("ITEMTYPE");
        tagState = new State("TAG");
        Lexer.tagState.allowsComments = false;
        contentState = new State("ECONTENT");
        Lexer.contentState.allowsComments = false;
        Lexer.contentState.optSkip = false;
        attrApostState = new State("ATTR'");
        Lexer.attrApostState.optSkip = false;
        attrQuoteState = new State("ATTR\"");
        Lexer.attrQuoteState.optSkip = false;
        kindTestState = new State("KINDTEST");
        nsDeclState = new State("NSDECL");
        vardeclState = new State("VARDECL");
        occIndState = new State("OCCINDIC");
        thesaurusState = new State("THESAURUS");
        defState.addRule("\u0000", null, 0);
        defState.addRule("\u00acS", opState, 131);
        defState.addRule("\u00acu", opState, -2);
        defState.addRule("\u00acN:*", opState, 93);
        defState.addRule("\u00acQ (", defState, 112);
        defState.addRule("\u00acQ", opState, 111);
        defState.addRule("$ \u00acQ", opState, 147);
        defState.addRule("(#\u00acP", opState, 108);
        defState.addRule("(:\u00acC", defState, 32);
        defState.addRule("(", defState, 85);
        defState.addRule(") \u00ac?as first ", opState, 118);
        defState.addRule(") \u00ac?as last ", opState, 118);
        defState.addRule(") as", itemTypeState, 119);
        defState.addRule(")", opState, 118);
        defState.addRule("*:\u00acN", opState, 127);
        defState.addRule("*", opState, 126);
        defState.addRule("+", defState, 104);
        defState.addRule(",", defState, 31);
        defState.addRule("-", defState, 89);
        defState.addRule("..", opState, 45);
        defState.addRule("//", defState, 117);
        defState.addRule("/", defState, 116);
        defState.addRule(";", defState, 122);
        defState.addRule("<!--\u00acX", opState, 151);
        defState.addRule("<![CDATA[\u00acc", opState, 152);
        defState.addRule("<?\u00acp", opState, 106);
        defState.addRule("<\u00acQ", tagState, 129, opState);
        defState.addRule("?", opState, 110);
        defState.addRule("@", defState, 5);
        defState.addRule("[", defState, 83);
        defState.addRule("]", opState, 114);
        defState.addRule("{", defState, 82, opState);
        defState.addRule("}", POP_STATE, 113);
        defState.addRule("ancestor ::", defState, 9);
        defState.addRule("ancestor-or-self ::", defState, 10);
        defState.addRule("at \u00acS", opState, 6);
        defState.addRule("at least", defState, 198);
        defState.addRule("at most", defState, 199);
        defState.addRule("attribute ::", defState, 11);
        defState.addRule("attribute \u00acQ {", defState, 7, opState);
        defState.addRule("attribute {", defState, 8, opState);
        defState.addRule("attribute (", defState, 156);
        defState.addRule("block {", defState, 284, opState);
        defState.addRule("child ::", defState, 12);
        defState.addRule("comment (", defState, 33);
        defState.addRule("comment {", defState, 166, opState);
        defState.addRule("call template", opState, 180);
        defState.addRule("copy \u00ac?$", vardeclState, 245);
        defState.addRule("declare \u00ac?\u00acQ", declareState, 280);
        defState.addRule("declare \u00ac?$", vardeclState, 280);
        defState.addRule("descendant-or-self ::", defState, 14);
        defState.addRule("descendant ::", defState, 13);
        defState.addRule("document {", defState, 43, opState);
        defState.addRule("document-node (", defState, 154);
        defState.addRule("delete nodes", defState, 241);
        defState.addRule("delete node", defState, 241);
        defState.addRule("element \u00acQ {", defState, 48, opState);
        defState.addRule("element {", defState, 47, opState);
        defState.addRule("element (", defState, 155);
        defState.addRule("every \u00ac?$", vardeclState, 57);
        defState.addRule("empty-sequence ( )", opState, 51);
        defState.addRule("exactly", defState, 208);
        defState.addRule("exit returning", defState, 283);
        defState.addRule("following ::", defState, 15);
        defState.addRule("following-sibling ::", defState, 16);
        defState.addRule("for \u00ac?$", vardeclState, 59);
        defState.addRule("for tumbling window", vardeclState, 255);
        defState.addRule("for sliding window", vardeclState, 256);
        defState.addRule("from", defState, 209);
        defState.addRule("ftnot", defState, 191);
        defState.addRule("group by", defState, 263);
        defState.addRule("if (", defState, 71);
        defState.addRule("import schema", nsDeclState, 72);
        defState.addRule("import module", nsDeclState, 159);
        defState.addRule("insert nodes", defState, 240);
        defState.addRule("insert node", defState, 240);
        defState.addRule("item ( )", defState, 157);
        defState.addRule("let \u00ac?$", vardeclState, 84);
        defState.addRule("let score \u00ac?$", vardeclState, 238);
        defState.addRule("module namespace", nsDeclState, 153);
        defState.addRule("namespace ::", defState, 17);
        defState.addRule("namespace \u00acN {", defState, 167, opState);
        defState.addRule("node (", defState, 96);
        defState.addRule("not in", defState, 190);
        defState.addRule("order by", defState, 102);
        defState.addRule("ordered {", defState, 174, opState);
        defState.addRule("parent ::", defState, 18);
        defState.addRule("preceding-sibling ::", defState, 20);
        defState.addRule("preceding ::", defState, 19);
        defState.addRule("processing-instruction (", defState, 107);
        defState.addRule("processing-instruction {", defState, 168, opState);
        defState.addRule("processing-instruction \u00acN {", defState, 169, opState);
        defState.addRule("replace value of node", defState, 243);
        defState.addRule("replace node", defState, 242);
        defState.addRule("rename node", defState, 244);
        defState.addRule("self ::", defState, 21);
        defState.addRule("some \u00ac?$", vardeclState, 125);
        defState.addRule("stable order by", defState, 103);
        defState.addRule("switch (", defState, 266);
        defState.addRule("text {", defState, 134, opState);
        defState.addRule("text (", defState, 135);
        defState.addRule("typeswitch (", defState, 140);
        defState.addRule("try \u00ac?{", defState, 264);
        defState.addRule("unordered {", defState, 175, opState);
        defState.addRule("validate {", defState, 145);
        defState.addRule("xquery version \u00acS", defState, 158);
        defState.addRule("while (", defState, 282);
        declareState.addRule("assignable", declareState, 285);
        declareState.addRule("base-uri", nsDeclState, 171);
        declareState.addRule("boundary-space", defState, 183);
        declareState.addRule("construction", defState, 172);
        declareState.addRule("context item", defState, 270);
        declareState.addRule("copy-namespaces", defState, 185);
        declareState.addRule("default collation", nsDeclState, 37);
        declareState.addRule("default element namespace", defState, 38);
        declareState.addRule("default function namespace", defState, 39);
        declareState.addRule("default order empty", defState, 184);
        declareState.addRule("deterministic", declareState, 286);
        declareState.addRule("ft-option", opState, 236);
        declareState.addRule("function", defState, 40);
        declareState.addRule("namespace", nsDeclState, 35);
        declareState.addRule("nondeterministic", declareState, 287);
        declareState.addRule("option", defState, 182);
        declareState.addRule("ordering", defState, 173);
        declareState.addRule("private", declareState, 288);
        declareState.addRule("public", declareState, 289);
        declareState.addRule("revalidation lax", defState, 164);
        declareState.addRule("revalidation skip", defState, 163);
        declareState.addRule("revalidation strict", defState, 162);
        declareState.addRule("sequential", declareState, 293);
        declareState.addRule("simple", declareState, 290);
        declareState.addRule("template", defState, 179);
        declareState.addRule("unassignable", declareState, 291);
        declareState.addRule("updating", declareState, 292);
        declareState.addRule("variable \u00ac?$", vardeclState, 160);
        declareState.addRule("\u00acQ (", defState, 112);
        declareState.addRule("\u00acQ", defState, 111);
        declareState.addRule("(:\u00acC", declareState, 32);
        opState.addRule("\u0000", defState, 0);
        opState.addRule("\u00acS", opState, 131);
        opState.addRule("\u00acu", opState, -2);
        opState.addRule("\u00acQ", defState, 254);
        opState.addRule("!=", defState, 97);
        opState.addRule("(:\u00acC", opState, 32);
        opState.addRule("(#\u00acP", opState, 108);
        opState.addRule("(", defState, 85);
        opState.addRule(")", opState, 118);
        opState.addRule("*:\u00acN", opState, 127);
        opState.addRule("*", defState, 91);
        opState.addRule("+", defState, 104);
        opState.addRule("-", defState, 89);
        opState.addRule(",", defState, 31);
        opState.addRule("//", defState, 124);
        opState.addRule("/", defState, 123);
        opState.addRule(":=", defState, 30);
        opState.addRule(";", defState, 122);
        opState.addRule("<<", defState, 88);
        opState.addRule("<=", defState, 87);
        opState.addRule("<", defState, 86);
        opState.addRule("=", defState, 56);
        opState.addRule(">=", defState, 67);
        opState.addRule(">>", defState, 68);
        opState.addRule(">", defState, 66);
        opState.addRule("?", defState, 110);
        opState.addRule("|", defState, 148);
        opState.addRule("[", defState, 83);
        opState.addRule("]", opState, 114);
        opState.addRule("..", opState, 45);
        opState.addRule("after", defState, 250);
        opState.addRule("all words", opState, 193);
        opState.addRule("all", opState, 192);
        opState.addRule("any word", opState, 195);
        opState.addRule("any", opState, 194);
        opState.addRule("and", defState, 1);
        opState.addRule("ancestor ::", defState, 9);
        opState.addRule("ascending", opState, 3);
        opState.addRule("as first into", defState, 247);
        opState.addRule("as last into", defState, 248);
        opState.addRule("as", defState, 2);
        opState.addRule("at \u00acS", defState, 6);
        opState.addRule("at start", opState, 200);
        opState.addRule("at end", opState, 197);
        opState.addRule("at \u00ac?$", defState, 5);
        opState.addRule("at least", defState, 198);
        opState.addRule("at most", defState, 199);
        opState.addRule("before", defState, 251);
        opState.addRule("case insensitive", opState, 201);
        opState.addRule("case sensitive", opState, 202);
        opState.addRule("case \u00ac?$", vardeclState, 22);
        opState.addRule("case", itemTypeState, 22);
        opState.addRule("cast as", itemTypeState, 23);
        opState.addRule("castable as", itemTypeState, 24);
        opState.addRule("catch \u00ac?\u00acQ", defState, 265);
        opState.addRule("catch \u00ac?(", defState, 265);
        opState.addRule("catch \u00ac?*", defState, 265);
        opState.addRule("collation", defState, 29);
        opState.addRule("contains text", opState, 187);
        opState.addRule("count \u00ac?$", defState, 269);
        opState.addRule("default", vardeclState, 36);
        opState.addRule("delete nodes", defState, 241);
        opState.addRule("delete node", defState, 241);
        opState.addRule("descending", opState, 41);
        opState.addRule("diacritics insensitive", opState, 203);
        opState.addRule("diacritics sensitive", opState, 204);
        opState.addRule("div", defState, 42);
        opState.addRule("different sentence", opState, 218);
        opState.addRule("different paragraph", opState, 217);
        opState.addRule("distance", defState, 206);
        opState.addRule("else", defState, 50);
        opState.addRule("empty greatest", opState, 52);
        opState.addRule("empty least", opState, 53);
        opState.addRule("end \u00ac?$", vardeclState, 258);
        opState.addRule("end \u00ac?\u00acN", opState, 258);
        opState.addRule("eq", defState, 60);
        opState.addRule("every \u00ac?$", opState, 57);
        opState.addRule("exactly", defState, 208);
        opState.addRule("except", defState, 58);
        opState.addRule("external", defState, 161);
        opState.addRule("entire content", opState, 207);
        opState.addRule("for \u00ac?$", vardeclState, 59);
        opState.addRule("for tumbling window", vardeclState, 255);
        opState.addRule("for sliding window", vardeclState, 256);
        opState.addRule("from", defState, 209);
        opState.addRule("ftcontains", opState, 187);
        opState.addRule("ftor", opState, 188);
        opState.addRule("ftand", opState, 189);
        opState.addRule("ftnot", opState, 191);
        opState.addRule("ge", defState, 61);
        opState.addRule("gt", defState, 62);
        opState.addRule("global", defState, 69);
        opState.addRule("group by", defState, 263);
        opState.addRule("idiv", defState, 70);
        opState.addRule("into", defState, 249);
        opState.addRule("instance of", itemTypeState, 75);
        opState.addRule("intersect", defState, 77);
        opState.addRule("in", defState, 73);
        opState.addRule("is", defState, 78);
        opState.addRule("isnot", defState, 79);
        opState.addRule("item ( )", defState, 157);
        opState.addRule("let \u00ac?$", vardeclState, 84);
        opState.addRule("let score \u00ac?$", vardeclState, 238);
        opState.addRule("le", defState, 63);
        opState.addRule("lt", defState, 64);
        opState.addRule("language", defState, 210);
        opState.addRule("lowercase", opState, 212);
        opState.addRule("levels", opState, 211);
        opState.addRule("modify", defState, 246);
        opState.addRule("mod", defState, 90);
        opState.addRule("ne", defState, 65);
        opState.addRule("not in", defState, 190);
        opState.addRule("next \u00ac?$", vardeclState, 262);
        opState.addRule("only end \u00ac?$", vardeclState, 259);
        opState.addRule("only end \u00ac?\u00acN", opState, 259);
        opState.addRule("order by", defState, 102);
        opState.addRule("or", defState, 101);
        opState.addRule("occurs", defState, 213);
        opState.addRule("ordered", opState, 174);
        opState.addRule("option \u00acQ", defState, 239);
        opState.addRule("phrase", opState, 196);
        opState.addRule("paragraphs", opState, 219);
        opState.addRule("previous \u00ac?$", vardeclState, 261);
        opState.addRule("relationship \u00acS", opState, 214);
        opState.addRule("return", defState, 115);
        opState.addRule("same sentence", opState, 216);
        opState.addRule("same paragraph", opState, 215);
        opState.addRule("satisfies", defState, 121);
        opState.addRule("score \u00ac?$", vardeclState, 237);
        opState.addRule("sentences", opState, 220);
        opState.addRule("some \u00ac?$", opState, 125);
        opState.addRule("stable order by", defState, 103);
        opState.addRule("start \u00ac?\u00acN", opState, 257);
        opState.addRule("start \u00ac?$", vardeclState, 257);
        opState.addRule("then", defState, 136);
        opState.addRule("to", defState, 137);
        opState.addRule("treat as", itemTypeState, 138);
        opState.addRule("typeswitch (", defState, 140);
        opState.addRule("times", opState, 205);
        opState.addRule("union", defState, 142);
        opState.addRule("uppercase", opState, 221);
        opState.addRule("using case insensitive", opState, 201);
        opState.addRule("using case sensitive", opState, 202);
        opState.addRule("using diacritics insensitive", opState, 203);
        opState.addRule("using diacritics sensitive", opState, 204);
        opState.addRule("using language", defState, 210);
        opState.addRule("using option \u00acQ", defState, 239);
        opState.addRule("using stemming", opState, 227);
        opState.addRule("using wildcards", opState, 226);
        opState.addRule("using thesaurus", thesaurusState, 225);
        opState.addRule("using default stop words", opState, 223);
        opState.addRule("using stop words", opState, 224);
        opState.addRule("using no content", defState, 228);
        opState.addRule("using no stemming", opState, 229);
        opState.addRule("using no wildcards", opState, 232);
        opState.addRule("using no thesaurus", opState, 231);
        opState.addRule("using no stop words", opState, 230);
        opState.addRule("using lowercase", opState, 212);
        opState.addRule("using uppercase", opState, 221);
        opState.addRule("validate {", opState, 145);
        opState.addRule("weight", defState, 234);
        opState.addRule("when", defState, 260);
        opState.addRule("where", defState, 149);
        opState.addRule("window", defState, 222);
        opState.addRule("with stemming", opState, 227);
        opState.addRule("with wildcards", opState, 226);
        opState.addRule("with thesaurus", thesaurusState, 225);
        opState.addRule("with default stop words", opState, 223);
        opState.addRule("with stop words", opState, 224);
        opState.addRule("with", defState, 252);
        opState.addRule("without content", defState, 228);
        opState.addRule("without stemming", opState, 229);
        opState.addRule("without wildcards", opState, 232);
        opState.addRule("without thesaurus", opState, 231);
        opState.addRule("without stop words", opState, 230);
        opState.addRule("words", opState, 233);
        opState.addRule("{", defState, 82, opState);
        opState.addRule("}", POP_STATE, 113);
        thesaurusState.addRule("default", defState, 36);
        thesaurusState.addRule("at \u00acS", opState, 6);
        thesaurusState.addRule("(", thesaurusState, 85);
        itemTypeState.addRule("\u0000", null, 0);
        itemTypeState.addRule("(:\u00acC", itemTypeState, 32);
        itemTypeState.addRule("\u00acQ", occIndState, 111);
        itemTypeState.addRule(") as", itemTypeState, 119);
        itemTypeState.addRule(")", opState, 118);
        itemTypeState.addRule("*:\u00acN", opState, 127);
        itemTypeState.addRule("..", opState, 45);
        itemTypeState.addRule(".", opState, 44);
        itemTypeState.addRule("{", defState, 82, defState);
        itemTypeState.addRule("attribute (", kindTestState, 156, occIndState);
        itemTypeState.addRule("comment (", kindTestState, 33, occIndState);
        itemTypeState.addRule("document-node (", kindTestState, 154, occIndState);
        itemTypeState.addRule("element (", kindTestState, 155, occIndState);
        itemTypeState.addRule("empty-sequence ( )", opState, 51);
        itemTypeState.addRule("item ( )", occIndState, 157);
        itemTypeState.addRule("node (", kindTestState, 96, occIndState);
        itemTypeState.addRule("processing-instruction (", kindTestState, 107, occIndState);
        itemTypeState.addRule("text (", kindTestState, 135, occIndState);
        itemTypeState.addRule("untyped", defState, 143);
        itemTypeState.addRule("when", defState, 260);
        occIndState.addRule("?", opState, 110);
        occIndState.addRule("+", opState, 104);
        occIndState.addRule("*", opState, 126);
        occIndState.addRule("", opState, -1);
        tagState.addRule("\u0000", null, 0);
        tagState.addRule("\"", attrQuoteState, 100);
        tagState.addRule("'", attrApostState, 99);
        tagState.addRule(">", contentState, 128);
        tagState.addRule("/>", POP_STATE, 54);
        tagState.addRule("=", tagState, 146);
        tagState.addRule("\u00acQ", tagState, 132);
        contentState.addRule("\u0000", null, 0);
        contentState.addRule("<!--\u00acX", contentState, 151);
        contentState.addRule("<![CDATA[\u00acc", contentState, 152);
        contentState.addRule("<?\u00acp", contentState, 106);
        contentState.addRule("</\u00acQ >", POP_STATE, 55);
        contentState.addRule("<\u00acQ", tagState, 129, contentState);
        contentState.addRule("{{\u00ac+", contentState, 25);
        contentState.addRule("{", defState, 81, contentState);
        contentState.addRule("}}\u00ac+", contentState, 25, null);
        contentState.addRule("}", ERROR_STATE, 0, null, "'}' must be escaped by '}}'");
        contentState.addRule("\u00act", contentState, 25);
        contentState.addRule("&\u00acE", contentState, 26);
        attrApostState.addRule("''\u00ac+", attrApostState, 25);
        attrApostState.addRule("'", tagState, 27);
        attrApostState.addRule("{{\u00ac+", defState, 25);
        attrApostState.addRule("{", defState, 81, attrApostState);
        attrApostState.addRule("}}\u00ac+", attrApostState, 25);
        attrApostState.addRule("}", ERROR_STATE, 0, null, "'}' must be escaped by '}}'");
        attrApostState.addRule("<", ERROR_STATE, 0, null, "illegal character in attribute");
        attrApostState.addRule("&\u00acE", attrApostState, 26);
        attrApostState.addRule("\u00aca", attrApostState, 25);
        attrQuoteState.addRule("\"\"\u00ac+", attrQuoteState, 25);
        attrQuoteState.addRule("\"", tagState, 28);
        attrQuoteState.addRule("{{\u00ac+", defState, 25);
        attrQuoteState.addRule("{", defState, 81, attrQuoteState);
        attrQuoteState.addRule("}}\u00ac+", attrQuoteState, 25);
        attrQuoteState.addRule("}", ERROR_STATE, 0, null, "'}' must be escaped by '}}'");
        attrQuoteState.addRule("<", ERROR_STATE, 0, null, "illegal character in attribute");
        attrQuoteState.addRule("\u00acA", attrQuoteState, 25);
        attrQuoteState.addRule("&\u00acE", attrQuoteState, 26);
        kindTestState.addRule("\u0000", null, 0);
        kindTestState.addRule("(:\u00acC", kindTestState, 32);
        kindTestState.addRule("{", kindTestState, 81);
        kindTestState.addRule(")", POP_STATE, 118);
        kindTestState.addRule("*", kindTestState, 126);
        kindTestState.addRule("@", kindTestState, 5);
        kindTestState.addRule(",", kindTestState, 31);
        kindTestState.addRule("element (", kindTestState, 155, kindTestState);
        kindTestState.addRule("\u00acQ", kindTestState, 111);
        kindTestState.addRule("\u00acS", kindTestState, 131);
        kindTestState.addRule("", opState, -1);
        nsDeclState.addRule("\u0000", null, 0);
        nsDeclState.addRule("(:\u00acC", nsDeclState, 32);
        nsDeclState.addRule("=", nsDeclState, 4);
        nsDeclState.addRule("\u00acS", defState, 141);
        nsDeclState.addRule("\u00acN", nsDeclState, 92);
        nsDeclState.addRule("namespace", nsDeclState, 94);
        vardeclState.addRule("\u0000", null, 0);
        vardeclState.addRule("$ \u00acQ", vardeclState, 147);
        vardeclState.addRule(":=", defState, 30);
        vardeclState.addRule(",", defState, 31);
        vardeclState.addRule(";", defState, 122);
        vardeclState.addRule("{", defState, 81, opState);
        vardeclState.addRule("(:\u00acC", vardeclState, 32);
        vardeclState.addRule(")", vardeclState, 118);
        vardeclState.addRule("as ", itemTypeState, 2);
        vardeclState.addRule("at \u00ac?$", defState, 5);
        vardeclState.addRule("external", defState, 161);
        vardeclState.addRule("in", defState, 73);
        vardeclState.addRule("return", defState, 115);
        vardeclState.addRule("score \u00ac?$", defState, 237);
        vardeclState.addRule("previous \u00ac?$", vardeclState, 261);
        vardeclState.addRule("next \u00ac?$", vardeclState, 262);
        vardeclState.addRule("when", defState, 260);
        tokenNames.put(0, "end");
        tokenNames.put(46, "[double]");
        tokenNames.put(76, "[integer]");
        tokenNames.put(34, "[decimal]");
        tokenNames.put(111, "[qname]");
        tokenNames.put(25, "[text]");
    }

    private static class Rule {
        String form;
        State nextState;
        State pushedState;
        int token;
        String argument;

        public Rule(String string, State state, State state2, int n, String string2) {
            this.nextState = state;
            this.pushedState = state2;
            this.token = n;
            this.argument = string2;
            int n2 = string.length();
            StringBuffer stringBuffer = new StringBuffer(n2);
            int n3 = n2;
            for (int i = 0; i < n3; ++i) {
                int n4 = string.charAt(i);
                if (n4 == 32 && i > 1 && Character.isLetter(string.charAt(i - 1)) && (i <= 2 || string.charAt(i - 2) != '\u00ac') && i + 1 < n3 && Character.isLetter(string.charAt(i + 1))) {
                    n4 = 160;
                }
                stringBuffer.append((char)n4);
            }
            if (n2 >= 1 && Character.isLetter(string.charAt(n2 - 1)) && (n2 < 2 || string.charAt(n2 - 2) != '\u00ac')) {
                stringBuffer.append("\u00ack");
            }
            this.form = stringBuffer.toString();
            if (n > 0) {
                tokenNames.put(n, string);
            }
        }
    }

    private static class State {
        String name;
        CharTable mainSwitch;
        Rule fallbackRule;
        boolean optSkip;
        boolean allowsComments;

        State(String string) {
            this.name = string;
            this.mainSwitch = new CharTable();
            this.allowsComments = true;
            this.optSkip = true;
        }

        void addRule(String string, State state, int n) {
            this.addRule(string, state, n, null, null);
        }

        void addRule(String string, State state, int n, State state2) {
            this.addRule(string, state, n, state2, null);
        }

        void addRule(String string, State state, int n, State state2, String string2) {
            Rule rule = new Rule(string, state, state2, n, string2);
            if (string.length() == 0) {
                this.fallbackRule = rule;
            } else {
                ArrayList<Rule> arrayList;
                int n2 = string.charAt(0);
                if (n2 == 172 || n2 == 32) {
                    n2 = 128;
                }
                if ((arrayList = (ArrayList<Rule>)this.mainSwitch.get(n2)) == null) {
                    arrayList = new ArrayList<Rule>();
                    this.mainSwitch.put(n2, arrayList);
                }
                arrayList.add(rule);
            }
        }

        boolean scan(Lexer lexer) throws CompilationException {
            Rule rule;
            int n;
            if (this.optSkip) {
                lexer.optSkip(this.allowsComments);
            }
            lexer.tokenStart = lexer.curPtr - 1;
            char c = lexer.curChar;
            ArrayList arrayList = (ArrayList)this.mainSwitch.get(c);
            if (arrayList != null) {
                for (n = 0; n < arrayList.size(); ++n) {
                    rule = (Rule)arrayList.get(n);
                    if (!lexer.match(rule, this)) continue;
                    return true;
                }
            }
            if ((arrayList = (ArrayList)this.mainSwitch.get(128)) != null) {
                for (n = 0; n < arrayList.size(); ++n) {
                    rule = (Rule)arrayList.get(n);
                    if (!lexer.match(rule, this)) continue;
                    return true;
                }
            }
            if (this.fallbackRule != null) {
                return lexer.match(this.fallbackRule, this);
            }
            return false;
        }

        public String toString() {
            return "State " + this.name;
        }
    }
}

