/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.xquery.op;

import com.qizx.api.EvaluationException;
import com.qizx.xquery.EvalContext;
import com.qizx.xquery.ExprDisplay;
import com.qizx.xquery.Focus;
import com.qizx.xquery.ModuleContext;
import com.qizx.xquery.XQValue;
import com.qizx.xquery.op.Expression;
import com.qizx.xquery.op.LetClause;
import com.qizx.xquery.op.LocalVariable;
import com.qizx.xquery.op.VarClause;

public class BlockExpr
extends Expression {
    public Expression body;
    private Expression[] clauses = new Expression[0];

    public VarClause addClause(LetClause letClause) {
        this.clauses = BlockExpr.addExpr(this.clauses, letClause);
        return letClause;
    }

    LetClause getClause(int n) {
        return n < 0 || n >= this.clauses.length ? null : (LetClause)this.clauses[n];
    }

    public Expression child(int n) {
        if (n < this.clauses.length) {
            return this.clauses[n];
        }
        if ((n -= this.clauses.length) == 0) {
            return this.body;
        }
        return null;
    }

    public void dump(ExprDisplay exprDisplay) {
        exprDisplay.header(this);
        exprDisplay.children(this.clauses);
        exprDisplay.child("body", this.body);
    }

    public int getFlags() {
        return this.body.getFlags();
    }

    public Expression staticCheck(ModuleContext moduleContext, int n) {
        LocalVariable localVariable = moduleContext.latestLocalVariable();
        for (int i = 0; i < this.clauses.length; ++i) {
            moduleContext.staticCheck(this.clauses[i], 0);
        }
        this.body = moduleContext.simpleStaticCheck(this.body, 0);
        this.type = this.body.getType().itemType().star;
        moduleContext.popLocalVariables(localVariable);
        return this;
    }

    public XQValue eval(Focus focus, EvalContext evalContext) throws EvaluationException {
        for (int i = 0; i < this.clauses.length; ++i) {
            LetClause letClause = this.getClause(i);
            if (letClause.expr != null) {
                evalContext.storeLocal(letClause.varDecl, letClause.expr, null, false, focus, evalContext);
                continue;
            }
            evalContext.storeLocal(letClause.varDecl.address, XQValue.empty, false, null);
        }
        return this.body.eval(focus, evalContext);
    }
}

