/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.xquery.op;

import com.qizx.api.DataModelException;
import com.qizx.api.EvaluationException;
import com.qizx.api.Node;
import com.qizx.queries.FullText;
import com.qizx.util.basic.Check;
import com.qizx.xquery.DynamicContext;
import com.qizx.xquery.EvalContext;
import com.qizx.xquery.Focus;
import com.qizx.xquery.ModuleContext;
import com.qizx.xquery.XQValue;
import com.qizx.xquery.op.BooleanExpression;
import com.qizx.xquery.op.Expression;
import com.qizx.xquery.op.FTSelectionOp;
import java.util.HashSet;

public class FTContainsOp
extends BooleanExpression {
    public Expression container;
    public FTSelectionOp selection;
    public Expression ignore;
    private FullText.Selection cachedQuery;

    public FTContainsOp(Expression expression, FTSelectionOp fTSelectionOp) {
        this.container = expression;
        this.selection = fTSelectionOp;
    }

    public Expression child(int n) {
        switch (n) {
            case 0: {
                return this.container;
            }
            case 1: {
                return this.selection;
            }
            case 2: {
                return this.ignore;
            }
        }
        return null;
    }

    public Expression staticCheck(ModuleContext moduleContext, int n) {
        this.container = moduleContext.staticCheck(this.container, n);
        this.selection = (FTSelectionOp)moduleContext.staticCheck(this.selection, n);
        if (this.ignore != null) {
            this.ignore = moduleContext.staticCheck(this.ignore, n);
        }
        if (this.selection.isConstant()) {
            EvalContext evalContext = moduleContext.getConstantEvalContext();
            try {
                this.cachedQuery = this.selection.expand(null, evalContext, moduleContext.getDefaultFTOptions(), 1.0f);
                this.cachedQuery = this.cachedQuery.applyThesauri();
            }
            catch (EvaluationException evaluationException) {
                // empty catch block
            }
        }
        return this;
    }

    public FullText.Selection expandSelection(Focus focus, EvalContext evalContext, FullText.MatchOptions matchOptions, float f) throws EvaluationException {
        Check.nonNull(matchOptions, "inherited match options");
        return this.selection.expand(focus, evalContext, matchOptions, f);
    }

    public boolean evalAsBoolean(Focus focus, EvalContext evalContext) throws EvaluationException {
        DynamicContext dynamicContext = evalContext.dynamicContext();
        FullText.Selection selection = this.cachedQuery;
        if (selection == null) {
            selection = this.selection.expand(focus, evalContext, dynamicContext.getDefaultFTOptions(), 1.0f);
            selection = selection.applyThesauri();
        }
        XQValue xQValue = this.container.eval(focus, evalContext);
        HashSet<Node> hashSet = null;
        if (this.ignore != null) {
            XQValue xQValue2 = this.ignore.eval(focus, evalContext);
            hashSet = new HashSet<Node>();
            while (xQValue2.next()) {
                Node node = xQValue2.getNode();
                hashSet.add(node);
            }
        }
        try {
            return selection.matches(xQValue, hashSet, dynamicContext.getFulltextFactory());
        }
        catch (DataModelException dataModelException) {
            evalContext.error(dataModelException.getErrorCode(), (Expression)this, "data model error" + dataModelException.getMessage());
            return false;
        }
    }
}

