/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.xquery.op;

import com.qizx.api.EvaluationException;
import com.qizx.queries.FullText;
import com.qizx.xquery.EvalContext;
import com.qizx.xquery.Focus;
import com.qizx.xquery.ModuleContext;
import com.qizx.xquery.XQType;
import com.qizx.xquery.op.Expression;
import com.qizx.xquery.op.FTPosFilters;
import com.qizx.xquery.op.RangeExpr;

public abstract class FTSelectionOp
extends Expression {
    public Expression[] children;
    public Expression weight;
    public FTPosFilters posFilters;
    public FullText.MatchOptions matchOptions;

    public FTSelectionOp() {
    }

    public FTSelectionOp(Expression expression) {
        this.children = new Expression[]{expression};
    }

    public void addChild(Expression expression) {
        this.children = FTSelectionOp.addExpr(this.children, expression);
    }

    public Expression child(int n) {
        if (this.children == null || n >= this.children.length) {
            return null;
        }
        return this.children[n];
    }

    public Expression staticCheck(ModuleContext moduleContext, int n) {
        for (int i = 0; i < this.children.length; ++i) {
            this.children[i] = moduleContext.staticCheck(this.children[i], n);
        }
        if (this.posFilters != null) {
            this.posFilters.distance = (RangeExpr)moduleContext.staticCheck(this.posFilters.distance, 0);
            this.posFilters.windowExpr = moduleContext.staticCheck(this.posFilters.windowExpr, 0);
        }
        if (this.weight != null) {
            this.weight = moduleContext.staticCheck(this.weight, n);
        }
        return this;
    }

    public abstract FullText.Selection expand(Focus var1, EvalContext var2, FullText.MatchOptions var3, float var4) throws EvaluationException;

    protected void expandOptions(FullText.Selection selection, Focus focus, EvalContext evalContext, FullText.MatchOptions matchOptions, float f) throws EvaluationException {
        selection.setMatchOptions(this.expandMatchOptions(matchOptions));
        selection.setPosFilters(this.expandPositionFilters(focus, evalContext));
        selection.setWeight(this.expandWeight(focus, evalContext, f));
    }

    protected FullText.PosFilters expandPositionFilters(Focus focus, EvalContext evalContext) throws EvaluationException {
        if (this.posFilters == null) {
            return null;
        }
        FullText.PosFilters posFilters = new FullText.PosFilters(this.posFilters);
        if (this.posFilters.distance != null) {
            posFilters.distanceRange = this.posFilters.distance.evaluate(focus, evalContext);
        }
        if (this.posFilters.windowExpr != null) {
            if (this.posFilters.windowUnit != 1) {
                evalContext.error("FTST0003", (Expression)this, "unsupported window unit");
            }
            if (!XQType.NUMERIC.accepts(this.posFilters.windowExpr.getType())) {
                evalContext.error("XPTY0004", this.posFilters.windowExpr);
            }
            posFilters.window = (int)this.posFilters.windowExpr.evalAsInteger(focus, evalContext);
        }
        return posFilters;
    }

    protected FullText.MatchOptions expandMatchOptions(FullText.MatchOptions matchOptions) {
        FullText.MatchOptions matchOptions2 = matchOptions;
        if (this.matchOptions != null) {
            matchOptions2 = new FullText.MatchOptions(this.matchOptions);
            if (matchOptions2.language == null) {
                matchOptions2.language = matchOptions.language;
            }
            if (matchOptions2.caseSensitivity == 0) {
                matchOptions2.caseSensitivity = matchOptions.caseSensitivity;
            }
            if (matchOptions2.diacritics == 0) {
                matchOptions2.diacritics = matchOptions.diacritics;
            }
            if (matchOptions2.stemming == 0) {
                matchOptions2.stemming = matchOptions.stemming;
            }
            if (matchOptions2.wildcards == 0) {
                matchOptions2.wildcards = matchOptions.wildcards;
            }
            if (matchOptions2.thesauri == null) {
                matchOptions2.thesauri = matchOptions.thesauri;
            }
        }
        return matchOptions2;
    }

    protected float expandWeight(Focus focus, EvalContext evalContext, float f) throws EvaluationException {
        if (this.weight != null) {
            return this.weight.evalAsFloat(focus, evalContext);
        }
        return f;
    }

    public int getFlags() {
        return this.isConstant() ? 32 : 0;
    }

    public boolean isConstant() {
        for (int i = 0; i < this.children.length; ++i) {
            if (this.children[i].isConstant()) continue;
            return false;
        }
        if (this.posFilters == null) {
            return true;
        }
        return !(this.posFilters.distance != null && !this.posFilters.distance.isConstant() || this.posFilters.windowExpr != null && !this.posFilters.windowExpr.isConstant());
    }

    public boolean hasExcludesOrOccurs() {
        for (int i = 0; i < this.children.length; ++i) {
            if (!(this.children[i] instanceof FTSelectionOp) || !((FTSelectionOp)this.children[i]).hasExcludesOrOccurs()) continue;
            return true;
        }
        return false;
    }
}

