/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.xquery.op;

import com.qizx.api.EvaluationException;
import com.qizx.xquery.EvalContext;
import com.qizx.xquery.ExprDisplay;
import com.qizx.xquery.Focus;
import com.qizx.xquery.ModuleContext;
import com.qizx.xquery.XQItem;
import com.qizx.xquery.XQType;
import com.qizx.xquery.XQValue;
import com.qizx.xquery.dt.FunctionItem;
import com.qizx.xquery.dt.FunctionType;
import com.qizx.xquery.fn.Prototype;
import com.qizx.xquery.op.Expression;

public class FunctionItemCall
extends Expression {
    public Expression function;
    public Expression[] args = new Expression[0];

    public FunctionItemCall(Expression expression) {
        this.function = expression;
    }

    public void addArgument(Expression expression) {
        this.args = FunctionItemCall.addExpr(this.args, expression);
    }

    public int getArgCount() {
        return this.args.length;
    }

    public Expression child(int n) {
        return n == 0 ? this.function : (n < this.args.length ? this.args[n - 1] : null);
    }

    public void dump(ExprDisplay exprDisplay) {
        exprDisplay.header(this);
        exprDisplay.child("function", this.function);
        exprDisplay.children(this.args);
    }

    public Expression staticCheck(ModuleContext moduleContext, int n) {
        this.function = moduleContext.staticCheck(this.function, 0);
        for (int i = 0; i < this.args.length; ++i) {
            this.args[i] = moduleContext.staticCheck(this.args[i], 0);
        }
        XQType xQType = this.function.getType();
        if (xQType instanceof FunctionType) {
            Prototype prototype = ((FunctionType)xQType).getSignature();
            if (prototype != null && !prototype.accepts(this.args.length)) {
                moduleContext.error("XPTY0004", (Expression)this, "invalid number of arguments");
            }
            this.type = prototype.returnType;
        }
        return this;
    }

    public XQValue eval(Focus focus, EvalContext evalContext) throws EvaluationException {
        XQItem xQItem = this.function.evalAsItem(focus, evalContext);
        if (!(xQItem instanceof FunctionItem)) {
            evalContext.badTypeForArg(XQType.FUNCTION, this.function, 0, "function item");
        }
        FunctionItem functionItem = (FunctionItem)xQItem;
        Prototype prototype = functionItem.prototype;
        return prototype.invoke(this.args, this, functionItem.lexicalContext, focus, evalContext);
    }
}

