/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.xquery.op;

import com.qizx.api.EvaluationException;
import com.qizx.api.util.time.DateTimeException;
import com.qizx.api.util.time.Duration;
import com.qizx.xdm.Conversion;
import com.qizx.xquery.EvalContext;
import com.qizx.xquery.ExprDisplay;
import com.qizx.xquery.Focus;
import com.qizx.xquery.ModuleContext;
import com.qizx.xquery.XQItem;
import com.qizx.xquery.XQValue;
import com.qizx.xquery.dt.SingleDecimal;
import com.qizx.xquery.dt.SingleDouble;
import com.qizx.xquery.dt.SingleDuration;
import com.qizx.xquery.dt.SingleFloat;
import com.qizx.xquery.dt.SingleInteger;
import com.qizx.xquery.dt.SingleItem;
import com.qizx.xquery.fn.Function;
import com.qizx.xquery.fn.Prototype;
import com.qizx.xquery.op.Expression;
import com.qizx.xquery.op.NumericOp;

public class MulOp
extends NumericOp {
    public MulOp(Expression expression, Expression expression2) {
        super(expression, expression2);
    }

    public Prototype[] getProtos() {
        return null;
    }

    public void dump(ExprDisplay exprDisplay) {
        exprDisplay.header(this);
        exprDisplay.child("expr1", this.operands[0]);
        exprDisplay.child("expr2", this.operands[1]);
    }

    public Expression staticCheck(ModuleContext moduleContext, int n) {
        switch (this.combinedArgTypes(moduleContext)) {
            case 17: {
                return this.transfer(new ExecInt(), this.operands);
            }
            case 20: 
            case 36: 
            case 52: 
            case 65: 
            case 66: 
            case 67: 
            case 68: {
                return this.transfer(new ExecDouble(), this.operands);
            }
        }
        return this.transfer(new ExecAny(), this.operands);
    }

    public static class ExecAny
    extends Function.NumericCall {
        public XQValue eval(Focus focus, EvalContext evalContext) throws EvaluationException {
            XQItem xQItem = this.args[0].evalAsOptItem(focus, evalContext);
            XQItem xQItem2 = this.args[1].evalAsOptItem(focus, evalContext);
            evalContext.at(this);
            if (xQItem == null || xQItem2 == null) {
                return XQValue.empty;
            }
            switch (NumericOp.combinedArgTypes(xQItem, xQItem2)) {
                case 17: {
                    long l = xQItem.getInteger();
                    long l2 = xQItem2.getInteger();
                    if (!Conversion.isIntegerRange((double)l * (double)l2)) {
                        evalContext.error("FOAR0002", (Expression)this, "integer overflow");
                    }
                    return new SingleInteger(l * l2);
                }
                case 18: 
                case 33: 
                case 34: {
                    return new SingleDecimal(xQItem.getDecimal().multiply(xQItem2.getDecimal()));
                }
                case 19: 
                case 35: 
                case 49: 
                case 50: 
                case 51: {
                    return new SingleFloat(xQItem.getFloat() * xQItem2.getFloat());
                }
                case 20: 
                case 36: 
                case 52: 
                case 65: 
                case 66: 
                case 67: 
                case 68: {
                    return new SingleDouble(xQItem.getDouble() * xQItem2.getDouble());
                }
                case 161: 
                case 162: 
                case 163: 
                case 164: {
                    return this.mulYM(xQItem.getDuration(), xQItem2.getDouble(), evalContext);
                }
                case 26: 
                case 42: 
                case 58: 
                case 74: {
                    return this.mulYM(xQItem2.getDuration(), xQItem.getDouble(), evalContext);
                }
                case 177: 
                case 178: 
                case 179: 
                case 180: {
                    return this.mulDT(xQItem.getDuration(), xQItem2.getDouble(), evalContext);
                }
                case 27: 
                case 43: 
                case 59: 
                case 75: {
                    return this.mulDT(xQItem2.getDuration(), xQItem.getDouble(), evalContext);
                }
            }
            evalContext.error("XPTY0004", (Expression)this, "invalid types for operator *");
            return new SingleItem(xQItem);
        }

        private XQValue mulDT(Duration duration, double d, EvalContext evalContext) throws EvaluationException {
            try {
                if (Double.isNaN(d)) {
                    evalContext.error("FOCA0005", (Expression)this, "invalid argument");
                }
                if (Double.isInfinite(d)) {
                    evalContext.error("FODT0002", (Expression)this, "invalid argument");
                }
                return SingleDuration.newDT(Duration.newDayTime(duration.getTotalSeconds() * d));
            }
            catch (DateTimeException dateTimeException) {
                evalContext.error("XPTY0004", (Expression)this, "OOPS " + dateTimeException);
                return null;
            }
        }

        private XQValue mulYM(Duration duration, double d, EvalContext evalContext) throws EvaluationException {
            try {
                if (Double.isNaN(d)) {
                    evalContext.error("FOCA0005", (Expression)this, "invalid argument");
                }
                if (Double.isInfinite(d)) {
                    evalContext.error("FODT0002", (Expression)this, "invalid argument");
                }
                return SingleDuration.newYM(Duration.newYearMonth((int)Math.round((double)duration.getTotalMonths() * d)));
            }
            catch (DateTimeException dateTimeException) {
                evalContext.error("XPTY0004", (Expression)this, "OOPS " + dateTimeException);
                return null;
            }
        }
    }

    public static class ExecDouble
    extends Function.OptDoubleCall {
        public double evalAsOptDouble(Focus focus, EvalContext evalContext) throws EvaluationException {
            double d = this.args[0].evalAsOptDouble(focus, evalContext);
            double d2 = this.args[1].evalAsOptDouble(focus, evalContext);
            evalContext.at(this);
            return d * d2;
        }
    }

    public static class ExecInt
    extends Function.OptIntegerCall {
        public long evalAsOptInteger(Focus focus, EvalContext evalContext) throws EvaluationException {
            long l = this.args[0].evalAsOptInteger(focus, evalContext);
            long l2 = this.args[1].evalAsOptInteger(focus, evalContext);
            evalContext.at(this);
            if (!Conversion.isIntegerRange((double)l * (double)l2)) {
                evalContext.error("FOAR0002", (Expression)this, "integer overflow");
            }
            return l * l2;
        }
    }
}

