/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.xquery.op;

import com.qizx.api.EvaluationException;
import com.qizx.api.QName;
import com.qizx.xdm.BasicNode;
import com.qizx.xdm.CoreDataModel;
import com.qizx.xdm.IQName;
import com.qizx.xdm.XMLPushStreamBase;
import com.qizx.xdm.XQName;
import com.qizx.xquery.EvalContext;
import com.qizx.xquery.ExprDisplay;
import com.qizx.xquery.Focus;
import com.qizx.xquery.ModuleContext;
import com.qizx.xquery.XQItem;
import com.qizx.xquery.XQValue;
import com.qizx.xquery.op.Expression;
import com.qizx.xquery.op.NodeConstructor;
import com.qizx.xquery.op.TextLiteral;

public abstract class NamedConstructor
extends NodeConstructor {
    public Expression name;

    public NamedConstructor(Expression expression) {
        this.contents = new Expression[0];
        this.name = expression;
    }

    public Expression child(int n) {
        return n == 0 ? this.name : (n <= this.contents.length ? this.contents[n - 1] : null);
    }

    public void dump(ExprDisplay exprDisplay) {
        exprDisplay.header(this);
        exprDisplay.child("name", this.name);
        exprDisplay.children(this.contents);
    }

    public Expression staticCheck(ModuleContext moduleContext, int n) {
        super.staticCheck(moduleContext, n);
        if (this.name != null) {
            this.name = moduleContext.staticCheck(this.name, 0);
        }
        return this;
    }

    public boolean isConstant() {
        return this.name.isConstant() && super.isConstant();
    }

    public Expression addTextItem(String string) {
        Expression expression = null;
        TextLiteral textLiteral = null;
        if (this.contents.length > 0 && (expression = this.contents[this.contents.length - 1]) instanceof TextLiteral) {
            textLiteral = (TextLiteral)expression;
            textLiteral.value = textLiteral.value + string;
        } else {
            textLiteral = new TextLiteral(string);
            this.addItem(textLiteral);
        }
        return textLiteral;
    }

    protected QName evalName(XMLPushStreamBase xMLPushStreamBase, Focus focus, EvalContext evalContext) throws EvaluationException {
        XQItem xQItem = this.name.evalAsItem(focus, evalContext);
        return this.computeName(xQItem, xMLPushStreamBase, evalContext);
    }

    private QName computeName(XQItem xQItem, XMLPushStreamBase xMLPushStreamBase, EvalContext evalContext) throws EvaluationException {
        BasicNode basicNode = null;
        int n = xQItem.getItemType().quickCode();
        if (xQItem.isNode()) {
            basicNode = xQItem.basicNode();
            n = 5;
        }
        evalContext.at(this);
        switch (n) {
            case 5: 
            case 6: {
                try {
                    String string = xQItem.getString();
                    String string2 = IQName.extractPrefix(string);
                    String string3 = IQName.extractLocalName(string);
                    if (string2.length() == 0) {
                        return XQName.get("", string3, "");
                    }
                    QName qName = null;
                    String string4 = null;
                    if (basicNode != null) {
                        string4 = basicNode.getNamespaceUri(string2);
                    }
                    if (string4 == null && xMLPushStreamBase != null) {
                        string4 = xMLPushStreamBase.getNSURI(string2);
                    }
                    if ((qName = string4 != null ? XQName.get(string4, string3, string2) : evalContext.getStaticContext().getInScopeNS().expandName(string)) == null) {
                        evalContext.error("XQDY0074", (Expression)this, "no namespace found for prefix " + string2);
                    }
                    return qName;
                }
                catch (Exception exception) {
                    evalContext.error("XQDY0074", (Expression)this, "error converting string to QName: " + exception.getMessage());
                    return null;
                }
            }
            case 15: {
                return xQItem.getQName();
            }
        }
        evalContext.badTypeForArg(xQItem.getItemType(), this.name, 0, "QName or string");
        return null;
    }

    String evalContents(Focus focus, EvalContext evalContext) throws EvaluationException {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.contents.length; ++i) {
            XQValue xQValue = this.contents[i].eval(focus, evalContext);
            if (xQValue.next()) {
                stringBuffer.append(xQValue.getString());
            }
            while (xQValue.next()) {
                stringBuffer.append(' ');
                stringBuffer.append(xQValue.getString());
            }
        }
        return stringBuffer.toString();
    }

    protected void evalContents(CoreDataModel.CoreNode coreNode, Focus focus, EvalContext evalContext) throws EvaluationException {
        for (int i = 0; i < this.contents.length; ++i) {
            XQValue xQValue = this.contents[i].eval(focus, evalContext);
            boolean bl = true;
            while (xQValue.next()) {
                if (!bl) {
                    coreNode.addText(" ");
                }
                coreNode.addText(xQValue.getString());
                bl = false;
            }
        }
    }
}

