/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.xquery.op;

import com.qizx.api.EvaluationException;
import com.qizx.xquery.EvalContext;
import com.qizx.xquery.ExprDisplay;
import com.qizx.xquery.Focus;
import com.qizx.xquery.ModuleContext;
import com.qizx.xquery.XQItem;
import com.qizx.xquery.XQValue;
import com.qizx.xquery.dt.SingleDecimal;
import com.qizx.xquery.dt.SingleDouble;
import com.qizx.xquery.dt.SingleFloat;
import com.qizx.xquery.dt.SingleInteger;
import com.qizx.xquery.fn.Function;
import com.qizx.xquery.op.Expression;
import java.math.BigDecimal;

public class NegateOp
extends Expression {
    public Expression[] operands;

    public NegateOp(Expression expression) {
        this.operands = new Expression[]{expression};
    }

    public Expression child(int n) {
        return n < this.operands.length ? this.operands[n] : null;
    }

    public void dump(ExprDisplay exprDisplay) {
        exprDisplay.header(this);
        exprDisplay.child("expr", this.operands[0]);
    }

    public Expression staticCheck(ModuleContext moduleContext, int n) {
        this.operands[0] = moduleContext.staticCheck(this.operands[0], 0);
        this.setType(this.operands[0].getType());
        return this.transfer(new ExecAny(), this.operands);
    }

    public static class ExecAny
    extends Function.NumericCall {
        public XQValue eval(Focus focus, EvalContext evalContext) throws EvaluationException {
            XQItem xQItem = this.args[0].evalAsOptItem(focus, evalContext);
            evalContext.at(this);
            if (xQItem == null) {
                return XQValue.empty;
            }
            switch (xQItem.getItemType().quickCode()) {
                case 1: {
                    long l = xQItem.getInteger();
                    return new SingleInteger(-l);
                }
                case 2: {
                    BigDecimal bigDecimal = xQItem.getDecimal();
                    return new SingleDecimal(bigDecimal.negate());
                }
                case 3: {
                    return new SingleFloat(-xQItem.getFloat());
                }
                case 4: 
                case 5: {
                    return new SingleDouble(-xQItem.getDouble());
                }
            }
            evalContext.error("XPTY0004", (Expression)this, "invalid type for unary operator -");
            return null;
        }
    }
}

