/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.xquery.op;

import com.qizx.api.EvaluationException;
import com.qizx.api.Item;
import com.qizx.api.ItemType;
import com.qizx.api.Node;
import com.qizx.api.QizxException;
import com.qizx.xdm.BaseNodeFilter;
import com.qizx.xdm.BasicNode;
import com.qizx.xdm.NodeFilter;
import com.qizx.xdm.XMLPushStreamBase;
import com.qizx.xquery.EvalContext;
import com.qizx.xquery.ExprDisplay;
import com.qizx.xquery.Focus;
import com.qizx.xquery.ModuleContext;
import com.qizx.xquery.XQItem;
import com.qizx.xquery.XQItemType;
import com.qizx.xquery.XQType;
import com.qizx.xquery.XQValue;
import com.qizx.xquery.dt.SingleSourceSequence;
import com.qizx.xquery.op.BasicStep;
import com.qizx.xquery.op.ChildStep;
import com.qizx.xquery.op.DescendantOrSelfStep;
import com.qizx.xquery.op.DescendantStep;
import com.qizx.xquery.op.Expression;
import com.qizx.xquery.op.NodeSortExpr;
import com.qizx.xquery.op.SelfStep;
import com.qizx.xquery.op.UnionOp;
import java.math.BigDecimal;

public class PathExpr
extends Expression {
    public Expression[] steps = new Expression[0];
    boolean needsSort = false;
    boolean lastStepNotNode = false;
    int textMode;
    public static final int TEXTMODE_CHILD = 1;
    public static final int TEXTMODE_DESC = 2;

    public PathExpr() {
    }

    public PathExpr(Expression expression) {
        this.steps = new Expression[]{expression};
    }

    public int getStepCount() {
        return this.steps.length;
    }

    public Expression getStep(int n) {
        return n < 0 || n >= this.steps.length ? null : this.steps[n];
    }

    public void addStep(Expression expression) {
        if (expression instanceof UnionOp) {
            expression = ((UnionOp)expression).reduce();
        }
        if (expression instanceof ChildStep && this.steps.length > 0 && this.steps[this.steps.length - 1] instanceof DescendantOrSelfStep && ((BasicStep)this.steps[this.steps.length - 1]).nodeTest == null) {
            this.steps[this.steps.length - 1] = new DescendantStep(((BasicStep)expression).nodeTest);
            return;
        }
        this.steps = PathExpr.addExpr(this.steps, expression);
    }

    public Expression child(int n) {
        return n < this.steps.length ? this.steps[n] : null;
    }

    public void dump(ExprDisplay exprDisplay) {
        exprDisplay.header(this);
        if (this.needsSort) {
            exprDisplay.property("needsSort", "" + this.needsSort);
        }
        exprDisplay.children(this.steps);
    }

    public int getFlags() {
        return 8;
    }

    public Expression staticCheck(ModuleContext moduleContext, int n) {
        this.type = moduleContext.getDotType() == null ? XQType.NODE.star : moduleContext.getDotType();
        boolean bl = true;
        int n2 = this.steps.length - 1;
        for (int i = 0; i <= n2; ++i) {
            moduleContext.pushDotType(this.type);
            Expression expression = this.steps[i] = moduleContext.staticCheck(this.steps[i], 0);
            moduleContext.popDotType();
            this.type = this.steps[i].getType();
            XQItemType xQItemType = this.type == null ? XQType.ITEM : this.type.itemType();
            boolean bl2 = XQType.NODE.accepts(xQItemType);
            if (!(xQItemType == XQType.ITEM || bl2 || i == n2 || i == 0 && XQType.WRAPPED_OBJECT.isSuperType(xQItemType))) {
                moduleContext.error("XPTY0019", expression, "invalid type for path step: " + expression.getType().toString(moduleContext) + "'");
            }
            if (i == n2 && !bl2) {
                this.lastStepNotNode = true;
            }
            if (i > 0) {
                this.staticTypeCheck(this.steps[i - 1], expression, moduleContext);
            }
            this.type = xQItemType.star;
            int n3 = this.steps[i].getFlags();
            if (bl2 && ((n3 & 8) == 0 || i > 0 && ((n3 & 1) == 0 || !bl) && (n3 & 2) == 0)) {
                this.needsSort = true;
            }
            bl = (n3 & 4) != 0;
        }
        return this;
    }

    private void staticTypeCheck(Expression expression, Expression expression2, ModuleContext moduleContext) {
        int n;
        if (!(expression instanceof BasicStep) || !(expression2 instanceof BasicStep)) {
            return;
        }
        NodeFilter nodeFilter = ((BasicStep)expression).nodeTest;
        NodeFilter nodeFilter2 = ((BasicStep)expression2).nodeTest;
        int n2 = nodeFilter2 == null ? -1 : nodeFilter2.getNodeKind();
        int n3 = n = nodeFilter == null ? -1 : nodeFilter.getNodeKind();
        if (expression2 instanceof SelfStep) {
            if (n2 != n && n >= 0 && n2 >= 0) {
                moduleContext.error("XPST0005", expression2, "self:: with incompatible node kind");
            } else if (nodeFilter2 instanceof BaseNodeFilter && nodeFilter instanceof BaseNodeFilter) {
                BaseNodeFilter baseNodeFilter = (BaseNodeFilter)nodeFilter2;
                BaseNodeFilter baseNodeFilter2 = (BaseNodeFilter)nodeFilter;
                if (baseNodeFilter.name != null && baseNodeFilter2.name != null && baseNodeFilter.name != baseNodeFilter2.name) {
                    moduleContext.error("XPST0005", expression2, "self:: with incompatible node name");
                }
            }
        }
        switch (n) {
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                if (n2 == 2) {
                    moduleContext.error("XPST0005", expression2, "node kind incompatible with previous step");
                }
                if (!(expression2 instanceof ChildStep) && (!(expression2 instanceof DescendantStep) || expression2 instanceof DescendantOrSelfStep)) break;
                moduleContext.error("XPST0005", expression2, "meaningless path step after attribute");
                break;
            }
            case 1: {
                if (expression2 instanceof SelfStep || expression2 instanceof ChildStep || expression2 instanceof DescendantStep) break;
                moduleContext.error("XPST0005", expression2, "meaningless path after root");
            }
        }
    }

    public XQValue eval(Focus focus, EvalContext evalContext) throws EvaluationException {
        return evalContext.evalPath(this, focus);
    }

    public void tryToTrim() {
        if (this.steps.length < 2) {
            return;
        }
        Expression expression = this.getStep(this.steps.length - 1);
        if (expression instanceof ChildStep) {
            ChildStep childStep = (ChildStep)expression;
            if (childStep.nodeTest != null && childStep.nodeTest.getNodeKind() == 7) {
                this.textMode = 1;
                int n = this.steps.length - 1;
                expression = this.getStep(this.steps.length - 2);
                if (expression instanceof DescendantOrSelfStep) {
                    n = this.steps.length - 2;
                }
                Expression[] expressionArray = new Expression[n];
                System.arraycopy(this.steps, 0, expressionArray, 0, n);
                this.steps = expressionArray;
            }
        }
    }

    public void evalAsEvents(XMLPushStreamBase xMLPushStreamBase, Focus focus, EvalContext evalContext) throws EvaluationException {
        XQValue xQValue = this.eval(focus, evalContext);
        try {
            while (xQValue.next()) {
                if (xQValue.isNode()) {
                    BasicNode basicNode = xQValue.basicNode();
                    if (this.textMode == 1) {
                        xMLPushStreamBase.putNodeText(basicNode, 2);
                        continue;
                    }
                    if (this.textMode == 1) {
                        xMLPushStreamBase.putNodeText(basicNode, Integer.MAX_VALUE);
                        continue;
                    }
                    xMLPushStreamBase.putNodeCopy(basicNode, evalContext.getStaticContext().getCopyNSMode());
                    continue;
                }
                xMLPushStreamBase.putAtomText(xQValue.getString());
            }
        }
        catch (QizxException qizxException) {
            evalContext.error(qizxException.getErrorCode(), (Expression)this, "error in constructor: " + qizxException.getMessage());
        }
    }

    public XQValue evalNextSteps(XQValue xQValue, int n, EvalContext evalContext) throws EvaluationException {
        int n2 = this.steps.length - 1;
        for (int i = n; i <= n2; ++i) {
            Expression expression = this.getStep(i);
            if (this.lastStepNotNode && i == n2 && this.needsSort) {
                xQValue = new NodeSortExpr.Sequence(xQValue);
            }
            xQValue = new Composition(xQValue, expression, evalContext);
        }
        if (this.needsSort && !this.lastStepNotNode) {
            xQValue = new NodeSortExpr.Sequence(xQValue);
        }
        return xQValue;
    }

    public class Composition
    extends SingleSourceSequence
    implements Focus {
        EvalContext context;
        Expression step;
        XQValue stepSeq;
        BasicStep basicStep;
        long position;
        long last;

        public Composition(XQValue xQValue, Expression expression, EvalContext evalContext) {
            super(xQValue);
            this.position = 0L;
            this.last = -1L;
            this.step = expression;
            this.context = evalContext;
            this.stepSeq = XQValue.empty;
            if (expression instanceof BasicStep) {
                this.basicStep = (BasicStep)expression;
            }
            this.position = 0L;
        }

        public XQValue bornAgain() {
            return new Composition(this.source.bornAgain(), this.step, this.context);
        }

        public boolean next() throws EvaluationException {
            while (true) {
                if (this.stepSeq.next()) {
                    this.item = this.stepSeq.getItem();
                    return true;
                }
                this.item = null;
                if (!this.source.next()) {
                    return false;
                }
                ++this.position;
                this.context.at(this.step);
                if (this.basicStep != null) {
                    this.stepSeq = this.basicStep.eval(this, this.context, this.stepSeq);
                    continue;
                }
                this.stepSeq = this.step.eval(this, this.context);
            }
        }

        public ItemType getType() throws EvaluationException {
            return this.stepSeq.getType();
        }

        public BasicNode getBasicNode() throws EvaluationException {
            return this.item.basicNode();
        }

        public boolean getBoolean() throws EvaluationException {
            return this.stepSeq.getBoolean();
        }

        public BigDecimal getDecimal() throws EvaluationException {
            return this.stepSeq.getDecimal();
        }

        public double getDouble() throws EvaluationException {
            return this.stepSeq.getDouble();
        }

        public float getFloat() throws EvaluationException {
            return this.stepSeq.getFloat();
        }

        public long getInteger() throws EvaluationException {
            return this.stepSeq.getInteger();
        }

        public String getString() throws EvaluationException {
            return this.stepSeq.getString();
        }

        public XQItem currentItem() throws EvaluationException {
            return this.source.getItem();
        }

        public Node currentItemAsNode() throws EvaluationException {
            return this.source.getNode();
        }

        public long currentItemAsInteger() throws EvaluationException {
            return this.source.getInteger();
        }

        public double currentItemAsDouble() throws EvaluationException {
            return this.source.getDouble();
        }

        public String currentItemAsString() throws EvaluationException {
            return this.source.getString();
        }

        public long getPosition() {
            return this.position;
        }

        public long getLast() {
            if (this.last < 0L) {
                try {
                    XQValue xQValue = this.source.bornAgain();
                    this.last = 0L;
                    while (xQValue.next()) {
                        ++this.last;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return this.last;
        }

        public double getFulltextScore(Item item) throws EvaluationException {
            if (item == null) {
                item = this.getNode();
            }
            return this.stepSeq.getFulltextScore(item);
        }
    }
}

