/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.netutil;

import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.text.DateFormat;
import java.util.Date;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public final class HttpsURLConnectionUtil {
    private static final SSLSocketFactory STRICT_SSL_SOCKET_FACTORY;
    private static SSLSocketFactory LAX_SSL_SOCKET_FACTORY;
    private static final HostnameVerifier STRICT_HOSTNAME_VERIFIER;
    private static final HostnameVerifier LAX_HOSTNAME_VERIFIER;

    private HttpsURLConnectionUtil() {
    }

    private static final X509TrustManager createTrustManager(KeyStore keyStore) throws KeyStoreException, NoSuchAlgorithmException {
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance("SunX509");
        trustManagerFactory.init(keyStore);
        TrustManager[] trustManagerArray = trustManagerFactory.getTrustManagers();
        for (int i = 0; i < trustManagerArray.length; ++i) {
            if (!(trustManagerArray[i] instanceof X509TrustManager)) continue;
            return (X509TrustManager)trustManagerArray[i];
        }
        return null;
    }

    private static final String toString(X509Certificate[] x509CertificateArray) {
        StringBuffer stringBuffer = new StringBuffer();
        HttpsURLConnectionUtil.toString(x509CertificateArray, stringBuffer);
        return stringBuffer.toString();
    }

    private static final void toString(X509Certificate[] x509CertificateArray, StringBuffer stringBuffer) {
        for (int i = 0; i < x509CertificateArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append("---\n");
            }
            HttpsURLConnectionUtil.toString(x509CertificateArray[i], stringBuffer);
        }
    }

    private static final String toString(X509Certificate x509Certificate) {
        StringBuffer stringBuffer = new StringBuffer();
        HttpsURLConnectionUtil.toString(x509Certificate, stringBuffer);
        return stringBuffer.toString();
    }

    private static final void toString(X509Certificate x509Certificate, StringBuffer stringBuffer) {
        Principal principal = x509Certificate.getSubjectDN();
        Principal principal2 = x509Certificate.getIssuerDN();
        Date date = x509Certificate.getNotBefore();
        Date date2 = x509Certificate.getNotAfter();
        stringBuffer.append("Issued to: ");
        stringBuffer.append(((Object)principal).toString());
        stringBuffer.append('\n');
        stringBuffer.append("Issued by: ");
        stringBuffer.append(((Object)principal2).toString());
        stringBuffer.append('\n');
        stringBuffer.append("Issued on: ");
        DateFormat dateFormat = DateFormat.getDateInstance(2);
        stringBuffer.append(dateFormat.format(date));
        stringBuffer.append('\n');
        stringBuffer.append("Expires on: ");
        stringBuffer.append(dateFormat.format(date2));
        stringBuffer.append('\n');
    }

    public static void setValidateServer(boolean bl) {
        if (bl) {
            HttpsURLConnection.setDefaultSSLSocketFactory(STRICT_SSL_SOCKET_FACTORY);
            HttpsURLConnection.setDefaultHostnameVerifier(STRICT_HOSTNAME_VERIFIER);
        } else {
            HttpsURLConnection.setDefaultSSLSocketFactory(LAX_SSL_SOCKET_FACTORY);
            HttpsURLConnection.setDefaultHostnameVerifier(LAX_HOSTNAME_VERIFIER);
        }
    }

    public static boolean getValidateServer() {
        return HttpsURLConnection.getDefaultSSLSocketFactory() == STRICT_SSL_SOCKET_FACTORY;
    }

    static /* synthetic */ X509TrustManager access$000(KeyStore keyStore) throws KeyStoreException, NoSuchAlgorithmException {
        return HttpsURLConnectionUtil.createTrustManager(keyStore);
    }

    static {
        LAX_SSL_SOCKET_FACTORY = STRICT_SSL_SOCKET_FACTORY = (SSLSocketFactory)SSLSocketFactory.getDefault();
        try {
            TrustManager[] trustManagerArray = new TrustManager[]{new TrustManagerImpl()};
            SSLContext sSLContext = SSLContext.getInstance("TLS");
            sSLContext.init(null, trustManagerArray, null);
            LAX_SSL_SOCKET_FACTORY = sSLContext.getSocketFactory();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        STRICT_HOSTNAME_VERIFIER = new HostnameVerifier(){

            public boolean verify(String string, SSLSession sSLSession) {
                return false;
            }
        };
        LAX_HOSTNAME_VERIFIER = new HostnameVerifier(){

            public boolean verify(String string, SSLSession sSLSession) {
                return true;
            }
        };
    }

    private static final class TrustManagerImpl
    implements X509TrustManager {
        private X509TrustManager delegate = HttpsURLConnectionUtil.access$000(null);

        public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
            this.delegate.checkClientTrusted(x509CertificateArray, string);
        }

        public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        }

        public X509Certificate[] getAcceptedIssuers() {
            return this.delegate.getAcceptedIssuers();
        }
    }
}

