/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.util;

import com.xmlmind.util.Console;
import com.xmlmind.util.Msg;
import com.xmlmind.util.SystemUtil;
import com.xmlmind.util.URIComponent;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;

public final class FileUtil {
    private static final Object mkdirsLock = new Object();
    private static DecimalFormat fileSizeFormatDefault = new DecimalFormat("0.#");
    private static DecimalFormat fileSizeFormatUS = new DecimalFormat("0.#", new DecimalFormatSymbols(Locale.US));
    private static Boolean fetchGetTotalSpaceMethod = Boolean.TRUE;
    private static Method getTotalSpaceMethod = null;
    private static Boolean fetchGetUsableSpaceMethod = Boolean.TRUE;
    private static Method getUsableSpaceMethod = null;
    private static Boolean fetchCanExecuteMethod = Boolean.TRUE;
    private static Method canExecuteMethod = null;
    private static Boolean fetchSetExecutableMethod = Boolean.TRUE;
    private static Method setExecutableMethod = null;
    private static Boolean fetchIsHiddenMethod = Boolean.TRUE;
    private static Method isHiddenMethod = null;

    private FileUtil() {
    }

    public static URL fileToURL(File file) {
        if (SystemUtil.IS_WINDOWS) {
            boolean bl = true;
            try {
                file = file.getCanonicalFile();
                bl = false;
            }
            catch (IOException iOException) {
                file = file.getAbsoluteFile();
            }
            String string = FileUtil.getVolume(file);
            if (string != null && string.startsWith("\\\\")) {
                String string2 = file.getPath();
                if (string2.equals(string)) {
                    string2 = string2 + "\\";
                }
                string2 = "C:" + string2.substring(string.length());
                URI uRI = new File(string2).toURI();
                if (bl) {
                    uRI = uRI.normalize();
                }
                string2 = uRI.toASCIIString();
                if (file.isDirectory() && !string2.endsWith("/")) {
                    string2 = string2 + "/";
                }
                string2 = string2.substring(8);
                try {
                    return new URL("file:" + string.replace('\\', '/') + string2);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    return null;
                }
            }
            return FileUtil.convertFileToURL(file, bl);
        }
        return FileUtil.convertFileToURL(file);
    }

    private static URL convertFileToURL(File file) {
        boolean bl = true;
        if (SystemUtil.IS_WINDOWS) {
            try {
                file = file.getCanonicalFile();
                bl = false;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return FileUtil.convertFileToURL(file, bl);
    }

    private static URL convertFileToURL(File file, boolean bl) {
        URI uRI = file.toURI();
        if (bl) {
            uRI = uRI.normalize();
        }
        try {
            return new URL(uRI.toASCIIString());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static String getExtension(File file) {
        return FileUtil.getExtension(file.getPath());
    }

    public static String getExtension(String string) {
        int n = FileUtil.indexOfDot(string, File.separatorChar);
        if (n < 0) {
            return null;
        }
        return string.substring(n + 1);
    }

    public static int indexOfDot(String string, char c) {
        int n = string.lastIndexOf(46);
        if (n >= 0) {
            int n2 = string.lastIndexOf(c);
            n2 = n2 < 0 ? 0 : ++n2;
            if (n <= n2) {
                n = -1;
            }
        }
        return n;
    }

    public static File setExtension(File file, String string) {
        String string2 = file.getPath();
        String string3 = FileUtil.setExtension(string2, string);
        if (string3.equals(string2)) {
            return file;
        }
        return new File(string3);
    }

    public static String setExtension(String string, String string2) {
        if (string.endsWith(File.separator)) {
            return string;
        }
        int n = FileUtil.indexOfDot(string, File.separatorChar);
        if (n < 0) {
            if (string2 == null) {
                return string;
            }
            return string + "." + string2;
        }
        if (string2 == null) {
            return string.substring(0, n);
        }
        return string.substring(0, n + 1) + string2;
    }

    public static String getRelativePath(File file, File file2) {
        if (!file.isAbsolute()) {
            file = file.getAbsoluteFile();
        }
        String string = file.getPath();
        if (!file2.isAbsolute()) {
            file2 = file2.getAbsoluteFile();
        }
        if (!file2.isDirectory() && (file2 = file2.getParentFile()) == null) {
            return string;
        }
        String string2 = file2.getPath();
        if (!string2.endsWith(File.separator)) {
            string2 = string2 + File.separator;
        }
        String string3 = FileUtil.getVolume(file);
        String string4 = FileUtil.getVolume(file2);
        if (string3 == null || string4 == null || !string3.equalsIgnoreCase(string4) || string.equals(string3 + File.separator)) {
            return string;
        }
        if (SystemUtil.IS_WINDOWS) {
            string = string.substring(string3.length());
            string2 = string2.substring(string4.length());
            string = string.replace('\\', '/');
            string2 = string2.replace('\\', '/');
            String string5 = URIComponent.getRawRelativePath(string, string2);
            String string6 = URIComponent.getRawRelativePath(string = string.toLowerCase(), string2 = string2.toLowerCase());
            if (!string6.equalsIgnoreCase(string5)) {
                string5 = string6;
            }
            return string5.replace('/', '\\');
        }
        return URIComponent.getRawRelativePath(string, string2);
    }

    public static String getVolume(File file) {
        block7: {
            block9: {
                String string;
                block11: {
                    int n;
                    block10: {
                        block8: {
                            if (!SystemUtil.IS_WINDOWS) break block7;
                            string = file.isAbsolute() ? file.getPath() : file.getAbsolutePath();
                            if (!string.startsWith("\\\\")) break block8;
                            int n2 = string.indexOf(92, 2);
                            if (n2 >= 0) {
                                int n3 = string.indexOf(92, n2 + 1);
                                if (n3 >= 0) {
                                    return string.substring(0, n3);
                                }
                                if (string.length() > n2 + 1) {
                                    return string;
                                }
                            }
                            break block9;
                        }
                        n = 0;
                        if (string.length() < 2 || string.charAt(1) != ':') break block10;
                        char c = string.charAt(0);
                        n = c;
                        if (c >= 'A' && n <= 90) break block11;
                    }
                    if (n < 97 || n > 122) break block9;
                }
                return string.substring(0, 2);
            }
            return null;
        }
        return "";
    }

    public static void checkedDelete(File file) throws IOException {
        if (!file.delete()) {
            throw new IOException(Msg.msg("cannotDelete", file));
        }
    }

    public static void checkedRename(File file, File file2) throws IOException {
        if (!file.renameTo(file2)) {
            throw new IOException(Msg.msg("cannotRename", file, file2));
        }
    }

    public static void checkedMkdir(File file) throws IOException {
        if (!file.mkdir()) {
            throw new IOException(Msg.msg("cannotMkdir", file));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkedMkdirs(File file) throws IOException {
        Object object = mkdirsLock;
        synchronized (object) {
            if (!file.mkdirs()) {
                throw new IOException(Msg.msg("cannotMkdir", file));
            }
        }
    }

    public static File[] checkedListFiles(File file) throws IOException {
        return FileUtil.checkedListFiles(file, (FilenameFilter)null);
    }

    public static File[] checkedListFiles(File file, FilenameFilter filenameFilter) throws IOException {
        File[] fileArray = file.listFiles(filenameFilter);
        if (fileArray == null) {
            throw new IOException(Msg.msg("cannotList", file));
        }
        return fileArray;
    }

    public static File[] checkedListFiles(File file, FileFilter fileFilter) throws IOException {
        File[] fileArray = file.listFiles(fileFilter);
        if (fileArray == null) {
            throw new IOException(Msg.msg("cannotList", file));
        }
        return fileArray;
    }

    public static String[] checkedList(File file) throws IOException {
        return FileUtil.checkedList(file, null);
    }

    public static String[] checkedList(File file, FilenameFilter filenameFilter) throws IOException {
        String[] stringArray = file.list(filenameFilter);
        if (stringArray == null) {
            throw new IOException(Msg.msg("cannotList", file));
        }
        return stringArray;
    }

    public static void checkedSetLastModified(File file, long l) throws IOException {
        if (!file.setLastModified(l)) {
            throw new IOException(Msg.msg("cannotSetFileDate", file));
        }
    }

    public static void checkedCreateNewFile(File file) throws IOException {
        if (!file.createNewFile()) {
            throw new IOException(Msg.msg("cannotCreateFile", file));
        }
    }

    public static String formatFileSize(long l) {
        return FileUtil.formatFileSize(l, null);
    }

    public static String formatFileSize(long l, Locale locale) {
        DecimalFormat decimalFormat = locale == null || Locale.getDefault().equals(locale) ? fileSizeFormatDefault : (Locale.US.equals(locale) ? fileSizeFormatUS : new DecimalFormat("0.#", new DecimalFormatSymbols(locale)));
        double d = l;
        if (d > 1.073741824E9) {
            return decimalFormat.format(d / 1.073741824E9) + Msg.msg("fileSizeUnit.gigabytes");
        }
        if (d > 1048576.0) {
            return decimalFormat.format(d / 1048576.0) + Msg.msg("fileSizeUnit.megabytes");
        }
        if (d > 1024.0) {
            return decimalFormat.format(d / 1024.0) + Msg.msg("fileSizeUnit.kilobytes");
        }
        return decimalFormat.format(d) + Msg.msg("fileSizeUnit.bytes");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getTotalSpace(File file) {
        Boolean bl = fetchGetTotalSpaceMethod;
        synchronized (bl) {
            if (fetchGetTotalSpaceMethod.booleanValue()) {
                fetchGetTotalSpaceMethod = Boolean.FALSE;
                try {
                    getTotalSpaceMethod = File.class.getMethod("getTotalSpace", new Class[0]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            Long l = null;
            if (getTotalSpaceMethod != null) {
                try {
                    l = (Long)getTotalSpaceMethod.invoke((Object)file, new Object[0]);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            return l == null ? -1L : l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getUsableSpace(File file) {
        Boolean bl = fetchGetUsableSpaceMethod;
        synchronized (bl) {
            if (fetchGetUsableSpaceMethod.booleanValue()) {
                fetchGetUsableSpaceMethod = Boolean.FALSE;
                try {
                    getUsableSpaceMethod = File.class.getMethod("getUsableSpace", new Class[0]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            Long l = null;
            if (getUsableSpaceMethod != null) {
                try {
                    l = (Long)getUsableSpaceMethod.invoke((Object)file, new Object[0]);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            return l == null ? -1L : l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasExecutePermission(File file) {
        if (SystemUtil.IS_WINDOWS) {
            return false;
        }
        Boolean bl = fetchCanExecuteMethod;
        synchronized (bl) {
            if (fetchCanExecuteMethod.booleanValue()) {
                fetchCanExecuteMethod = Boolean.FALSE;
                try {
                    canExecuteMethod = File.class.getMethod("canExecute", new Class[0]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            Boolean bl2 = Boolean.FALSE;
            if (canExecuteMethod != null) {
                try {
                    bl2 = (Boolean)canExecuteMethod.invoke((Object)file, new Object[0]);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            return bl2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean setExecutePermission(File file, boolean bl) {
        if (SystemUtil.IS_WINDOWS) {
            return false;
        }
        Boolean bl2 = fetchSetExecutableMethod;
        synchronized (bl2) {
            if (fetchSetExecutableMethod.booleanValue()) {
                fetchSetExecutableMethod = Boolean.FALSE;
                try {
                    setExecutableMethod = File.class.getMethod("setExecutable", Boolean.TYPE, Boolean.TYPE);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            Boolean bl3 = Boolean.FALSE;
            if (setExecutableMethod != null) {
                try {
                    bl3 = (Boolean)setExecutableMethod.invoke((Object)file, bl ? Boolean.TRUE : Boolean.FALSE, false);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            return bl3;
        }
    }

    public static void checkedSetExecutePermission(File file, boolean bl) throws IOException {
        if (SystemUtil.IS_WINDOWS) {
            return;
        }
        boolean bl2 = FileUtil.setExecutePermission(file, bl);
        if (!bl2 && setExecutableMethod != null) {
            throw new IOException(Msg.msg("cannotSetExecutePermission", file));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isHidden(File file) {
        Boolean bl = fetchIsHiddenMethod;
        synchronized (bl) {
            if (fetchIsHiddenMethod.booleanValue()) {
                fetchIsHiddenMethod = Boolean.FALSE;
                try {
                    isHiddenMethod = File.class.getMethod("isHidden", new Class[0]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            Boolean bl2 = Boolean.FALSE;
            if (isHiddenMethod != null) {
                try {
                    bl2 = (Boolean)isHiddenMethod.invoke((Object)file, new Object[0]);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            return bl2;
        }
    }

    public static void emptyDir(File file) throws IOException {
        if (!FileUtil.doEmptyDir(file)) {
            throw new IOException(Msg.msg("cannotEmptyDir", file));
        }
    }

    public static boolean doEmptyDir(File file) {
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return false;
        }
        for (int i = 0; i < fileArray.length; ++i) {
            File file2 = fileArray[i];
            if (file2.isDirectory() && !FileUtil.doEmptyDir(file2)) {
                return false;
            }
            if (file2.delete()) continue;
            return false;
        }
        return true;
    }

    public static boolean isEmptyDir(File file) {
        if (!file.isDirectory()) {
            return false;
        }
        String[] stringArray = file.list();
        return stringArray != null && stringArray.length == 0;
    }

    public static void checkIsEmptyDir(File file) throws IOException {
        if (!FileUtil.isEmptyDir(file)) {
            throw new IOException(Msg.msg("notAnEmptyDir", file));
        }
    }

    public static void deleteFileOrDir(File file, Console console) throws IOException {
        if (file.isDirectory()) {
            FileUtil.deleteDir(file, console);
        } else {
            FileUtil.deleteFile(file, console);
        }
    }

    public static void deleteDir(File file, Console console) throws IOException {
        if (console != null) {
            console.showMessage(Msg.msg("deletingDir", file), Console.MessageType.VERBOSE);
        }
        FileUtil.deleteDir(file);
    }

    public static void deleteFile(File file, Console console) throws IOException {
        if (console != null) {
            console.showMessage(Msg.msg("deletingFile", file), Console.MessageType.VERBOSE);
        }
        FileUtil.deleteFile(file);
    }

    public static void deleteFileOrDir(File file) throws IOException {
        if (file.isDirectory()) {
            FileUtil.deleteDir(file);
        } else {
            FileUtil.deleteFile(file);
        }
    }

    public static boolean doDeleteFileOrDir(File file) {
        if (file.isDirectory() && !FileUtil.doEmptyDir(file)) {
            return false;
        }
        return file.delete();
    }

    public static void deleteDir(File file) throws IOException {
        if (!FileUtil.doEmptyDir(file) || !file.delete()) {
            throw new IOException(Msg.msg("cannotDeleteDir", file));
        }
    }

    public static void deleteFile(File file) throws IOException {
        if (!file.delete()) {
            throw new IOException(Msg.msg("cannotDeleteFile", file));
        }
    }

    public static void copyFileOrDir(File file, File file2, boolean bl, Console console) throws IOException {
        if (file.isDirectory()) {
            FileUtil.copyDir(file, file2, bl, console);
        } else {
            FileUtil.copyFile(file, file2, bl, console);
        }
    }

    public static void copyDir(File file, File file2, boolean bl, Console console) throws IOException {
        if (console != null) {
            console.showMessage(Msg.msg("copyingDir", file, file2), Console.MessageType.VERBOSE);
        }
        FileUtil.copyDir(file, file2, bl);
    }

    public static void copyFile(File file, File file2, boolean bl, Console console) throws IOException {
        if (console != null) {
            console.showMessage(Msg.msg("copyingFile", file, file2), Console.MessageType.VERBOSE);
        }
        FileUtil.copyFile(file, file2, bl);
    }

    public static void copyFileOrDir(File file, File file2, boolean bl) throws IOException {
        if (file.isDirectory()) {
            FileUtil.copyDir(file, file2, bl);
        } else {
            FileUtil.copyFile(file, file2, bl);
        }
    }

    public static void copyDir(File file, File file2, boolean bl) throws IOException {
        FileUtil.checkedMkdir(file2);
        File[] fileArray = FileUtil.checkedListFiles(file);
        for (int i = 0; i < fileArray.length; ++i) {
            File file3 = fileArray[i];
            File file4 = new File(file2, file3.getName());
            if (file3.isDirectory()) {
                FileUtil.copyDir(file3, file4, bl);
                continue;
            }
            FileUtil.copyFile(file3, file4, bl);
        }
    }

    public static void copyFile(File file, File file2, boolean bl) throws IOException {
        FileUtil.copyFile(file, file2);
        if (bl) {
            FileUtil.checkedSetLastModified(file2, file.lastModified());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File file, File file2) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            FileUtil.copyFile((InputStream)fileInputStream, file2);
        }
        finally {
            fileInputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(URL uRL, File file) throws IOException {
        InputStream inputStream = uRL.openStream();
        try {
            FileUtil.copyFile(inputStream, file);
        }
        finally {
            inputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(InputStream inputStream, File file) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        try {
            FileUtil.copyFile(inputStream, (OutputStream)fileOutputStream);
        }
        finally {
            fileOutputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File file, OutputStream outputStream) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            FileUtil.copyFile((InputStream)fileInputStream, outputStream);
        }
        finally {
            fileInputStream.close();
        }
    }

    public static final void copyFile(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        byte[] byArray = new byte[65535];
        while ((n = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n);
        }
        outputStream.flush();
    }

    public static String loadString(File file) throws IOException {
        return FileUtil.loadString(file, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String loadString(File file, String string) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        String string2 = null;
        try {
            string2 = FileUtil.loadString(fileInputStream, string);
        }
        finally {
            ((InputStream)fileInputStream).close();
        }
        return string2;
    }

    public static String loadString(InputStream inputStream, String string) throws IOException {
        int n;
        InputStreamReader inputStreamReader = string == null ? new InputStreamReader(inputStream) : new InputStreamReader(inputStream, string);
        StringBuilder stringBuilder = new StringBuilder();
        char[] cArray = new char[65536];
        while ((n = inputStreamReader.read(cArray, 0, cArray.length)) != -1) {
            if (n <= 0) continue;
            stringBuilder.append(cArray, 0, n);
        }
        return stringBuilder.toString();
    }

    public static void saveString(String string, File file) throws IOException {
        FileUtil.saveString(string, file, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveString(String string, File file, String string2) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        try {
            FileUtil.saveString(string, fileOutputStream, string2);
        }
        finally {
            ((OutputStream)fileOutputStream).close();
        }
    }

    public static void saveString(String string, OutputStream outputStream, String string2) throws IOException {
        OutputStreamWriter outputStreamWriter = string2 == null ? new OutputStreamWriter(outputStream) : new OutputStreamWriter(outputStream, string2);
        outputStreamWriter.write(string, 0, string.length());
        outputStreamWriter.flush();
    }

    public static final boolean isGzipped(byte[] byArray) {
        if (byArray.length <= 2) {
            return false;
        }
        return (byArray[0] & 0xFF) == 31 && (byArray[1] & 0xFF) == 139;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void copyBytes(InputStream inputStream, OutputStream outputStream) throws IOException {
        try {
            try {
                FileUtil.copyFile(inputStream, outputStream);
            }
            finally {
                outputStream.close();
            }
        }
        finally {
            inputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] loadBytes(File file) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        byte[] byArray = null;
        try {
            byArray = FileUtil.loadBytes(fileInputStream);
        }
        finally {
            ((InputStream)fileInputStream).close();
        }
        return byArray;
    }

    public static byte[] loadBytes(InputStream inputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        FileUtil.copyFile(inputStream, (OutputStream)byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveBytes(byte[] byArray, File file) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        try {
            ((OutputStream)fileOutputStream).write(byArray, 0, byArray.length);
            fileOutputStream.flush();
        }
        finally {
            ((OutputStream)fileOutputStream).close();
        }
    }
}

