/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.util;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.StringTokenizer;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;

public final class JarUtil {
    private static final URL[] NO_URLS = new URL[0];
    private static final String[] NO_STRINGS = new String[0];

    private JarUtil() {
    }

    public static URL[] getClassPath(URL uRL) throws IOException {
        String string = JarUtil.getClassPathAttribute(uRL);
        if (string == null) {
            return NO_URLS;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        int n = stringTokenizer.countTokens();
        URL[] uRLArray = new URL[n];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            try {
                uRLArray[n2++] = new URL(uRL, stringTokenizer.nextToken());
                continue;
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        if (n2 != uRLArray.length) {
            URL[] uRLArray2 = new URL[n2];
            System.arraycopy(uRLArray, 0, uRLArray2, 0, n2);
            uRLArray = uRLArray2;
        }
        return uRLArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getClassPathAttribute(URL uRL) throws IOException {
        Manifest manifest = null;
        JarInputStream jarInputStream = new JarInputStream(uRL.openStream(), false);
        try {
            manifest = jarInputStream.getManifest();
        }
        finally {
            jarInputStream.close();
        }
        if (manifest == null) {
            return null;
        }
        return manifest.getMainAttributes().getValue("Class-Path");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] getServiceProviders(URL uRL) throws IOException {
        JarInputStream jarInputStream = new JarInputStream(uRL.openStream(), false);
        String[] stringArray = NO_STRINGS;
        int n = 0;
        try {
            ZipEntry zipEntry;
            byte[] byArray = new byte[8192];
            while ((zipEntry = jarInputStream.getNextEntry()) != null) {
                String string = zipEntry.getName();
                if (string.charAt(0) != 'M' || !string.startsWith("META-INF/services/") || zipEntry.isDirectory()) continue;
                int n2 = jarInputStream.read(byArray, 0, byArray.length);
                String string2 = new String(byArray, 0, n2, "UTF8");
                String string3 = null;
                int n3 = string2.indexOf(35);
                if (n3 >= 0) {
                    int n4;
                    string3 = string2.substring(n3 + 1).trim();
                    int n5 = string3.length();
                    for (n4 = 0; n4 < n5 && string3.charAt(n4) == '#'; ++n4) {
                    }
                    while (n4 < n5 && string3.charAt(n4) == ' ') {
                        ++n4;
                    }
                    if (n4 > 0) {
                        string3 = (n5 -= n4) > 0 ? string3.substring(n4) : "";
                    }
                    if (n5 == 0) {
                        string3 = null;
                    }
                    string2 = string2.substring(0, n3);
                }
                String[] stringArray2 = new String[n + 3];
                if (n > 0) {
                    System.arraycopy(stringArray, 0, stringArray2, 0, n);
                }
                stringArray = stringArray2;
                stringArray[n++] = string.substring(18);
                stringArray[n++] = string2.trim();
                stringArray[n++] = string3;
            }
        }
        finally {
            jarInputStream.close();
        }
        return stringArray;
    }
}

