/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.util;

import com.xmlmind.util.FileUtil;
import com.xmlmind.util.StringUtil;
import com.xmlmind.util.URLUtil;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.print.Paper;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;

public class Preferences {
    public final Map map;
    private static Preferences appPreferences;

    public Preferences() {
        this(new MapImpl(null, null, null));
    }

    public Preferences(File file, String string) {
        this(new MapImpl(null, file, string));
    }

    public Preferences(Map map) {
        this.map = map;
    }

    public synchronized void putString(String string, String string2) {
        this.map.putPreference(string, string2);
    }

    public synchronized String getString(String string, String string2) {
        String string3 = this.map.getPreference(string);
        if (string3 == null) {
            return string2;
        }
        return string3;
    }

    public synchronized void putBoolean(String string, boolean bl) {
        this.map.putPreference(string, bl ? "true" : "false");
    }

    public synchronized boolean getBoolean(String string, boolean bl) {
        String string2 = this.map.getPreference(string);
        if (string2 == null) {
            return bl;
        }
        if ("true".equals(string2)) {
            return true;
        }
        if ("false".equals(string2)) {
            return false;
        }
        return bl;
    }

    public synchronized void putInt(String string, int n) {
        this.map.putPreference(string, Integer.toString(n));
    }

    public synchronized int getInt(String string, int n, int n2, int n3) {
        int n4 = this.getInt(string, n3);
        if (n4 < n || n4 > n2) {
            return n3;
        }
        return n4;
    }

    public synchronized int getInt(String string, int n) {
        String string2 = this.map.getPreference(string);
        if (string2 == null) {
            return n;
        }
        try {
            return Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return n;
        }
    }

    public synchronized void putDouble(String string, double d) {
        this.map.putPreference(string, Double.toString(d));
    }

    public synchronized double getDouble(String string, double d, double d2, double d3) {
        double d4 = this.getDouble(string, d3);
        if (d4 < d || d4 > d2) {
            return d3;
        }
        return d4;
    }

    public synchronized double getDouble(String string, double d) {
        String string2 = this.map.getPreference(string);
        if (string2 == null) {
            return d;
        }
        try {
            return Double.parseDouble(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return d;
        }
    }

    public synchronized void putStrings(String string, String[] stringArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            if (string2.indexOf(38) >= 0) {
                string2 = StringUtil.replaceAll(string2, "&", "&amp;");
            }
            if (string2.indexOf(10) >= 0) {
                string2 = StringUtil.replaceAll(string2, "\n", "&#xA;");
            }
            if (i > 0) {
                stringBuilder.append('\n');
            }
            stringBuilder.append(string2);
        }
        this.map.putPreference(string, stringBuilder.toString());
    }

    public synchronized String[] getStrings(String string, String[] stringArray) {
        String string2 = this.map.getPreference(string);
        if (string2 == null) {
            return stringArray;
        }
        if (string2.length() == 0) {
            return new String[0];
        }
        String[] stringArray2 = StringUtil.split(string2, '\n');
        for (int i = 0; i < stringArray2.length; ++i) {
            String string3 = stringArray2[i];
            if (string3.indexOf("&#xA;") >= 0) {
                string3 = StringUtil.replaceAll(string3, "&#xA;", "\n");
            }
            if (string3.indexOf("&amp;") >= 0) {
                string3 = StringUtil.replaceAll(string3, "&amp;", "&");
            }
            stringArray2[i] = string3;
        }
        return stringArray2;
    }

    public synchronized void putInts(String string, int[] nArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < nArray.length; ++i) {
            if (i > 0) {
                stringBuilder.append(' ');
            }
            stringBuilder.append(nArray[i]);
        }
        this.map.putPreference(string, stringBuilder.toString());
    }

    public synchronized int[] getInts(String string, int[] nArray) {
        String string2 = this.map.getPreference(string);
        if (string2 == null) {
            return nArray;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2);
        int[] nArray2 = new int[stringTokenizer.countTokens()];
        for (int i = 0; i < nArray2.length; ++i) {
            try {
                nArray2[i] = Integer.parseInt(stringTokenizer.nextToken());
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                return nArray;
            }
        }
        return nArray2;
    }

    public synchronized void putDoubles(String string, double[] dArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < dArray.length; ++i) {
            if (i > 0) {
                stringBuilder.append(' ');
            }
            stringBuilder.append(dArray[i]);
        }
        this.map.putPreference(string, stringBuilder.toString());
    }

    public synchronized double[] getDoubles(String string, double[] dArray) {
        String string2 = this.map.getPreference(string);
        if (string2 == null) {
            return dArray;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2);
        double[] dArray2 = new double[stringTokenizer.countTokens()];
        for (int i = 0; i < dArray2.length; ++i) {
            try {
                dArray2[i] = Double.parseDouble(stringTokenizer.nextToken());
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                return dArray;
            }
        }
        return dArray2;
    }

    public synchronized void putURL(String string, URL uRL) {
        this.putString(string, uRL.toExternalForm());
    }

    public synchronized URL getURL(String string, URL uRL) {
        String string2 = this.getString(string, null);
        if (string2 == null) {
            return uRL;
        }
        URL uRL2 = null;
        try {
            uRL2 = new URL(string2);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return uRL2 == null ? uRL : uRL2;
    }

    public synchronized void putURLs(String string, URL[] uRLArray) {
        String[] stringArray = new String[uRLArray.length];
        for (int i = 0; i < uRLArray.length; ++i) {
            stringArray[i] = uRLArray[i].toExternalForm();
        }
        this.putStrings(string, stringArray);
    }

    public synchronized URL[] getURLs(String string, URL[] uRLArray) {
        String[] stringArray = this.getStrings(string, null);
        if (stringArray == null) {
            return uRLArray;
        }
        URL[] uRLArray2 = new URL[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            URL uRL = null;
            try {
                uRL = new URL(stringArray[i]);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            if (uRL == null) {
                return uRLArray;
            }
            uRLArray2[i] = uRL;
        }
        return uRLArray2;
    }

    public synchronized void putURLEntry(String string, URL uRL, URL uRL2, int n) {
        int n2;
        String[] stringArray = this.getStrings(string, null);
        int n3 = n2 = stringArray == null ? 0 : stringArray.length;
        if (n < 1) {
            n = 1;
        }
        int n4 = 2 * n;
        String[] stringArray2 = new String[Math.max(n4, n2) + 2];
        int n5 = 0;
        if (stringArray != null) {
            int n6 = 2 * (n2 / 2);
            for (int i = 0; i < n6; i += 2) {
                try {
                    URL uRL3 = new URL(stringArray[i]);
                    if (uRL3.equals(uRL)) continue;
                    stringArray2[n5] = stringArray[i];
                    stringArray2[n5 + 1] = stringArray[i + 1];
                    n5 += 2;
                    continue;
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
        }
        if (uRL2 != null) {
            stringArray2[n5] = uRL.toExternalForm();
            stringArray2[n5 + 1] = uRL2.toExternalForm();
            n5 += 2;
        }
        if (n5 == 0) {
            this.remove(string);
        } else {
            if (n5 != stringArray2.length) {
                String[] stringArray3 = new String[n5];
                System.arraycopy(stringArray2, 0, stringArray3, 0, n5);
                stringArray2 = stringArray3;
            }
            if (n5 > n4) {
                String[] stringArray4 = new String[n4];
                System.arraycopy(stringArray2, n5 - n4, stringArray4, 0, n4);
                stringArray2 = stringArray4;
            }
            this.putStrings(string, stringArray2);
        }
    }

    public synchronized URL getURLEntry(String string, URL uRL, URL uRL2) {
        String[] stringArray = this.getStrings(string, null);
        if (stringArray == null) {
            return uRL2;
        }
        for (int i = 0; i < stringArray.length; i += 2) {
            try {
                URL uRL3 = new URL(stringArray[i]);
                if (!uRL3.equals(uRL)) continue;
                return new URL(stringArray[i + 1]);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return uRL2;
    }

    public synchronized void putColor(String string, Color color) {
        this.putInts(string, new int[]{color.getRed(), color.getGreen(), color.getBlue()});
    }

    public synchronized Color getColor(String string, Color color) {
        int[] nArray = this.getInts(string, new int[]{color.getRed(), color.getGreen(), color.getBlue()});
        if (nArray.length != 3 || nArray[0] < 0 || nArray[0] > 255 || nArray[1] < 0 || nArray[1] > 255 || nArray[2] < 0 || nArray[2] > 255) {
            return color;
        }
        return new Color(nArray[0], nArray[1], nArray[2]);
    }

    public synchronized void putRectangle(String string, Rectangle rectangle) {
        this.putInts(string, new int[]{rectangle.x, rectangle.y, rectangle.width, rectangle.height});
    }

    public synchronized Rectangle getRectangle(String string, Rectangle rectangle) {
        int[] nArray = this.getInts(string, new int[]{rectangle.x, rectangle.y, rectangle.width, rectangle.height});
        if (nArray.length != 4 || nArray[2] < 0 || nArray[3] < 0) {
            return rectangle;
        }
        return new Rectangle(nArray[0], nArray[1], nArray[2], nArray[3]);
    }

    public synchronized void putPaper(String string, Paper paper) {
        this.putDoubles(string, new double[]{paper.getWidth(), paper.getHeight(), paper.getImageableX(), paper.getImageableY(), paper.getImageableWidth(), paper.getImageableHeight()});
    }

    public synchronized Paper getPaper(String string, Paper paper) {
        double[] dArray = this.getDoubles(string, null);
        if (dArray == null) {
            return paper;
        }
        Paper paper2 = Preferences.newPaper(dArray[0], dArray[1], dArray[2], dArray[3], dArray[4], dArray[5]);
        if (paper2 == null) {
            return paper;
        }
        return paper2;
    }

    public static final Paper newPaper(double d, double d2, double d3, double d4, double d5, double d6) {
        if (d < 0.0 || d2 < 0.0 || d3 < 0.0 || d3 >= d || d4 < 0.0 || d4 >= d2 || d5 <= 0.0 || d5 > d - d3 || d6 <= 0.0 || d6 > d2 - d4) {
            return null;
        }
        Paper paper = new Paper();
        paper.setSize(d, d2);
        paper.setImageableArea(d3, d4, d5, d6);
        return paper;
    }

    public synchronized void remove(String string) {
        this.map.removePreference(string);
    }

    public synchronized void removeAll() {
        this.map.removeAllPreferences();
    }

    public synchronized String[] getAll() {
        return this.map.getAllPreferences();
    }

    public synchronized void putAll(Preferences preferences) {
        String[] stringArray = preferences.map.getAllPreferences();
        for (int i = 0; i < stringArray.length; i += 2) {
            this.map.putPreference(stringArray[i], stringArray[i + 1]);
        }
    }

    public synchronized void putAll(Properties properties) {
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            this.map.putPreference((String)entry.getKey(), (String)entry.getValue());
        }
    }

    public synchronized void putAll(File file) throws IOException {
        this.putAll(FileUtil.fileToURL(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void putAll(URL uRL) throws IOException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(URLUtil.openStreamNoCache(uRL));
        Properties properties = new Properties();
        try {
            properties.load(bufferedInputStream);
        }
        finally {
            bufferedInputStream.close();
        }
        this.putAll(properties);
    }

    public synchronized boolean save() {
        return this.map.save();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void setPreferences(Preferences preferences) {
        Class<Preferences> clazz = Preferences.class;
        synchronized (Preferences.class) {
            appPreferences = preferences;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Preferences getPreferences() {
        Class<Preferences> clazz = Preferences.class;
        synchronized (Preferences.class) {
            if (appPreferences == null) {
                appPreferences = new Preferences();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return appPreferences;
        }
    }

    public static final class MapImpl
    implements Map {
        private File file;
        private String header;
        private Properties properties;

        public MapImpl(Properties properties) {
            this(properties, null, null);
        }

        public MapImpl(File file, String string) {
            this(null, file, string);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public MapImpl(Properties properties, File file, String string) {
            if (properties == null) {
                properties = new Properties();
                if (file != null) {
                    try {
                        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
                        try {
                            properties.load(bufferedInputStream);
                        }
                        finally {
                            bufferedInputStream.close();
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
            this.file = file;
            this.header = string;
            this.properties = properties;
        }

        public File getFile() {
            return this.file;
        }

        public String getHeader() {
            return this.header;
        }

        public String getPreference(String string) {
            return (String)this.properties.get(string);
        }

        public void putPreference(String string, String string2) {
            this.properties.put(string, string2);
        }

        public void removePreference(String string) {
            this.properties.remove(string);
        }

        public void removeAllPreferences() {
            this.properties.clear();
        }

        public String[] getAllPreferences() {
            String[] stringArray = new String[this.properties.size() * 2];
            int n = 0;
            for (Map.Entry<Object, Object> entry : this.properties.entrySet()) {
                stringArray[n] = (String)entry.getKey();
                stringArray[n + 1] = (String)entry.getValue();
                n += 2;
            }
            return stringArray;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean save() {
            if (this.file == null) {
                return false;
            }
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(this.file);
                try {
                    this.properties.store(fileOutputStream, this.header == null ? "" : this.header);
                    fileOutputStream.flush();
                }
                finally {
                    fileOutputStream.close();
                }
            }
            catch (IOException iOException) {
                return false;
            }
            return true;
        }
    }

    public static interface Map {
        public String getPreference(String var1);

        public void putPreference(String var1, String var2);

        public void removePreference(String var1);

        public void removeAllPreferences();

        public String[] getAllPreferences();

        public boolean save();
    }
}

