/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.apps.studio;

import com.qizx.apps.studio.gui.DialogBase;
import com.qizx.apps.studio.gui.GUI;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.net.URL;
import java.util.Locale;
import javax.help.BadIDException;
import javax.help.CSH;
import javax.help.HelpBroker;
import javax.help.HelpSet;
import javax.help.HelpSetException;
import javax.swing.AbstractButton;
import javax.swing.JButton;

public class Help {
    private static String language = null;
    private static HelpBroker helpBroker = null;
    private static boolean initialized;
    private static CSH.DisplayHelpAfterTracking delegate;
    private static String helpId;

    public static void initialize() {
        language = Locale.getDefault().getLanguage();
        URL uRL = Help.class.getResource("/qizxstudio_help_" + language + "/jhelpset.hs");
        if (uRL == null) {
            uRL = Help.class.getResource("/qizxstudio_help/jhelpset.hs");
        }
        if (uRL == null) {
            GUI.error("Help files not found");
            return;
        }
        try {
            HelpSet helpSet = new HelpSet(null, uRL);
            helpBroker = helpSet.createHelpBroker();
            helpBroker.setSize(new Dimension(800, 800));
        }
        catch (HelpSetException helpSetException) {
            // empty catch block
        }
    }

    public static void addHelpSet(String string) {
        if (helpBroker == null) {
            return;
        }
        URL uRL = Help.class.getResource("/" + string + "_" + language + "/jhelpset.hs");
        if (uRL == null) {
            uRL = Help.class.getResource("/" + string + "/jhelpset.hs");
        }
        if (uRL == null) {
            return;
        }
        try {
            HelpSet helpSet = new HelpSet(null, uRL);
            helpBroker.getHelpSet().add(helpSet);
        }
        catch (HelpSetException helpSetException) {
            // empty catch block
        }
    }

    public static HelpBroker getHelpBroker() {
        return helpBroker;
    }

    public static void setHelpId(Component component, String string) {
        if (helpBroker != null) {
            helpBroker.enableHelp(component, string, null);
        }
    }

    public static void setHelpButton(AbstractButton abstractButton, String string) {
        if (helpBroker == null) {
            abstractButton.setEnabled(false);
        } else {
            helpBroker.enableHelpOnButton(abstractButton, string, null);
        }
    }

    public static void setDialogHelp(DialogBase dialogBase, String string) {
        JButton jButton = dialogBase.getHelpButton();
        Help.setHelpButton(jButton, string);
    }

    public static void setContextualHelpButton(AbstractButton abstractButton) {
        if (helpBroker == null) {
            abstractButton.setEnabled(false);
        } else {
            abstractButton.addActionListener(new CSH.DisplayHelpAfterTracking(helpBroker));
        }
    }

    public static void showHelp() {
        HelpBroker helpBroker = Help.getHelpBroker();
        if (helpBroker != null) {
            helpBroker.setDisplayed(true);
            if (helpId != null) {
                try {
                    helpBroker.setCurrentID(helpId);
                }
                catch (BadIDException badIDException) {
                    // empty catch block
                }
            }
        }
    }

    public static void contextualHelp(Object object) {
        Object object2;
        if (!initialized) {
            initialized = true;
            object2 = Help.getHelpBroker();
            if (object2 != null) {
                delegate = new CSH.DisplayHelpAfterTracking((HelpBroker)object2);
            }
        }
        if (delegate != null) {
            object2 = new ActionEvent(object, 1001, null);
            try {
                delegate.actionPerformed((ActionEvent)object2);
            }
            catch (BadIDException badIDException) {
                Help.showHelp();
            }
        }
    }

    static {
        helpId = "startPoint";
    }
}

