/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.apps.studio;

import com.qizx.api.Node;
import com.qizx.apps.studio.Help;
import com.qizx.apps.studio.gui.AppFrame;
import com.qizx.apps.studio.gui.BasicAction;
import com.qizx.apps.studio.gui.GUI;
import com.qizx.apps.studio.gui.MenuButton;
import com.qizx.apps.studio.gui.TreePort;
import com.qizx.apps.studio.gui.XdmNode;
import com.qizx.apps.studio.gui.XmlNode;
import java.awt.Color;
import java.awt.event.ActionEvent;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;

public class XQDataView
extends TreePort {
    protected AppFrame app;
    protected Node root;
    protected boolean useMarkup = true;
    protected JRadioButtonMenuItem markupButton;

    public XQDataView(AppFrame appFrame, String string, boolean bl) {
        super(string, bl, null);
        this.app = appFrame;
        this.changeFont(1, false);
        XQDataView.setTreeColors(this.getRenderer());
        this.addTool(this.displayModeMenu(), -1);
    }

    public static void setTreeColors(TreePort.Renderer renderer) {
        renderer.setForeground(new Color(0x606060));
        renderer.setColor(1, new Color(7360672));
        renderer.setColor(2, new Color(37024));
        renderer.setColor(3, new Color(36976));
        renderer.setColor(4, new Color(9479584));
        renderer.setColor(5, new Color(15364894));
        renderer.setColor(0, new Color(0x505050));
    }

    public Node getRootNode() {
        return this.root;
    }

    public void setRootNode(Node node) {
        this.root = node;
        if (node == null) {
            this.changeRoot(null);
        } else if (this.useMarkup) {
            this.changeRoot(new XmlNode(node, this));
        } else {
            this.changeRoot(new XdmNode(node));
        }
        this.expandAllVisible(40);
        this.getTree().scrollRowToVisible(0);
    }

    protected JButton addToolbarButton(BasicAction basicAction, String string, String string2) {
        JButton jButton = new JButton(basicAction);
        jButton.setToolTipText(string);
        Help.setHelpId(jButton, string2);
        GUI.iconic(jButton);
        this.addTool(jButton, 0);
        return jButton;
    }

    MenuButton displayModeMenu() {
        MenuButton menuButton = new MenuButton("View");
        menuButton.setToolTipText("Display mode");
        GUI.iconic(menuButton);
        JPopupMenu jPopupMenu = menuButton.getPopupMenu();
        ButtonGroup buttonGroup = new ButtonGroup();
        this.markupButton = new JRadioButtonMenuItem(new BasicAction("Markup", "cmdMarkupView", this));
        JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(new BasicAction("Data Model", "cmdDMView", this));
        jPopupMenu.add(this.markupButton);
        jPopupMenu.add(jRadioButtonMenuItem);
        buttonGroup.add(this.markupButton);
        buttonGroup.add(jRadioButtonMenuItem);
        this.markupButton.setSelected(true);
        return menuButton;
    }

    public void cmdMarkupView(ActionEvent actionEvent, BasicAction basicAction) {
        this.useMarkup = true;
        this.setRootNode(this.root);
    }

    public void cmdDMView(ActionEvent actionEvent, BasicAction basicAction) {
        this.useMarkup = false;
        this.setRootNode(this.root);
    }
}

