/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.apps.studio.gui;

import com.qizx.apps.studio.gui.BasicAction;
import com.qizx.apps.studio.gui.GUI;
import com.qizx.apps.studio.gui.GridBagger;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;

public abstract class DialogBase
extends JDialog {
    protected static final int VGAP = 8;
    protected static final int HGAP = 8;
    private static Insets BUTTON_INSETS = new Insets(1, 1, 0, 1);
    private Window window;
    private boolean firstShow;
    private boolean cancelled;
    protected JPanel form;
    private JLabel hintArea;
    private JLabel messageArea;
    private JPanel mainButtons;
    private JButton okButton;
    private JButton cancelButton;
    private JButton helpButton;
    private BasicAction cancelAction;
    private ImageIcon hintIcon = GUI.getIcon(DialogBase.class, "hint.png");
    private ImageIcon errorIcon = GUI.getIcon(DialogBase.class, "error.png");
    private ImageIcon helpIcon = GUI.getIcon(DialogBase.class, "help.png");
    private boolean unpacked;

    public DialogBase() {
        this((Frame)null, "<title?>");
    }

    public DialogBase(JFrame jFrame) {
        this((Frame)jFrame, "<no title>");
    }

    public DialogBase(Frame frame, String string) {
        super(frame);
        this.init(frame, string);
    }

    public DialogBase(Dialog dialog, String string) {
        super(dialog);
        this.init(dialog, string);
    }

    private void init(Window window, String string) {
        this.window = window;
        this.firstShow = true;
        this.setTitle(string);
        this.create();
        this.setModal(true);
        this.unpacked = true;
        this.rootPane.registerKeyboardAction(this.cancelAction, KeyStroke.getKeyStroke(27, 0), 2);
    }

    private void create() {
        this.hintArea = new JLabel();
        this.getContentPane().add((Component)this.hintArea, "North");
        this.hintArea.setVerticalAlignment(1);
        this.hintArea.setForeground(new Color(0x606080));
        this.hintArea.setBorder(BorderFactory.createEmptyBorder(8, 16, 8, 16));
        this.hintArea.setIconTextGap(16);
        JPanel jPanel = new JPanel();
        this.getContentPane().add((Component)jPanel, "Center");
        GridBagger gridBagger = new GridBagger(jPanel);
        gridBagger.setInsets(8, 8);
        this.form = new JPanel();
        gridBagger.add(this.form, gridBagger.prop("fill"));
        gridBagger.newRow();
        this.messageArea = new JLabel();
        gridBagger.add(this.messageArea, gridBagger.prop("xfill"));
        JPanel jPanel2 = new JPanel();
        this.getContentPane().add((Component)jPanel2, "South");
        GridBagger gridBagger2 = new GridBagger(jPanel2);
        gridBagger2.newRow();
        gridBagger2.add(new JPanel(), gridBagger2.prop("xfill"));
        this.mainButtons = new JPanel(new FlowLayout(1, 8, 8));
        gridBagger2.add(this.mainButtons);
        this.helpButton = new JButton(new BasicAction(null, this.helpIcon, "cmdHelp", this));
        GUI.iconic(this.helpButton);
        this.helpButton.setToolTipText("Help");
        this.helpButton.setContentAreaFilled(false);
        this.addButton(this.helpButton, 0);
        this.mainButtons.add(Box.createHorizontalGlue());
        this.okButton = new JButton(new BasicAction("OK", null, "cmdOK", this));
        this.getRootPane().setDefaultButton(this.okButton);
        this.addButton(this.okButton, -1);
        this.cancelAction = new BasicAction("Cancel", null, "cmdCancel", this);
        this.cancelButton = new JButton(this.cancelAction);
        this.addButton(this.cancelButton, -1);
    }

    public void addButton(AbstractButton abstractButton, int n) {
        this.mainButtons.add((Component)abstractButton, n);
    }

    public void removeButton(AbstractButton abstractButton) {
        this.mainButtons.remove(abstractButton);
    }

    public JComponent getForm() {
        return this.form;
    }

    public void showUp() {
        if (this.unpacked) {
            this.pack();
            this.unpacked = false;
        }
        if (this.firstShow && this.window != null) {
            this.centerIn(this.window);
            this.firstShow = false;
        }
        this.toFront();
        this.setVisible(true);
    }

    public void showUp(String string) {
        this.setTitle(string);
        this.showUp();
    }

    protected void vanish() {
        this.setVisible(false);
        this.dispose();
    }

    public void centerIn(Window window) {
        DialogBase.setRelativeLocation(this, window);
    }

    public JButton getOkButton() {
        return this.okButton;
    }

    public JButton getCancelButton() {
        return this.cancelButton;
    }

    public JButton getHelpButton() {
        return this.helpButton;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public void setCancelled(boolean bl) {
        this.cancelled = bl;
    }

    public void haveOnlyCloseButton() {
        this.removeButton(this.getOkButton());
        this.getCancelButton().setText("Close");
    }

    public void cmdOK(ActionEvent actionEvent, BasicAction basicAction) {
        this.cancelled = false;
        this.vanish();
    }

    public void cmdCancel(ActionEvent actionEvent, BasicAction basicAction) {
        this.cancelled = true;
        this.vanish();
    }

    protected void processWindowEvent(WindowEvent windowEvent) {
        if (windowEvent.getID() == 201) {
            this.cmdCancel(null, null);
        }
    }

    public void cmdHelp(ActionEvent actionEvent, BasicAction basicAction) {
    }

    public void setHint(String string, boolean bl) {
        this.hintArea.setText(string);
        this.hintArea.setIcon(bl && string != null ? this.hintIcon : null);
    }

    public void setMessage(String string) {
        this.messageArea.setText(string);
        this.messageArea.setIcon(null);
    }

    public static Window getToplevelContainer(Component component) {
        Container container;
        if (component == null) {
            return null;
        }
        Container container2 = component.getParent();
        while (container2 != null && !(container2 instanceof Window) && (container = container2.getParent()) != null) {
            container2 = container;
        }
        return (Window)container2;
    }

    public static void setRelativeLocation(Window window, Window window2) {
        Dimension dimension = window.getSize();
        Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
        Rectangle rectangle = window2 != null ? window2.getBounds() : new Rectangle(0, 0, dimension2.width, dimension2.height);
        double d = rectangle.getCenterX();
        double d2 = rectangle.getCenterY();
        if ((d -= (double)(dimension.width / 2)) < 0.0) {
            d = 0.0;
        }
        if (d + (double)dimension.width > (double)dimension2.width) {
            d = dimension2.width - dimension.width;
        }
        if ((d2 -= (double)(dimension.height / 2)) < 0.0) {
            d2 = 0.0;
        }
        if (d2 + (double)dimension.height > (double)dimension2.height) {
            d2 = dimension2.height - dimension.height;
        }
        window.setLocation((int)d, (int)d2);
    }
}

