/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.apps.studio.gui;

import com.qizx.apps.studio.gui.BasicAction;
import com.qizx.apps.studio.gui.GUI;
import com.qizx.apps.studio.gui.GridBagger;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.help.event.EventListenerList;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class FileSelector
extends JPanel {
    private boolean plainFile;
    private JTextField pathField;
    private JButton browse;
    private JFileChooser fc;
    private EventListenerList listOfActionListeners = new EventListenerList();

    public FileSelector(int n, boolean bl, boolean bl2) {
        this.plainFile = bl;
        GridBagger gridBagger = new GridBagger(this);
        this.pathField = new JTextField(n);
        gridBagger.add(this.pathField, gridBagger.prop("xfill"));
        String string = GUI.loc("Browse...");
        this.browse = new JButton(new BasicAction(string, "cmdBrowse", this));
        gridBagger.add(this.browse, gridBagger.leftMargin(8));
        GUI.betterLookButton(this.browse);
    }

    public void setEnabled(boolean bl) {
        this.pathField.setEnabled(bl);
        this.browse.setEnabled(bl);
    }

    public String getPath() {
        String string = this.pathField.getText().trim();
        return string.length() > 0 ? string : null;
    }

    public void setPath(String string) {
        if (string == null) {
            return;
        }
        this.getFileChooser();
        this.fc.setSelectedFile(new File(this.fc.getSelectedFile(), string));
        this.pathField.setText(string);
    }

    public void setSuggestedName(String string) {
        this.getFileChooser();
        this.fc.setSelectedFile(new File(this.fc.getCurrentDirectory(), string));
        this.pathField.setText(this.fc.getSelectedFile().getPath());
    }

    public void setSuggestedFile(String string) {
        this.getFileChooser();
        this.fc.setSelectedFile(new File(string));
        this.pathField.setText(string);
    }

    public void cmdBrowse(ActionEvent actionEvent, BasicAction basicAction) {
        this.getFileChooser();
        this.fc.setSelectedFile(new File(this.pathField.getText()));
        if (this.fc.showOpenDialog(this.getParent()) == 0) {
            this.pathField.setText(this.fc.getSelectedFile().getPath());
        }
    }

    public JFileChooser getFileChooser() {
        if (this.fc == null) {
            this.fc = new JFileChooser(new File("."));
            this.fc.setFileSelectionMode(this.plainFile ? 0 : 1);
        }
        return this.fc;
    }

    public JTextField getPathField() {
        return this.pathField;
    }

    public void addActionListener(ActionListener actionListener) {
        this.listOfActionListeners.add(ActionListener.class, actionListener);
    }
}

