/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.apps.studio.gui;

import com.qizx.apps.studio.gui.BasicAction;
import com.qizx.apps.studio.gui.HistoryModel;
import com.qizx.apps.studio.gui.MenuButton;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class HistoryMenu
extends MenuButton
implements ListDataListener {
    private HistoryModel model;
    private int maxWidth = 25;
    private BasicAction selectAction = new BasicAction("", "cmdSelect", this);

    public HistoryMenu(String string, HistoryModel historyModel) {
        super(string);
        this.model = historyModel;
        historyModel.addListDataListener(this);
        this.rebuild();
    }

    protected void selected(Object object) {
    }

    public void rebuild() {
        JPopupMenu jPopupMenu = this.getPopupMenu();
        jPopupMenu.removeAll();
        int n = Math.min(this.model.getSize(), 40);
        for (int i = 0; i < n; ++i) {
            Object object = this.model.getElementAt(i);
            jPopupMenu.add(new Item(object));
        }
        jPopupMenu.validate();
    }

    public void cmdSelect(ActionEvent actionEvent, BasicAction basicAction) {
        Item item = (Item)actionEvent.getSource();
        this.selected(item.item);
    }

    public void contentsChanged(ListDataEvent listDataEvent) {
        this.rebuild();
    }

    public void intervalAdded(ListDataEvent listDataEvent) {
        this.rebuild();
    }

    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.rebuild();
    }

    class Item
    extends JMenuItem {
        Object item;

        Item(Object object) {
            String string;
            this.item = object;
            String string2 = string = object.toString();
            if (string2.length() > HistoryMenu.this.maxWidth) {
                string2 = string2.substring(0, HistoryMenu.this.maxWidth) + "...";
            }
            this.setText(string2);
            if (string2 != string) {
                this.setToolTipText("<html><pre>" + string);
            }
            this.addActionListener(HistoryMenu.this.selectAction);
        }

        public Point getToolTipLocation(MouseEvent mouseEvent) {
            return new Point(0, 25);
        }
    }
}

