/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.apps.studio.gui;

import com.qizx.apps.studio.gui.BasicAction;
import com.qizx.apps.studio.gui.GUI;
import com.qizx.apps.studio.gui.ToolView;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JPopupMenu;
import javax.swing.JTextPane;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Element;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;
import javax.swing.text.View;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;

public class TextPort
extends ToolView
implements CaretListener,
UndoableEditListener {
    private static final String LINK_ATTR = "#link#";
    private static final int MIN_CHAR_WIDTH = 7;
    protected JTextPane text;
    protected StyledDocument doc;
    protected StyleContext styles = new StyleContext();
    protected UndoManager undoer;
    protected BasicAction undoAction;
    protected BasicAction redoAction;
    protected JPopupMenu popup;
    private boolean recordUndoEdits;
    private int columns;

    public TextPort(String string) {
        this(string, -1);
    }

    public TextPort(String string, int n) {
        super(string, null);
        this.doc = new DefaultStyledDocument();
        this.columns = n;
        this.text = new JTextPane(this.doc){

            public boolean getScrollableTracksViewportWidth() {
                return TextPort.this.columns <= 0;
            }

            public Dimension getPreferredSize() {
                int n = TextPort.this.columns;
                if (n <= 0) {
                    return super.getPreferredSize();
                }
                View view = this.getUI().getRootView(this);
                float f = Math.max((float)(n * 7), view.getPreferredSpan(0));
                float f2 = view.getPreferredSpan(1);
                return new Dimension((int)Math.ceil(f + 14.0f), (int)Math.ceil(f2));
            }
        };
        this.setView(this.text);
        this.scrollPane.getViewport().setOpaque(true);
        this.scrollPane.getViewport().setBackground(Color.white);
    }

    public void changeFont(int n, boolean bl) {
        Font font = this.text.getFont();
        font = bl ? new Font("Monospaced", n, font.getSize()) : font.deriveFont(n);
        this.text.setFont(font);
    }

    public void clearText() {
        try {
            this.doc.remove(0, this.doc.getLength());
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
    }

    public String getText() {
        String string = this.text.getText();
        return string == null ? "" : string;
    }

    public void setText(String string) {
        this.text.setText(string);
    }

    public int appendText(String string, AttributeSet attributeSet) {
        try {
            int n = this.doc.getLength();
            this.doc.insertString(n, string, attributeSet);
            n = this.doc.getLength();
            this.selectPosition(n);
            return n;
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
            return this.doc.getLength();
        }
    }

    public void selectPosition(int n) {
        this.text.select(n, n);
    }

    public void select(int n, int n2) {
        this.text.requestFocusInWindow();
        this.text.select(n, n2);
    }

    public JButton addButton(Action action, int n) {
        JButton jButton = new JButton(action);
        this.addTool(jButton, n);
        return jButton;
    }

    public Style addStyle(String string, Color color) {
        return this.addStyle(string, color, true);
    }

    public Style addStyle(String string, Color color, boolean bl) {
        Style style = this.doc.addStyle(string, null);
        StyleConstants.setForeground(style, color);
        StyleConstants.setBold(style, bl);
        return style;
    }

    public MutableAttributeSet mutableStyle(Style style) {
        return new SimpleAttributeSet(style);
    }

    public JTextPane getTextPane() {
        return this.text;
    }

    public void hyperlinkMessage(String string, Style style, Object object) {
        MutableAttributeSet mutableAttributeSet = this.mutableStyle(style);
        mutableAttributeSet.addAttribute(LINK_ATTR, object);
        this.appendText(string, mutableAttributeSet);
    }

    public void caretUpdate(CaretEvent caretEvent) {
        Element element = this.doc.getCharacterElement(caretEvent.getDot());
        if (element == null) {
            return;
        }
        Object object = element.getAttributes().getAttribute(LINK_ATTR);
        if (object != null) {
            this.linkAction(object, caretEvent.getDot());
        }
    }

    protected void linkAction(Object object, int n) {
    }

    public void enableUndo() {
        this.undoer = new UndoManager();
        this.doc.addUndoableEditListener(this);
        this.undoAction = new BasicAction("Undo", GUI.getIcon("undo.png"), "cmdUndo", this);
        GUI.bindAction(this, "control Z", "undo", this.undoAction);
        this.redoAction = new BasicAction("Redo", GUI.getIcon("redo.png"), "cmdRedo", this);
        GUI.bindAction(this, "control Y", "redo", this.redoAction);
    }

    public Action getAction(String string) {
        if ("undo".equals(string)) {
            return this.undoAction;
        }
        if ("redo".equals(string)) {
            return this.redoAction;
        }
        return GUI.getAction(this.text, string);
    }

    protected void enableUndoEvents(boolean bl) {
        this.recordUndoEdits = bl;
    }

    public void undoableEditHappened(UndoableEditEvent undoableEditEvent) {
        UndoableEdit undoableEdit = undoableEditEvent.getEdit();
        if (!this.recordUndoEdits) {
            return;
        }
        this.undoer.addEdit(undoableEdit);
        this.undoActionsEnable();
    }

    public void cmdUndo(ActionEvent actionEvent, BasicAction basicAction) {
        if (this.undoer.canUndo()) {
            this.undoer.undo();
        }
        this.undoActionsEnable();
    }

    public void cmdRedo(ActionEvent actionEvent, BasicAction basicAction) {
        if (this.undoer.canRedo()) {
            this.undoer.redo();
        }
        this.undoActionsEnable();
    }

    private void undoActionsEnable() {
        this.undoAction.setEnabled(this.undoer.canUndo());
        this.redoAction.setEnabled(this.undoer.canRedo());
    }
}

