/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.apps.studio.gui;

import com.qizx.apps.studio.gui.TextPort;
import com.qizx.util.logging.LogFormatter;
import java.awt.Color;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.swing.text.Style;

public class TextPortLogger
extends Handler {
    protected TextPort textPort;
    protected Style errorStyle;
    protected Style warningStyle;

    public TextPortLogger(TextPort textPort) {
        this.textPort = textPort;
        LogFormatter logFormatter = new LogFormatter();
        logFormatter.setStackMax(0);
        this.setFormatter(logFormatter);
        this.errorStyle = textPort.addStyle("error", Color.red, false);
        this.warningStyle = textPort.addStyle("warning", new Color(240, 100, 0), false);
    }

    protected void newEvent(Level level) {
    }

    public void publish(LogRecord logRecord) {
        if (!this.isLoggable(logRecord)) {
            return;
        }
        Style style = null;
        if (logRecord.getLevel() == Level.SEVERE) {
            style = this.errorStyle;
        } else if (logRecord.getLevel() == Level.WARNING) {
            style = this.warningStyle;
        }
        this.textPort.appendText(this.getFormatter().format(logRecord), style);
        this.newEvent(logRecord.getLevel());
    }

    public void flush() {
    }

    public void close() throws SecurityException {
    }
}

