/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.apps.studio.gui;

import com.qizx.apps.studio.gui.GUI;
import com.qizx.apps.studio.gui.ToolView;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.Rectangle2D;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class TreePort
extends ToolView {
    private JTree tree;
    private DefaultTreeModel model;
    private Renderer renderer = new Renderer();

    public TreePort(String string, boolean bl, TNode tNode) {
        super(string, null);
        this.model = new DefaultTreeModel(tNode, false);
        this.tree = new JTree(this.model);
        this.tree.setRootVisible(bl);
        this.tree.setCellRenderer(this.renderer);
        this.tree.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 4));
        ToolTipManager.sharedInstance().registerComponent(this.tree);
        this.setView(this.tree);
        this.tree.setToggleClickCount(Integer.MAX_VALUE);
        this.tree.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                this.showPopup(mouseEvent);
                if (mouseEvent.getClickCount() >= 2) {
                    TreePath treePath = TreePort.this.tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                    if (treePath == null) {
                        return;
                    }
                    TNode tNode = (TNode)treePath.getLastPathComponent();
                    tNode.doubleClick(mouseEvent, TreePort.this);
                }
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                this.showPopup(mouseEvent);
            }

            private void showPopup(MouseEvent mouseEvent) {
                TNode tNode;
                JPopupMenu jPopupMenu;
                TreePath treePath = TreePort.this.tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                if (treePath == null) {
                    return;
                }
                if (!mouseEvent.isShiftDown()) {
                    TreePort.this.tree.setSelectionPath(treePath);
                }
                if (mouseEvent.isPopupTrigger() && (jPopupMenu = (tNode = (TNode)treePath.getLastPathComponent()).getPopupMenu()) != null) {
                    jPopupMenu.show(TreePort.this.tree, mouseEvent.getX(), mouseEvent.getY());
                }
            }
        });
        this.tree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                TNode tNode = (TNode)treeSelectionEvent.getPath().getLastPathComponent();
                if (tNode != null) {
                    tNode.selected(treeSelectionEvent);
                }
            }
        });
    }

    public void changeFont(int n, boolean bl) {
        Font font = this.tree.getFont();
        font = bl ? new Font("Monospaced", n, font.getSize()) : font.deriveFont(n);
        this.tree.setFont(font);
    }

    public void changeRoot(TNode tNode) {
        this.model.setRoot(tNode);
        this.tree.revalidate();
        this.tree.repaint();
    }

    public TNode getRoot() {
        return (TNode)this.model.getRoot();
    }

    public void removeNode(TNode tNode) {
        this.model.removeNodeFromParent(tNode);
    }

    public void refreshNode(TNode tNode) {
        this.model.nodeChanged(tNode);
    }

    public void rebuildNode(TNode tNode) {
        if (tNode != null) {
            tNode.removeAllChildren();
            this.model.nodeStructureChanged(tNode);
            this.model.nodeChanged(tNode);
        }
    }

    public void removeAllChildren(TNode tNode) {
        tNode.removeAllChildren();
        this.model.nodeStructureChanged(tNode);
    }

    public void didChange() {
        this.tree.treeDidChange();
    }

    public void expandAll() {
        TreeNode treeNode = (TreeNode)this.model.getRoot();
        this.expandOrCollapseAll(new TreePath(treeNode), true);
    }

    public void expandAllVisible(int n) {
        int n2 = n;
        for (int i = 0; i < n2; ++i) {
            this.tree.expandRow(i);
        }
    }

    public void expandOrCollapse(TNode tNode) {
        tNode.getParent();
        TreePath treePath = this.buildTreePath(tNode);
        this.expandOrCollapseAll(treePath, this.tree.isCollapsed(treePath));
        this.tree.treeDidChange();
    }

    public TreePath buildTreePath(TreeNode treeNode) {
        if (this.model.getRoot() == treeNode) {
            return new TreePath(treeNode);
        }
        TreePath treePath = this.buildTreePath(treeNode.getParent());
        return treePath.pathByAddingChild(treeNode);
    }

    public boolean isExpanded(TNode tNode) {
        TreePath treePath = this.buildTreePath(tNode);
        return this.tree.isExpanded(treePath);
    }

    private void expandOrCollapseAll(TreePath treePath, boolean bl) {
        TNode tNode = (TNode)treePath.getLastPathComponent();
        if (tNode.getChildCount() >= 0) {
            Enumeration<TreeNode> enumeration = tNode.children();
            while (enumeration.hasMoreElements()) {
                TreeNode treeNode = enumeration.nextElement();
                TreePath treePath2 = treePath.pathByAddingChild(treeNode);
                this.expandOrCollapseAll(treePath2, bl);
            }
        }
        if (bl) {
            tNode.getChildCount();
            this.tree.expandPath(treePath);
        } else {
            this.tree.collapsePath(treePath);
        }
    }

    public TreePath convertPath(TreePath treePath) {
        TNode tNode;
        TNode tNode2;
        TNode tNode3 = this.getRoot();
        if (tNode3 == null) {
            return null;
        }
        int n = treePath.getPathCount();
        ArrayList<TNode> arrayList = new ArrayList<TNode>(n);
        arrayList.add(tNode3);
        TNode tNode4 = tNode3;
        for (int i = 1; i < n && (tNode2 = tNode4.getChild(tNode = (TNode)treePath.getPathComponent(i))) != null; ++i) {
            arrayList.add(tNode2);
            tNode4 = tNode2;
        }
        return new TreePath(arrayList.toArray());
    }

    public void smartRefresh(TNode tNode) {
        Enumeration<TreePath> enumeration = this.tree.getExpandedDescendants(this.tree.getPathForRow(0));
        ArrayList<TreePath> arrayList = new ArrayList<TreePath>();
        while (enumeration != null && enumeration.hasMoreElements()) {
            TreePath treePath = enumeration.nextElement();
            arrayList.add(treePath);
        }
        if (tNode == null) {
            tNode = (TNode)this.model.getRoot();
        }
        if (tNode != null) {
            tNode.removeAllChildren();
        }
        this.model.nodeStructureChanged(tNode);
        for (int i = 0; i < arrayList.size(); ++i) {
            TreePath treePath = (TreePath)arrayList.get(i);
            this.tree.expandPath(this.convertPath(treePath));
        }
    }

    public void collapseSelectedPath() {
        this.tree.collapsePath(this.tree.getSelectionPath());
    }

    public JTree getTree() {
        return this.tree;
    }

    public Renderer getRenderer() {
        return this.renderer;
    }

    public static class Renderer
    extends DefaultTreeCellRenderer {
        private TNode currentNode;
        private Color[] colors = new Color[10];

        Renderer() {
            this.colors[0] = Color.black;
            this.colors[1] = Color.red;
            this.colors[2] = Color.green;
            this.colors[3] = Color.blue;
            this.colors[4] = Color.gray;
            this.colors[5] = Color.orange;
        }

        public void setColor(int n, Color color) {
            if (n >= 0 && n < this.colors.length) {
                this.colors[n] = color;
            }
        }

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            this.setToolTipText(null);
            this.setIcon(null);
            this.currentNode = (TNode)object;
            super.getTreeCellRendererComponent(jTree, this.currentNode, bl, bl2, bl3, n, bl4);
            this.setIcon(this.currentNode.getIcon(this.selected, bl2));
            String string = this.currentNode.getToolTip();
            if (string != null) {
                this.setToolTipText(string);
            }
            this.currentNode.render(this, bl, bl2);
            return this;
        }

        public void paint(Graphics graphics) {
            if (!(this.currentNode instanceof ColoredNode)) {
                super.paint(graphics);
            } else {
                Color color;
                if (this.selected) {
                    color = Color.lightGray;
                } else {
                    color = this.getBackgroundNonSelectionColor();
                    if (color == null) {
                        color = this.getBackground();
                    }
                }
                int n = -1;
                if (color != null) {
                    graphics.setColor(color);
                    if (this.getComponentOrientation().isLeftToRight()) {
                        graphics.fillRect(n, 0, this.getWidth() - 1 - n, this.getHeight());
                    } else {
                        graphics.fillRect(0, 0, this.getWidth() - 1 - n, this.getHeight());
                    }
                }
            }
            this.currentNode.paint(this, graphics);
        }

        public void paintSections(String string, StringBuffer stringBuffer, Graphics graphics) {
            int n = 0;
            int n2 = 0;
            Graphics2D graphics2D = (Graphics2D)graphics;
            FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
            Font font = this.getFont();
            LineMetrics lineMetrics = font.getLineMetrics("m", fontRenderContext);
            int n3 = 1 + (int)lineMetrics.getAscent();
            if (stringBuffer != null) {
                for (int i = 0; i < stringBuffer.length(); i += 2) {
                    char c = stringBuffer.charAt(i);
                    graphics.setColor(this.colors[c]);
                    char c2 = stringBuffer.charAt(i + 1);
                    String string2 = string.substring(n, c2);
                    graphics.drawString(string2, n2, n3);
                    Rectangle2D rectangle2D = font.getStringBounds(string2, fontRenderContext);
                    double d = rectangle2D.getWidth() + 0.5;
                    n2 += (int)d;
                    n = c2;
                }
            } else {
                graphics.setColor(Color.red);
                graphics.drawString(string, 0, n3);
            }
        }
    }

    public static class NodeAction
    extends AbstractAction {
        Object app;
        String method;
        TNode[] source;

        public NodeAction(String string, Object object, String string2, TNode tNode) {
            super(string);
            this.app = object;
            this.method = string2;
            this.source = new TNode[]{tNode};
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                Method method = this.app.getClass().getMethod(this.method, this.source[0].getClass());
                method.invoke(this.app, (Object[])this.source);
            }
            catch (InvocationTargetException invocationTargetException) {
                System.err.println("error in " + this.method + " " + invocationTargetException.getCause());
                GUI.error(invocationTargetException.getCause());
            }
            catch (Throwable throwable) {
                GUI.error(throwable);
            }
        }
    }

    public static class ErrorNode
    extends ColoredNode {
        private Throwable err;

        public ErrorNode(Throwable throwable) {
            this.err = throwable;
        }

        protected void procreate() {
        }

        public boolean isLeaf() {
            return true;
        }

        public String toString() {
            return "*** " + this.err.getMessage() + " ***";
        }
    }

    public static abstract class ColoredNode
    extends TNode {
        protected StringBuffer sections;

        protected void endSection(StringBuilder stringBuilder, int n) {
            if (this.sections == null) {
                this.sections = new StringBuffer();
            } else if (this.sections.charAt(this.sections.length() - 2) == n) {
                this.sections.setLength(this.sections.length() - 2);
            }
            this.sections.append((char)n);
            this.sections.append((char)stringBuilder.length());
        }

        public void paint(Renderer renderer, Graphics graphics) {
            try {
                renderer.paintSections(this.toString(), this.sections, graphics);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    public static abstract class TLeaf
    extends TNode {
        public boolean isLeaf() {
            return true;
        }

        public void procreate() {
        }
    }

    public static abstract class TNode
    extends DefaultMutableTreeNode
    implements ActionListener {
        protected abstract void procreate();

        protected Icon getIcon(boolean bl, boolean bl2) {
            return null;
        }

        protected String getToolTip() {
            return null;
        }

        protected void selected(TreeSelectionEvent treeSelectionEvent) {
        }

        protected void doubleClick(MouseEvent mouseEvent, TreePort treePort) {
            treePort.expandOrCollapse(this);
        }

        protected JPopupMenu getPopupMenu() {
            return null;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            System.err.println("menu action " + actionEvent);
        }

        public TreeNode getChildAt(int n) {
            if (this.children == null) {
                this.children = new Vector();
                try {
                    this.procreate();
                }
                catch (Throwable throwable) {
                    GUI.error(throwable);
                }
            }
            return super.getChildAt(n);
        }

        public int getChildCount() {
            if (this.children == null) {
                this.children = new Vector();
                try {
                    this.procreate();
                }
                catch (Throwable throwable) {
                    GUI.error(throwable);
                }
            }
            return super.getChildCount();
        }

        public TNode getChild(TNode tNode) {
            int n = this.getChildCount();
            while (--n >= 0) {
                TNode tNode2 = (TNode)super.getChildAt(n);
                if (!tNode.equals(tNode2)) continue;
                return tNode2;
            }
            return null;
        }

        public TNode getAncestor(Class clazz) {
            for (TreeNode treeNode = this.getParent(); treeNode != null; treeNode = treeNode.getParent()) {
                if (!clazz.isInstance(treeNode)) continue;
                return (TNode)treeNode;
            }
            return null;
        }

        public boolean isLeaf() {
            return false;
        }

        public void removeAllChildren() {
            super.removeAllChildren();
            this.children = null;
        }

        public boolean equals(Object object) {
            return this == object;
        }

        public void render(Renderer renderer, boolean bl, boolean bl2) {
        }

        public void paint(Renderer renderer, Graphics graphics) {
        }
    }
}

