/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.apps.studio.gui;

import com.qizx.api.DataModelException;
import com.qizx.api.Node;
import com.qizx.api.QName;
import com.qizx.api.QizxException;
import com.qizx.apps.studio.gui.GUI;
import com.qizx.apps.studio.gui.TreePort;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class XdmNode
extends TreePort.TNode {
    private static final int MAX_LINE = 200;
    private static final int MAX_CHILDREN = 10000;
    static ImageIcon atomIcon = GUI.getIcon("atom.png");
    static ImageIcon elementIcon = GUI.getIcon("element.png");
    static ImageIcon textIcon = GUI.getIcon("text.png");
    static ImageIcon attrIcon = GUI.getIcon("attr.png");
    static ImageIcon piIcon = GUI.getIcon("pi.png");
    static ImageIcon commentIcon = GUI.getIcon("comment.png");
    static ImageIcon documentIcon = GUI.getIcon("document.png");
    protected Node node;

    public XdmNode(Node node) {
        this.node = node;
    }

    public boolean isLeaf() {
        return this.node == null || !this.node.isNode();
    }

    protected void procreate() {
        try {
            Node[] nodeArray = this.node.getAttributes();
            if (nodeArray != null) {
                for (int i = 0; i < nodeArray.length; ++i) {
                    this.add(new XdmNode(nodeArray[i]));
                }
            }
            int n = 0;
            for (Node node = this.node.getFirstChild(); node != null; node = node.getNextSibling()) {
                this.add(new XdmNode(node));
                if (++n <= 10000) continue;
                this.add(new XdmNode(null));
                break;
            }
        }
        catch (QizxException qizxException) {
            GUI.error(qizxException);
        }
    }

    public String toString() {
        if (this.node == null) {
            return "... more ...";
        }
        try {
            String string = this.node.getNodeKind();
            QName qName = this.node.getNodeName();
            switch (this.node.getNodeNature()) {
                case 1: {
                    return string;
                }
                case 2: {
                    StringBuffer stringBuffer = new StringBuffer(string + " " + qName);
                    return stringBuffer.toString();
                }
                case 7: {
                    String string2 = this.node.getStringValue();
                    if (string2.length() > 200) {
                        string2 = string2.substring(0, 200) + " ...";
                    }
                    return string + " |" + string2 + "|";
                }
                case 6: {
                    return string + " <!--" + this.node.getStringValue() + "-->";
                }
                case 5: {
                    return string + " <?" + qName + " " + this.node.getStringValue() + "?>";
                }
                case 3: 
                case 4: {
                    return string + " " + this.node.getNodeName().toString() + "=\"" + this.node.getStringValue() + '\"';
                }
            }
            return string;
        }
        catch (Exception exception) {
            return exception.toString();
        }
    }

    protected String getToolTip() {
        if (this.node == null) {
            return "too many nodes";
        }
        try {
            return this.node.getNodeKind() + " node";
        }
        catch (DataModelException dataModelException) {
            return "Error: " + dataModelException;
        }
    }

    public Icon getIcon(boolean bl, boolean bl2) {
        if (this.node == null) {
            return null;
        }
        try {
            switch (this.node.getNodeNature()) {
                case 1: {
                    return documentIcon;
                }
                case 2: {
                    return elementIcon;
                }
                case 3: {
                    return attrIcon;
                }
                case 5: {
                    return piIcon;
                }
                case 7: {
                    return textIcon;
                }
                case 6: {
                    return commentIcon;
                }
            }
            return atomIcon;
        }
        catch (DataModelException dataModelException) {
            return null;
        }
    }
}

