/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Button;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;

class ClipboardFrame
extends Frame
implements WindowListener,
ActionListener {
    TextArea textArea;
    Button clearButton;
    Button closeButton;
    String selection;
    VncViewer viewer;

    ClipboardFrame(VncViewer vncViewer) {
        super("Ultr@VNC Clipboard");
        this.viewer = vncViewer;
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        this.textArea = new TextArea(5, 40);
        gridBagLayout.setConstraints(this.textArea, gridBagConstraints);
        this.add(this.textArea);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        this.clearButton = new Button("Clear");
        gridBagLayout.setConstraints(this.clearButton, gridBagConstraints);
        this.add(this.clearButton);
        this.clearButton.addActionListener(this);
        this.closeButton = new Button("Close");
        gridBagLayout.setConstraints(this.closeButton, gridBagConstraints);
        this.add(this.closeButton);
        this.closeButton.addActionListener(this);
        this.pack();
        this.addWindowListener(this);
    }

    void setCutText(String string) {
        this.selection = string;
        this.textArea.setText(string);
        if (this.isVisible()) {
            this.textArea.selectAll();
        }
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
        if (this.selection != null && !this.selection.equals(this.textArea.getText())) {
            this.selection = this.textArea.getText();
            this.viewer.setCutText(this.selection);
        }
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
        this.setVisible(false);
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.clearButton) {
            this.textArea.setText("");
        } else if (actionEvent.getSource() == this.closeButton) {
            this.setVisible(false);
        }
    }
}

