/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.dataAccess.cgm;

import com.bbn.openmap.dataAccess.cgm.CGMDisplay;
import com.bbn.openmap.dataAccess.cgm.ColorTable;
import com.bbn.openmap.dataAccess.cgm.Command;
import com.bbn.openmap.omGraphics.OMColor;
import java.awt.Color;
import java.io.DataInputStream;
import java.io.IOException;

public class ColorCommand
extends Command {
    int R;
    int G;
    int B;
    Color C;
    Color[] Colors = new Color[]{Color.black, Color.white, Color.green, Color.yellow, Color.blue, Color.magenta, Color.cyan, Color.red, Color.black.brighter(), Color.white.darker(), Color.green.darker(), Color.yellow.darker(), Color.blue.darker(), Color.magenta.darker(), Color.cyan.darker(), Color.red.darker()};
    int index = -1;

    public ColorCommand(int ec, int eid, int l, DataInputStream in) throws IOException {
        super(ec, eid, l, in);
        if (this.args.length >= 3) {
            this.R = this.args[0];
            this.G = this.args[1];
            this.B = this.args[2];
            this.C = new Color(this.R, this.G, this.B);
        } else if (this.args.length > 0 && this.args[0] >= 1 && this.args[0] <= this.Colors.length) {
            this.C = this.Colors[this.args[0] - 1];
        } else if (this.args.length == 1) {
            this.index = this.args[0];
            logger.fine("index set for color: " + this.index);
        } else {
            this.C = new Color(128, 128, 128);
        }
    }

    public String toString() {
        return "Fill Color Input " + this.R + "," + this.G + "," + this.B;
    }

    public void paint(CGMDisplay d) {
        d.setFillColor(this.C);
    }

    public void setColorFromColorTable(ColorTable ct) {
        if (this.index != -1) {
            this.C = ct.get(this.index);
            if (this.C != null) {
                this.R = this.C.getRed();
                this.G = this.C.getGreen();
                this.B = this.C.getBlue();
            } else {
                this.C = OMColor.clear;
                this.R = 0;
                this.G = 0;
                this.B = 0;
            }
        }
    }
}

