/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.dataAccess.cgm;

import com.bbn.openmap.dataAccess.cgm.CGMDisplay;
import com.bbn.openmap.dataAccess.cgm.Command;
import java.awt.Color;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.logging.Level;

public class ColorTable
extends Command {
    protected Color[] colors;
    protected boolean drawColorTable = false;
    int startingIndex = 0;

    public ColorTable(int ec, int eid, int l, DataInputStream in) throws IOException {
        super(ec, eid, l, in);
        if (this.args != null) {
            this.startingIndex = this.args[0];
            logger.fine("starting table index: " + this.startingIndex);
            this.colors = new Color[this.args.length - 0];
            for (int i = 1; i < this.args.length - 3; i += 3) {
                int index = i / 3;
                int r = this.args[i];
                int g = this.args[i + 1];
                int b = this.args[i + 2];
                logger.fine("Color[" + index + "] r: " + r + ", g: " + g + ", b: " + b);
                this.colors[index] = new Color(r, g, b);
            }
        }
    }

    public String toString() {
        return "ColorTable has " + this.args.length + " colors";
    }

    public Color get(int index) {
        if (this.colors != null && (index -= this.startingIndex) < this.colors.length) {
            return this.colors[index];
        }
        return Color.GRAY;
    }

    public void paint(CGMDisplay d) {
        if (logger.isLoggable(Level.FINE)) {
            int dim = 30;
            int x = 0;
            int y = 0;
            int width = dim;
            int height = dim;
            int count = 0;
            for (Color c : this.colors) {
                if (count > 4) {
                    count = 0;
                    y += height;
                    x = 0;
                }
                d.graphics().setColor(c);
                d.graphics().fillRect(x, y, width, height);
                x += width;
                ++count;
            }
        }
    }
}

